<?php 
include("includes/inc-config.php");

include("includes/inc-header.php");

if(isset($_GET['zine'])){
    $dossier_seul=$_GET['zine'];
    $dossier_zine=CHEMIN.DOSSIER_COURANT."/".$dossier_seul;
    if(!is_dir($dossier_zine)){
        die ("le dossier n'existe pas");
    }
    include(CHEMIN."includes/yaml-readwriteclass.php");
    $zine=new yamlreadwrite();
    $source=$dossier_zine."/config_zine.yaml";
    $zine->yamlread($source);
    $infos=$zine->yaml_simple_array();
    
} else {
    die("pas de zine demandé! Erreur !");
}
?>
<main id="main" class="container-fluid px-4">
    <div class="row my-4">
        <div class="col-12 mb-3">
            <h3 class="mb-2">Participer à<br>"<?= $infos["titre_zine"]; ?>"</h3>
            <div class="texte-small mb-3"><?= $infos["descriptif_zine"]; ?></div>
        </div>
        <div class="col-12 col-sm-6 texte">
            <div class="texte mb-4">
                <?= $infos["consignes_zine"]; ?>
            </div>

            <form method="post" action="proposition_controler.php" class="form" enctype="multipart/form-data">
                <div class="mb-3">
                    <h4 class="titre-medium">1) Choisissez votre fichier</h4>
                    <input class="form-control" type="file" name="recit-fichier">
                </div>
                <div class="mb-3">
                    <input type="hidden" name="dossier_zine" value="<?= $dossier_seul; ?>">
                    <input type="submit" name="image_soumettre" class="btn btn-success" value="Uploader">
                </div>
            </form>
        </div>

        <div class="col-12 col-sm-6">
            <div class="border border-primary rounded p-4 translucide">
                <h2 class="titre-small">Contraintes techniques générales</h2>
                <div class="texte my-3">
                    <p>Le format d'impression est <?= $infos["format_zine"]; ?>. Préparez vos fichiers en 300 dpi de ce format.</p>
                    <p>Les fichiers doivent être en jpg, png ou gif.</p>
                    <p>Les marges d'impression sont de <?= $infos["taille_marge"]; ?> mm. Laissez le moins de marge possible dans votre fichier sauf si elle fait partie de la mise en page.
                    </p>
                    <p>
                        Nettoyer les bords de votre fichier ! C'est un détail qui change tout.
                    </p>
                </div>
            </div>
        </div>
    </div>

</main>

<?php 
include("includes/inc-footer.php");