<?php 
class yamlreadwrite {
    public $source;
    public $destination;
    public $contenu;

    function __construct() {
        $this->contenu=false;
    }

    public function yamlread($temp_source){
        if(!is_file($temp_source)){
            echo "No file!";
            return false;
        }
        $this->source=$temp_source;
        $this->destination=$temp_source;
        $this->contenu = Spyc::YAMLLoad($this->source); 
        return true;
    }

    public function yamlwrite($array=""){
        if(!is_array($array)){
            $array=$this->contenu;
        }
        $yaml_str = Spyc::YAMLDump($array);
        if(file_exists($this->source)){
            chmod($this->source, 0777); // autoriser la réécriture
        }
        $retour=file_put_contents($this->source,$yaml_str);
        return $retour;
    }

    // ecrit le formulaire sur base des données du yaml
    public function yamltoform($action="ok"){
        echo "<input type=\"hidden\" name=\"source\" value=\"".$this->source."\">";
        foreach($this->contenu as $cle=> $valeur){
            
            if($valeur['type'] == "hidden"){
                echo "<input type=\"hidden\" name=\"".$cle."\" value=\"".$valeur['contenu']."\">";
                continue;
            }
            
            
            
            echo "<fieldset class=\"mb-4\"><h4 class=\"titre-small mb-1\">".$valeur['titre']."</h4>";
            if(isset($valeur['comment'])){
                echo "<div class=\"texte-small mb-1\">".$valeur['comment']."</div>";
            }
            switch($valeur['type']){
                case "text":
                case "number":
                    echo "<input class=\"form-control form-control-sm\" type=\"".$valeur['type']."\" name=\"".$cle."\" value=\"".$valeur['contenu']."\">";
                    break;

                case "textarea":
                    echo "<textarea class=\"form-control form-control-sm\"  name=\"".$cle."\">".$valeur['contenu']."</textarea>";
                    break;

                case "radio":
                    echo "<div>";
                    $ex=explode("|",$valeur['valeurs']);
                    foreach($ex as $n => $val){
                        echo "<div class=\"form-check form-check-inline form-control-sm\">";
                        echo "<input id=\"".$this->stripAccents($valeur['titre']).$val."\" class=\"form-check-input form-control-sm\" type=\"radio\" name=\"".$cle."\" value=\"".$val."\"";
                        if($val==$valeur['contenu']){
                            echo " checked=\"checked\"";
                        }
                        echo ">";
                        echo "<label class=\"form-check-label form-control-sm\" for=\"".$this->stripAccents($valeur['titre']).$val."\">".$val."</label></div>";
                    }
                    echo "</div>";
                    break;
                case "login":
                    $access=explode("|§|",$valeur['contenu']);
                    echo "<label class=\"texte-tiny texte-fat\">Nom d'utilisateur</label>";
                    echo "<input class=\"form-control form-control-sm mb-2\" type=\"text\" name=\"".$cle."[]\" placeholder=\"Nom d'utilisateur\" value=\"".$valeur['titre']."\">";
                    echo "<label class=\"texte-tiny texte-fat\">Login</label>";
                    echo "<input class=\"form-control form-control-sm mb-2\" type=\"text\" name=\"".$cle."[]\" placeholder=\"Login\" value=\"".$access[0]."\">";
                    echo "<label class=\"texte-tiny texte-fat\">Mot de passe</label>";
                    echo "<input class=\"form-control form-control-sm\" type=\"password\" name=\"".$cle."[]\" placeholder=\"Laisser vide pour garder le mot de passe actuel\">";
                    break;

                case "automatic":
                    if(!$valeur['contenu']){
                        $var1 = $valeur['fonction'];
                        $valeur['contenu']=$var1();
                    }
                    echo "<input type=\"text\" name=\"".$cle."\" readonly class=\"form-control-plaintext\" value=\"".$valeur['contenu']."\">";
                    break;
            }
            echo "</fieldset>";
            // traitement  de after
            if(isset($valeur['after'])){
                if($valeur['after']=="separateur"){
                    echo "<hr class='my-5'>";
                }


                if($valeur['after']=="espace"){
                    echo "<div class='mb-5'></div>";
                }
            }
        }
        echo "<div class=\"mb-3\" data-role=\"submit\"><input type=\"submit\" name=\"submit\" class=\"btn btn-success text-light\" value=\"".$action."\"></div>";
    }

    // lire le post, populer le tout
    public function yamlfrompost($save=false){
        $message=array();
        if(empty($_POST)){
            return false;
        }

        $fichier=$_POST["source"];
        // charger le fichier d'origine
        unset($_POST["source"]);
        unset($_POST["submit"]);
        foreach($_POST as $cle => $valeur){

            // cas spécifique des logins
            if(substr($cle, 0, 5)=="user_"){
                // si c'est une nouvelle entrée
                if(!isset($this->contenu[$cle])){
                    // verifier que les login et mot de passe sont ok

                    if(!trim($valeur[0]) || !trim($valeur[1]) || !trim($valeur[2])){
                        $message[]="Infos manquantes pour la création du nouveau login!";
                        continue;
                    }
                    // le login doit être unique
                    $login_ok=true;
                    foreach($this->contenu as $u => $i){
                        $a=explode("|§|",$i['contenu']);
                        if($a[0] == $valeur[1]){
                            $login_ok=false;
                        }
                    }
                    if(!$login_ok){
                        $message[]="Impossible d'utiliser ce login pour un nouvel utilisateur!<br>Prenez en un autre.";
                        continue;
                    }

                    $message[]="Creation d'un nouveau admin";
                    $nouvelle_cle="user_".count($this->contenu);

                    $this->contenu[$nouvelle_cle]=array(
                        "type"=>"login",
                        "titre"=>$valeur[0],
                        "niveau"=>"admin",
                        "contenu"=>$valeur[1]."|§|".crypt($valeur[2], 'rl'),
                        "after"=>"espace"
                    );
                    continue;
                }

                // verifier que le nom d'utilisateur n'est pas vide
                if(!trim($valeur[0])){
                    $message[]="Les noms d'utilisateurs ne peuvent être vide!";
                    $valeur[0]=$this->contenu[$cle]['titre'];
                }

                $this->contenu[$cle]['titre']=$valeur['0'];
                // charger le mot de passe et login original
                $access=explode("|§|",$this->contenu[$cle]['contenu']);

                if(trim($valeur[1])){
                    $access[0]=$valeur[1]; 
                }
                if(trim($valeur[2])){
                    $access[1]=crypt($valeur[2], 'rl');

                }
                $this->contenu[$cle]['contenu']=$access[0]."|§|".$access[1];
            } else {
                if(isset($this->contenu[$cle])){
                    $this->contenu[$cle]['contenu']=trim($valeur); 
                } else {
                    echo "un problème avec la clé ".$cle."<br>";
                }
            }
        }
        if($save){
            $this->yamlwrite();
        }
        return $message;
    }

    // fabrique un array associative cle - valeur
    public function yaml_simple_array(){
        $retour=array();
        foreach($this->contenu as $cle=> $valeur){
            $retour[$cle]=$valeur["contenu"];
        }
        return $retour;
    }

    public function get($tag,$default=""){
        $r="";
        if(isset($this->contenu[$tag])){
            if(is_array($this->contenu[$tag])){
                $r=$this->contenu[$tag]["contenu"];
            } else {
                $r=$this->contenu[$tag];
            }
        } 
        if($r!=""){
            return $r;
        } else {
            return $default; 
        }
    }

    private function stripAccents($string){
        $str = htmlentities($string, ENT_NOQUOTES, 'UTF-8');
        $str = preg_replace('#\&([A-za-])(?:acute|cedil|circ|grave|ring|tilde|uml)\;#', '\1', $str);
        $str = preg_replace('/(\?|\!)/', '', $str);
        $str = strtolower(str_replace(" ","_",$str));
        $str = str_replace(array("#","'",'"'),"",$str);
        return $str;
    }
}
?>