<?php 
include("../includes/inc-config.php");
include(CHEMIN."includes/inc-fonctions.php");

include(CHEMIN."includes/Spyc.php");
include(CHEMIN."includes/yaml-readwriteclass.php");
$zine=new yamlreadwrite(); 

if($_POST['action']=="ecrire"){
    if(isset($_POST['dossier'])){
        $dossier=$_POST['dossier'];

        $zine->yamlread($dossier."/config_zine.yaml");
        $infos = $zine->yaml_simple_array();

        $liste=$_POST['liste'];

        if($infos['publication_single_page'] == "oui"){
            $retour=creer_pdf_single_page($dossier,$liste,$infos);
            echo "PDF single page créé!<br>";
        }
        if($infos['publication_impose'] == "oui"){
            $retour=creer_pdf_impose($dossier,$liste,$infos);
            echo "PDF imposé créé!<br>";
        }
    } else {
        die("echec lors de l'analyse du nom");
    }
}

function creer_pdf_single_page($dossier,$liste,$infos){
    global $tailles_zine;
    require_once(CHEMIN."includes/tcpdf/tcpdf.php");
    $format=$tailles_zine[$infos["format_zine"]];
    $orientation="P";
    if($format['width'] > $format['height']){
        $orientation="L";
    }
    $pdf=new TCPDF($orientation,'mm',array($format['width'], $format['height']), true, 'UTF-8', false);
    $pdf->SetAuthor($infos['editeur_zine']);
    $pdf->SetTitle($infos['titre_zine']);
    $pdf->SetSubject('');
    $pdf->SetKeywords('PDF, zine,automatique');

    $pdf->SetMargins(0,0);
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);
    $pdf->SetAutoPageBreak(false, 0);

    // set display mode
    $pdf->SetDisplayMode($zoom='fullpage', $layout='TwoColumnRight', $mode='UseNone');

    // set pdf viewer preferences
    $pdf->setViewerPreferences(array('Duplex' => 'DuplexFlipLongEdge'));

    // set booklet mode
    $pdf->SetBooklet(true, 10, 30);

    //$pdf->SetFont('#POLICE', '', 28);

    $pdf->setJPEGQuality(80);

    // les textes
    /*
	$pdf->setXY(168.5,44);
	$pdf->SetFont('Courier', '', 6);
	$pdf->MultiCell(30, 5, "EXEMPLAIRE N°#TIRAGE", 0, 'L', 0, 0, '', '', true);

	$pdf->setXY(148.5,44);
	$pdf->MultiCell(148.5, 5, "BASE DE DONNEES K. N°#ID_ARTICLE", 0, 'C', 0, 0, '', '', true);

	$pdf->setXY(265.5,44);
	$pdf->MultiCell(40, 5, "BRUXELLES", 0, 'L', 0, 0, '', '', true);

	$pdf->setXY(168.5,47);
	$pdf->MultiCell(148.5, 5, "[(#DATE|jour)]/[(#DATE|mois)]/[(#DATE|annee)]", 0, 'L', 0, 0, '', '', true);

	$style = array('width' => 0.1, 'cap' => 'butt', 'join' => 'miter', 'color' => array(0, 0, 0));
	$pdf->Line(227.75-15, 47, 227.75+15, 47, $style); // 30 mm

	$pdf->setXY(148.5,47);
	$pdf->MultiCell(148.5, 5, "\"ENDLESS - ENDLESS\"", 0, 'C', 0, 0, '', '', true);

	$pdf->setXY(275.5,47);
	$pdf->MultiCell(40, 5, "K.", 0, 'L', 0, 0, '', '', true);
	*/

    $redux="IMAGE";

    foreach($liste as $elem => $info){
        $pdf->AddPage();
        $zonex=$format['width']-($infos['taille_marge']*2);
        $zoney=$format['height']-($infos['taille_marge']*2);
        place_image($pdf, $info['src'], $infos['taille_marge'], $infos['taille_marge'], $zonex, $zoney);
    }

    //Close and output PDF document
    $nom_fichier=stripAccents($infos['titre_zine'])."_".stripAccents($infos["format_zine"])."_single_page.pdf";
    $chemin_complet=$dossier."/".$nom_fichier;
    // supprimer le fichier s'il existe
    if(file_exists($chemin_complet)){
        unlink($chemin_complet);
    }
    $pdf->Output($chemin_complet, 'F');
    return array("nom_fichier"=>$nom_fichier,"chemin_complet"=>$chemin_complet);
}

function creer_pdf_impose($dossier,$liste,$infos){
    require_once(CHEMIN."includes/tcpdf/tcpdf.php");
    global $tailles_zine;
    $format=$tailles_zine[$infos["format_zine"]];
    
    if($infos['format_zine']== "A6 vertical"){
        $pdf=new TCPDF('P','mm',array($format['width']*2, $format['height']*2), true, 'UTF-8', false);
    } else {
        $pdf=new TCPDF('L','mm',array($format['width']*2, $format['height']), true, 'UTF-8', false);
    }

    $pdf->SetAuthor($infos['editeur_zine']);
    $pdf->SetTitle($infos['titre_zine']);
    $pdf->SetSubject('');
    $pdf->SetKeywords('PDF, zine,automatique');

    $pdf->SetMargins(0,0);
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);
    $pdf->SetAutoPageBreak(false, 0);

    // set display mode
    $pdf->SetDisplayMode($zoom='fullpage', $layout='TwoColumnRight', $mode='UseNone');

    // set pdf viewer preferences
    $pdf->setViewerPreferences(array('Duplex' => 'DuplexFlipLongEdge'));

    // set booklet mode
    $pdf->SetBooklet(true, 10, 30);

    //$pdf->SetFont('#POLICE', '', 28);

    $pdf->setJPEGQuality(80);

    if($infos['format_zine']== "A6 vertical"){
        // placer les doubles pages 
        // ajouter des pages blanches le nombre de pages n'est pas un multiple de 8
        if(count($liste) %8 > 0){
            $add=8-(count($liste) % 8);
            for($i=0;$i<$add;$i++){
                $liste[]=array("src" => CHEMIN."assets/imgs/blank.jpg");
            }
            echo "Ajouté ".$add." pages pour l'imposition<br>"; 
        }

        $nb_pages=count($liste);

        $zonex=$format['width']-($infos['taille_marge']*2);
        $zoney=$format['height']-($infos['taille_marge']*2);
        for($i=0;$i<($nb_pages/8);$i++){
            // recto
            $un=array_shift($liste);
            $deux=array_shift($liste);
            $trois=array_shift($liste);
            $quatre=array_shift($liste);
            $huit=array_pop($liste);
            $sept=array_pop($liste);
            $six=array_pop($liste);
            $cinq=array_pop($liste);
            
            $pdf->AddPage();
            
            place_image($pdf, $un['src'], $format['width']+$infos['taille_marge'], $infos['taille_marge'], $zonex, $zoney);
            place_image($pdf, $huit['src'], $infos['taille_marge'], $infos['taille_marge'], $zonex, $zoney);
            
            place_image($pdf, $trois['src'], $format['width']+$infos['taille_marge'], $format['height']+$infos['taille_marge'], $zonex, $zoney);
            place_image($pdf, $six['src'], $infos['taille_marge'], $format['height']+$infos['taille_marge'], $zonex, $zoney);

            // verso
            $pdf->AddPage();

            place_image($pdf, $deux['src'], $infos['taille_marge'], $infos['taille_marge'], $zonex, $zoney);
            place_image($pdf, $sept['src'], $format['width']+$infos['taille_marge'], $infos['taille_marge'], $zonex, $zoney);
            
            place_image($pdf, $quatre['src'], $infos['taille_marge'], $format['height']+$infos['taille_marge'], $zonex, $zoney);
            place_image($pdf, $cinq['src'], $format['width']+$infos['taille_marge'], $format['height']+$infos['taille_marge'], $zonex, $zoney);
        }

    } else {
        // placer les doubles pages 
        // ajouter des pages blanches le nombre de pages n'est pas un multiple de 4
        if(!is_array($liste)){ // pas de pages
            for($i=0;$i<4;$i++){
                $liste[]=array("src" => CHEMIN."assets/imgs/blank.jpg");
            }
            echo "Pas d'image fournie!<br>Un PDF de 4 pages blanches a été produit.<br>";
        } else if(count($liste) %4 > 0){
            $add=4-(count($liste) % 4);
            
            for($i=0;$i<$add;$i++){
                $liste[]=array("src" => CHEMIN."assets/imgs/blank.jpg");
            }
            echo "Ajouté ".$add." pages pour l'imposition<br>"; 
        }

        $nb_pages=count($liste);

        $zonex=$format['width']-($infos['taille_marge']*2);
        $zoney=$format['height']-($infos['taille_marge']*2);
        for($i=0;$i<($nb_pages/4);$i++){
            // recto
            $pdf->AddPage();
            $it=array_shift($liste);
            place_image($pdf, $it['src'], $format['width']+$infos['taille_marge'], $infos['taille_marge'], $zonex, $zoney);

            $it=array_pop($liste);
            place_image($pdf, $it['src'], $infos['taille_marge'], $infos['taille_marge'], $zonex, $zoney);

            // verso
            $pdf->AddPage();
            $it=array_shift($liste);
            place_image($pdf, $it['src'], $infos['taille_marge'], $infos['taille_marge'], $zonex, $zoney);

            $it=array_pop($liste);
            place_image($pdf, $it['src'], $format['width']+$infos['taille_marge'], $infos['taille_marge'], $zonex, $zoney);
        }
    }

    //Close and output PDF document
    $nom_fichier=stripAccents($infos['titre_zine'])."_".stripAccents($infos["format_zine"])."_impose.pdf";
    $chemin_complet=$dossier."/".$nom_fichier;

    // supprimer le fichier s'il existe
    if(file_exists($chemin_complet)){
        unlink($chemin_complet);
    }
    $pdf->Output($chemin_complet, 'F');
    return array("nom_fichier"=>$nom_fichier,"chemin_complet"=>$chemin_complet);
}

function place_image($pdf,$image,$pox,$poy,$zonew,$zoneh){
    list($largeur_image, $hauteur_image, $type, $attr) = getimagesize($image);

    // calcul de la taille optimale pour remplir la zone
    $x_ratio = $zonew / $largeur_image;
    $y_ratio = $zoneh / $hauteur_image;

    if($x_ratio > $y_ratio){
        $neo_hauteur_image=$zoneh;
        $neo_largeur_image=($largeur_image*($zoneh/$hauteur_image));
    } else if($x_ratio < $y_ratio) {
        $neo_largeur_image=$zonew;
        $neo_hauteur_image=($hauteur_image*($zonew/$largeur_image));
    }

    $decx=($zonew-$neo_largeur_image)/2;
    $decy=($zoneh-$neo_hauteur_image)/2;

    $pdf->Image($image,$pox+$decx,$poy+$decy,$neo_largeur_image,$neo_hauteur_image);

}
?>