
<?php 
include("../includes/inc-config.php");

include("../includes/inc-header.php");
include("../includes/inc-fonctions.php");
include("inc-admin-header.php");

if(isset($_GET['zine'])){
    $dossier_zine=$_GET['zine'];
    if(!is_dir($dossier_zine)){
        die ("le dossier n'existe pas");
    }
    $source=$dossier_zine."/config_zine.yaml";

    include(CHEMIN."includes/Spyc.php");
    include(CHEMIN."includes/yaml-readwriteclass.php");
    $zine=new yamlreadwrite(); 
    $zine->yamlread($source);
    $infos = $zine->yaml_simple_array();


} else {
    die("pas de zine demandé! Erreur !");
}
?>
<script src="<?= URL; ?>assets/Sortable.min.js"></script>
<link rel="stylesheet" href="<?= URL; ?>assets/Sortable.css">
<main id="main" class="container-fluid px-4">

    <div id="toast-container" class="position-absolute end-0 me-4 d-none">
        <div class="toast align-items-center" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="d-flex">
                <div class="toast-body texte-tiny" id="corps_toast">
                </div>
                <button type="button" class="btn-close me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
        </div>
    </div>
    <div class="row my-4">
        <div class="col texte">
            <h3 class="mb-3">Générer le PDF "<?= $infos["titre_zine"]; ?>"</h3>
            <div class="row align-items-end">

                <div class="col-12 col-sm-6 texte-small">
                    <div class="list-group list-group-horizontal" id="controller">
                        <div class="list-group-item flex-grow-1">
                            <h4 class="text-primary">Contrôle</h4>
                            <div class="texte-fat texte-small mb-2">Le fanzine comporte <span id="compteur_page">0</span> pages</div>
                            <?php 
                            if($infos["publication_single_page"]=="oui"){
                            ?>
                            <span class="badge bg-success" id="pdf_single">PDF single page OK?</span> 
                            <?php
                            }
                            if($infos["publication_impose"]=="oui"){
                            ?>
                            <span class="badge bg-success" id="pdf_impose">PDF imposé OK?</span>
                            <?php
                            }
                            ?>
                        </div>
                        <a id="pdf_ok" href="#" class="list-group-item bg-primary text-light texte-ultra" onclick="creer_pdf('<?= $dossier_zine; ?>')" title="générer les PDF"><i class="bi bi-printer ico-ready"></i><i class="ico-wait bi bi-gear-wide"></i></a>
                    </div>

                </div>
                <div class="col-12 col-sm-6 text-end">
                <div class="btn-group mb-3" role="group" aria-label="Basic example">
                    <a type="button" class="btn btn-primary" href="config_zine.php?zine=<?= $dossier_zine; ?>">Infos du zine</a>
                    <a type="button" class="btn btn-primary" href="zine_gerer_propositions.php?zine=<?= $dossier_zine; ?>">Propositions pour le zine</a>
                    <a type="button" class="btn btn-primary disabled" href="zine_publier.php?zine=<?= $dossier_zine; ?>">Générer le PDF</a>
                    
                </div>


                </div>
            </div>
        </div>
    </div>

    <section id="montage" class="sortable-parent">
        <ol id="sortable-montage" class="shared">
            <?php
            lister_images_zine($dossier_zine);
            ?>  
        </ol>
    </section>
    <section id="reservoir" class="sortable-parent">
        <ol id="sortable-reservoir" class="shared">
        </ol>
    </section>

    <div id="tools" class="mb-4">
        <section>
            <button class="btn btn-sm btn-primary" onclick="initialise();">Remettre à zéro</button>
            <button class="btn btn-sm btn-primary" onclick="add_blank();">Ajouter une page blanche</button>
        </section>
        <section>
            <button class="btn btn-sm btn-primary" onclick="changer_taille(160)">Petites pages </button>
            <button class="btn btn-sm btn-primary" onclick="changer_taille(300)">Pages moyennes</button>
            <button class="btn btn-sm btn-primary" onclick="changer_taille(500)">Grandes pages</button>
        </section>
    </div>

</main>
<script>
    function changer_taille(neo){
        $("#montage").css("height",neo+"px");
        calcule_taille_conteneur(); 
        
    }

    function add_blank(){
        $("#sortable-montage").prepend("<li class='blank-page' style='' draggable='false'><img src='<?= URL; ?>assets/imgs/blank-page.jpg' data-original='<?= CHEMIN; ?>assets/imgs/blank-page.jpg'></li>");
        calcule_taille_conteneur();
        compte_pages();
    }

    function creer_pdf(dossier){
        var mylist = [];
        if($("#montage li").length==0){
            alert("Pas de pages dans le montage! Impossible de créer un PDF...")
            return false
        }
        $("#montage li").each(function(){    
            //push element data to the array
            mylist.push({
                "id": $(this).attr("data-num"),
                "src": $(this).children("img").attr("data-original")
            });
        })
        // then you can simply pass it to the post method 

        $.ajax({
            method: "POST",
            url: "zine_traitement.php",
            data: { liste: mylist, action: "ecrire", dossier: dossier },
            beforeSend: function( xhr ) {
                $("#controller").addClass("blur-it");
            }
        }).done(function( data ) {
            // retour
            $("#corps-toast").html(data);
            $("#toast-container").removeClass("d-none");
            document.querySelectorAll('.toast').forEach(function(item){
                new bootstrap.Toast(item);
                console.log("toast!");
                $("#controller").removeClass("blur-it");
                $("#corps_toast").html(data);
                document.querySelectorAll('.toast').forEach(function(item){
                    var t=new bootstrap.Toast(item);
                    t.show()
                });
            });
        });
    }

    var montage = document.getElementById('sortable-montage');
    var reservoir = document.getElementById('sortable-reservoir');
    new Sortable(montage, {
        group: 'shared', // set both lists to same group
        animation: 150,
        ghostClass: "sortable-placeholder",
        chosenClass: "sortable-hover",
        dragClass: "sortable-dragging",
        onSort: function (evt) {
            compte_pages();
            calcule_taille_conteneur();
        },
    });

    new Sortable(reservoir, {
        group: 'shared',
        animation: 150,
        ghostClass: "sortable-placeholder",
        chosenClass: "sortable-hover",
        dragClass: "sortable-dragging",
    });

    function calcule_taille_conteneur(){
        var taille=0;
        $("#sortable-montage, #sortable-reservoir").width(10000);
        var min_taille=$("#montage").width();
        $("#sortable-montage li").each(function(){
            taille+=$(this).outerWidth()+2;
        });
        $("#sortable-montage").width(taille+300);
        if(taille+300 < min_taille){
            $("#sortable-montage").width(min_taille);
        }
        taille=0;
        $("#sortable-reservoir li").each(function(){
            taille+=$(this).outerWidth()+2;
        });
        $("#sortable-reservoir").width(taille+300);
        if(taille+300 < min_taille){
            $("#sortable-reservoir").width(min_taille);
        }

    }
    function compte_pages(){
        var ci=$("#montage img").length;
        $("#compteur_page").html(ci);
        $("#pdf_single, #pdf_impose, #pdf_ok").removeClass("bg-success").addClass("bg-danger");

        if(ci % 2 == 0){
            $("#pdf_single").removeClass("bg-danger").addClass("bg-success");
        } 
        if(ci % 4 == 0){
            $("#pdf_impose").removeClass("bg-danger").addClass("bg-success");
        } 
        if($("#pdf_impose.bg-danger, #pdf_single.bg-danger").length == 0){
            $("#pdf_ok").removeClass("bg-danger").addClass("bg-success");
        }
    }
    function initialise(){
        $("#montage li").prependTo("#reservoir ol");
        calcule_taille_conteneur();
    }

    compte_pages();
</script>
<?php 
include("inc-admin-footer.php");
include("../includes/inc-footer.php");
?>
