<?php 

include("../includes/inc-config.php");

include(CHEMIN."includes/inc-header.php");
include(CHEMIN."includes/inc-fonctions.php");
// traiter le formulaire

include(CHEMIN."includes/Spyc.php");
include(CHEMIN."includes/yaml-readwriteclass.php");
$zine=new yamlreadwrite(); 

include("inc-admin-header.php");

// checker qu'un zine est en cours ou pas
// comment?
// en vérifiant le dossier courant
// si il y a un fichier de config
// il y a un zine en cours...


$dossier_zine="";
$source="";
$infos="";

if(isset($_GET['new'])){
    // nouveau projet
    // creer un dossier avec la date
    // placer le fichier yaml de config dedans
    $nom="zine_".date("ymd_His");
    $dossier_zine=CHEMIN.DOSSIER_COURANT."/".$nom;
    fix_exists_dir($dossier_zine);
    $source=$dossier_zine."/config_zine.yaml";
    copy (CHEMIN."/admin/config_zine.yaml",$source);
    chmod(CHEMIN."/admin/config_zine.yaml", 0777);
    header("Refresh:0; url=config_zine.php?zine=".$dossier_zine);
    die();

} else if(isset($_GET['zine'])){
    $dossier_zine=$_GET['zine'];
    if(!is_dir($dossier_zine)){
        die ("le dossier n'existe pas");
    }
    $source=$dossier_zine."/config_zine.yaml";
    $zine->yamlread($source);
    $zine->yamlfrompost(true);
    $infos = $zine->yaml_simple_array();
    // archivage
    if(isset($_GET['chantier'])){
        // déplacer tout le dossier
        $dossier_zine=$_GET['zine'];
        $dest=CHEMIN.DOSSIER_COURANT."/".basename($dossier_zine);
        $action=rename($dossier_zine, $dest);
        if($action){
            header("Refresh:0; url=index.php");
            die();
        } else {
            die ("le dossier n'existe pas");
        }
        // changer la source
    } else if(isset($_GET['archiver'])){
        // déplacer tout le dossier
        $dossier_zine=$_GET['zine'];
        $dest=CHEMIN.DOSSIER_ARCHIVES."/".basename($dossier_zine);
        $action=rename($dossier_zine, $dest);
        if($action){
            header("Refresh:0; url=index.php");
            die();
        } else {
            die ("le dossier n'existe pas");
        }
        // changer la source
    } else if(isset($_GET['publier'])){

        // déplacer tout le dossier
        $dossier_zine=$_GET['zine'];
        $dest=CHEMIN.DOSSIER_ZINES."/".basename($dossier_zine);
        $action=rename($dossier_zine, $dest);
        if($action){
            header("Refresh:0; url=index.php");
            die();
        } else {
            die ("le dossier n'existe pas");
        }
    } else if(isset($_GET['supprimer'])){
        deleteDir($dossier_zine);
        header("Refresh:0; url=index.php");
        die();
    }


} else {
    die("pas de zine demandé! Erreur !");

}
?>

<main id="main" class="container-fluid px-4">
    <div class="row my-4">
        <div class="col-12 texte">
            <h3>Gestion du zine <?= $infos['titre_zine']; ?></h3>
            <div class="mb-4">Voir les infos du zine.</div>
        </div> 

        <div class="col-12 col-sm-9 col-md-6 texte">
            <div class="border rounded p-3 mb-3 translucide">
                <form method="post">
                    <?php
                    $zine->yamltoform("Updater");
                    ?>
                </form>
            </div>
        </div> 

        <div class="col-12 col-sm-3 col-md-6 texte">
            <div class="text-end">
                <div class="btn-group mb-3" role="group" aria-label="Basic example">
                    <a type="button" class="btn btn-primary disabled" href="config_zine.php?zine=<?= $dossier_zine; ?>">Infos du zine</a>
                    <a type="button" class="btn btn-primary" href="zine_gerer_propositions.php?zine=<?= $dossier_zine; ?>">Propositions pour le zine</a>
                    <a type="button" class="btn btn-primary" href="zine_publier.php?zine=<?= $dossier_zine; ?>">Générer le PDF</a>
                    
                </div>
            </div>
            <div class="border rounded p-3 mb-3 translucide">
                <h2 class="titre-small">Statut</h2>
                <div class="texte mb-3">
                    <?php
                    $li=images_zine_to_array($dossier_zine);
                    echo "Nombre de participations: ".count($li);
                    ?>
                </div>
                <div class="texte">
                    <div class="texte-small mt-2">Vous pouvez ajouter du contenu à ce zine via la procédure publique.</div>
                    <div class="mt-3">

                        <a class="btn btn-sm btn-primary" href="<?= URL."participer.php?zine=".fichier_seul($dossier_zine); ?>">Ajouter un document</a>


                    </div>
                </div>
            </div>

        </div>
    </div>
</main>

<?php 
include("inc-admin-footer.php");
include("../includes/inc-footer.php");
?>
