<?php
// fonctions générales
$tailles_zine=array(
    "A6 vertical" => array(
        "width"=>105,
        "height"=>148.5
    ),
    "A5 vertical" => array(
        "width"=>148.5,
        "height"=>210
    ),
    "A5 horizontal" => array(
        "width"=>210,
        "height"=>148.5
    ),
    "A4 vertical" => array(
        "width"=>210,
        "height"=>297
    )
);

// Vérifie l'existence d'un dossier, le Crée au besoin
function fix_exists_dir($dir){
    if(!is_dir($dir)){
        mkdir($dir, 0775, true);
        // confirmer
        chmod($dir, 0775);
    }
}

// supprimer un dossier (brrrr)
function deleteDir($path) {
    if (empty($path)) { 
        return false;
    }
    return is_file($path) ?
        @unlink($path) :
    array_map(__FUNCTION__, glob($path.'/*')) == @rmdir($path);
}

// renvoie uniquement le nom du fichier complet à partir de l'adresse
function fichier_seul($file){
    $file = preg_replace('/.*\//i', '', $file);
    return $file;	
}

// fabrique un nom plus ou moins lisible à partir d'unnom de fichier
function human_name($str){
    return str_replace(array("-","_",'.')," ",$str);
}

// retirer les accents pour les noms de fichier
function stripAccents($string){
    $str = htmlentities($string, ENT_NOQUOTES, 'UTF-8');
    $str = preg_replace('#\&([A-za-])(?:acute|cedil|circ|grave|ring|tilde|uml)\;#', '\1', $str);
    $str = preg_replace('/(\?|\!)/', '', $str);
    $str = strtolower(str_replace(" ","_",$str));
    $str = str_replace(array("#","'",'"'),"",$str);
    return $str;
}

function supprimer_image($image){
    unlink(CHEMIN.$image);
}

function traiter_recit($infos,$dossier_zine){
    $yaml_str = Spyc::YAMLDump($infos);
    $fi=pathinfo($infos['image']);
    $nom=$fi['filename'];
    $retour=file_put_contents(CHEMIN.DOSSIER_COURANT."/".$dossier_zine."/".$nom.".yaml",$yaml_str);
    return $retour;
}

/* 
prend l'image de $_FILES 
controle minimal de sécurité
et la place dans le dossier temporaire, renvoie le lien */
function recuperer_fichier_temporaire(){
    $retour=array();

    $f=$_FILES['recit-fichier'];

    $ext_ok=explode(",",EXTENSION_OK);
    $ext = strtolower(pathinfo($f['name'], PATHINFO_EXTENSION));
    if($ext=="jpeg"){ 
        $ext="jpg"; // virer les ext en jpeg
    } 
    if(!in_array($ext,$ext_ok) || empty($f['name'])){
        $retour['message'] = "Ce fichier n'a pas la bonne extension ou fichier absent";
        $retour['statut']="echec";
    }

    if($f['size'] < 100000){ // moins de 100K
        $retour['message']="Fichier trop petit";
        $retour['statut']="echec";
    }

    $nom_fichier=hash('adler32', $f['name'].date("Y-m-d H:i:s")).".".$ext;

    if(move_uploaded_file($f['tmp_name'], DOSSIER_TEMPORAIRE."/".$nom_fichier)){
        $retour['fichier']=$nom_fichier;
        $retour['message']="Fichier uploadé avec succès";
        $retour['taille']=$f['size'];
        $retour['statut']="ok";
    } else {
        $retour['message']="Erreur de déplacement";
        $retour['statut']="echec";
    }

    return $retour;
}

function recapitulatif_image($image,$tailles_zine,$infos){
    // verification de la taille
    list($width, $height, $type, $attr) = getimagesize($image);
    $format=$tailles_zine[$infos["format_zine"]];
    $wpix=floor((($format['width']-($infos["taille_marge"]*2))/25.1)*300);
    $hpix=floor((($format['height']-($infos["taille_marge"]*2))/25.1)*300);

    echo "<div class='texte-mini'>\n";
    echo "<p>Le zine est au format ".$infos["format_zine"].", avec une marge de ".$infos["taille_marge"]." mm, ";
    echo "soit une taille de ".$wpix." / ".$hpix." px.</p>\n";

    echo "<div class='texte-fat'>Taille de l'image: ".$width." / ".$height." px.</div>\n";

    if($width < $wpix || $height < $hpix){
        echo "<div class='text-danger'>L'image manque de résolution</div>\n";
    }


    $ratiodemande=$wpix/$hpix;
    // verification du ratio (vertical)
    $ratio=$width/$height;
    echo "<div class='mb-3'>\n";
    if(abs($ratio-$ratiodemande) < 0.05){
        echo "<div class='text-success'>Les proportions sont ok</div>\n";
    } else if(abs($ratio-$ratiodemande) < 0.1) {
        echo "<div class='text-warning'>Les proportions sortent de moins de 10% du format optimal.</div>\n";
    } else {
        echo "<div class='text-danger'>Les proportions sortent de plus de 10% le ratio optimal.</div>\n";
    }
    echo "</div>\n";
}

function traiter_fichiers_upload($dossier){
    $big_retour=array();

    //print_r($_FILES);

    $ext_ok=explode(",",EXTENSION_OK);

    $nombre=count($_FILES['zine-fichiers']['name']);
    for($i=0;$i<$nombre;$i++){
        $retour=array();
        $name=$_FILES['zine-fichiers']['name'][$i];
        $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
        $nom_fichier=hash('adler32', $name.date("Y-m-d H:i:s")).".".$ext;

        if($ext=="jpeg"){ 
            $ext="jpg"; // virer les ext en jpeg
        } 
        if(!in_array($ext,$ext_ok) || empty($name)){
            $retour['message'] = "Ce fichier n'a pas la bonne extension ou fichier absent";
            $retour['statut']="echec";
        }
        $size=$_FILES['zine-fichiers']['size'][$i];
        if($size < 100000){ // moins de 100K
            $retour['message']="Fichier trop petit";
            $retour['statut']="echec";
        }
        if($size > 7000000){ // moins de 100K
            $retour['message']="Fichier trop grand";
            $retour['statut']="echec";
        }

        if(move_uploaded_file($_FILES['zine-fichiers']['tmp_name'][$i], $dossier."/".$nom_fichier)){
            $retour['fichier']=$dossier."/".$nom_fichier;
            $retour['message']="Fichier uploadé avec succès";
            $retour['taille']=$size;
            $retour['statut']="ok";
        } else {
            $retour['message']="Erreur de déplacement";
            $retour['statut']="echec";
        }
        $big_retour[]=$retour;

    }
    return $big_retour;
}

// lien_vignette : reçoit une adresse de fichier et une taille, verifie si une vignette a cette taille existe et produit une version de cette image le cas échaant renvoie cette adresse

// reçoit le lien sans chemin ni url, renvoie toujours un lien public (avec url)
function lien_vignette($file,$l_vignette=600,$h_vignette=600,$crop=true){
    // virer l'adresse du serveur
    // virer les chemin et url par sécurité
    $file=str_replace(CHEMIN,"",$file);
    $file=str_replace(URL,"",$file);
    if(!is_file(CHEMIN.$file)){ 
        $file="assets/imgs/blank.jpg";
    } 

    $ext_image=explode(',',EXTENSION_OK);
    $fi=pathinfo(CHEMIN.$file);
    $ext=strtolower($fi['extension']);
    $nom=$fi['filename'];

    $nom_vignette=$nom."_".$l_vignette."x".$h_vignette.($crop ? "_crop" : "_nocrop").".".$ext;
    $url_vignette=DOSSIER_VIGNETTES."/".$nom_vignette;

    // - - - image : traitement des icones
    if(in_array($ext,$ext_image)){
        // charger l'image brute
        // vérifier que l'image existe
        // sinon la créer
        if (!file_exists(CHEMIN.$url_vignette)) {
            if(image_resize(CHEMIN.$file, CHEMIN.$url_vignette, $l_vignette, $h_vignette, $crop)){
                return URL.$url_vignette."?".filectime(CHEMIN.$url_vignette);
            } else {
                return URL.$file."?".filectime(CHEMIN.$file);
            }
        } else {
            return URL.$url_vignette."?".filectime(CHEMIN.$url_vignette);   
        }
    } else {
        return URL."assets/imgs/blank.jpg";   
    }
    // - - - - fin traitement des images   
}

function image_resize($src, $dst, $width=500, $height=400, $crop=0){    
    ini_set('memory_limit', '256M');
    if(!list($w, $h) = getimagesize($src)) {
        echo "image does not exists";
        return false;
    }

    $type = strtolower(substr(strrchr($src,"."),1));
    if($type == 'jpeg') $type = 'jpg';
    switch($type){
        case 'gif': $img = imagecreatefromgif($src); break;
        case 'jpg': $img = imagecreatefromjpeg($src); break;
        case 'png': $img = imagecreatefrompng($src); break;
        default : echo "image does not exists"; return false;
    }

    // resize
    if($crop){
        if($w < $width or $h < $height){ 
            return false;
        };
        $ratio = max($width/$w, $height/$h);
        $y= ($h - $height / $ratio) /2;
        $x = ($w - $width / $ratio) / 2;
        $h = $height / $ratio;
        $w = $width / $ratio;
    }
    else{
        if($w < $width and $h < $height) {
            return false;
        }
        $ratio = min($width/$w, $height/$h);
        $width = $w * $ratio;
        $height = $h * $ratio;
        $x = 0;
        $y = 0;
    }

    $new = imagecreatetruecolor($width, $height);

    // preserve transparency
    if($type == "gif" or $type == "png"){
        imagecolortransparent($new, imagecolorallocatealpha($new, 0, 0, 0, 127));
        imagealphablending($new, false);
        imagesavealpha($new, true);
    }
    imagecopyresampled($new, $img, 0, 0, $x, $y, $width, $height, $w, $h);
    $sharpen = array([-1,-1,-1], [-1, 16, -1], [-1,-1,-1]);
    imageconvolution($new, $sharpen, 8, 0);
    switch($type){
        case 'gif': imagegif($new, $dst); break;
        case 'jpg': imagejpeg($new, $dst); break;
        case 'png': imagepng($new, $dst); break;
    }
    return true;
}

/*

pages admin
*/
function lister_catalogue($params,$dossier=DOSSIER_ZINES){
    $liste=glob(CHEMIN.$dossier."/*",GLOB_ONLYDIR);
    if(count($liste)){
        foreach($liste as $liste){
            afficher_catalogue_zine($params,$liste);
        }
    } else {
        echo "rien actuellement";
    }
}

// afficher les zines en admin avec boutons d'action
function afficher_catalogue_zine($params,$dossier){
    // si l'admin est superadmin, tout afficher
    // s'il est admin simple, ne montrer que ses zines
    $userid=$_SESSION['UserData']['Userid'];
    $userstatus=$_SESSION['UserData']['Userstatus'];

    $zine=new yamlreadwrite();
    $zine->yamlread($dossier."/config_zine.yaml");
    $infos=$zine->yaml_simple_array();
    //print_r($infos);
    if($infos['admin']!=$userid && $userstatus !="superadmin"){
        return;
    }




    $li=images_zine_to_array($dossier);
    //echo "<div class='col-2'><img class='w-100' src='".URL.lien_vignette($li[0],200,200,false)."'></div>";

    echo "<div class='input-group mb-3'>";
    echo "<div class='form-control'><span class='texte-fat'>".$infos['titre_zine']."</span>, dirigé par ".$infos['editeur_zine']."</div>";

    echo "<div class='texte-small form-control'>".count($li)." images - ";
    $pdfs=trouve_pdf($dossier);
    foreach($pdfs as $titre => $pdf){
        // fabriquer le lien public à partir du lien serveur
        $local=str_replace(CHEMIN,URL,$pdf);
        echo "<a href='".$local."' download>".$titre."</a> ";
    }
    if(!count($pdfs)){ echo "Pas de PDF"; }
    echo "</div>";

    echo "<button class='btn btn-outline-secondary dropdown-toggle' type='button' data-bs-toggle='dropdown' aria-expanded='false'>Action</button>
  <ul class='dropdown-menu dropdown-menu-end'>
    <li><a class='dropdown-item' href='config_zine.php?zine=$dossier'>Modifier les infos</a></li>";

    if($params['propositions']){
        echo "<li><a class='dropdown-item' href='zine_gerer_propositions.php?zine=$dossier&chantier=oui'>Voir les propositions</a></li>";
    }
    if($params['generer']){
        echo "<li><a class='dropdown-item' href='zine_publier.php?zine=$dossier&chantier=oui'>Générer le PDF</a></li>";
    }
    echo "<li><hr class='dropdown-divider'></li>";
    if($params['chantier']){
        echo "<li><a class='dropdown-item' href='config_zine.php?zine=$dossier&chantier=oui'>Mettre en chantier</a></li>";
    }
    if($params['publier']){
        echo "<li><a class='dropdown-item' href='config_zine.php?zine=$dossier&publier=oui'>Ajouter au catalogue</a></li>";
    }
    if($params['archiver']){
        echo "<li><a class='dropdown-item' href='config_zine.php?zine=$dossier&archiver=oui'>Mettre hors ligne</a></li>";
    }
    if($params['supprimer']){
        echo "<li><hr class='dropdown-divider'></li>
        <li><a class='dropdown-item' href='config_zine.php?zine=$dossier&supprimer=oui'>Supprimer</a></li>";
    }
    echo"</ul></div>";
}

// simple liste des images d'un dossier
function lister_images($dossier=CHEMIN.DOSSIER_COURANT){
    $liste=glob($dossier."/*.{".EXTENSION_OK."}",GLOB_BRACE); // 
    foreach($liste as $element){
        affiche_image(basename($element),$element);
    }
}

function deployer_diaporama($dossier){
    if(!is_dir($dossier)){
        die ("le dossier n'existe pas");
    }
    $nom=stripAccents(basename($dossier));

    $liste=glob($dossier."/*.{".EXTENSION_OK."}",GLOB_BRACE); // 
    if(!count($liste)){
        return "<img src='".URL."assets/imgs/blank.jpg'>";
    }
    $actuel=" active";
    echo "<div id='".$nom."' class='carousel slide' data-bs-ride='carousel'>
  <div class='carousel-inner'>";

    foreach($liste as $num => $element){
        $path_parts = pathinfo($element);
        echo "<div class='carousel-item";
        if($actuel!=""){
            echo $actuel;
            $actuel="";
        }
        $vignette=lien_vignette($dossier."/".$path_parts['basename'],400,600,true);

        echo "'><img src='".$vignette."' class='d-block w-100' alt=''></div>";
    }
    echo "</div>
        <a class='carousel-control-prev' href='#".$nom."' role='button' data-bs-slide='prev'>
        <span class='carousel-control-prev-icon' aria-hidden='true'></span>
        <span class='visually-hidden'>Previous</span>
        </a>
        <a class='carousel-control-next' href='#".$nom."' role='button' data-bs-slide='next'>
        <span class='carousel-control-next-icon' aria-hidden='true'></span>
        <span class='visually-hidden'>Next</span>
        </a>
        </div>";
}

function images_zine_to_array($dossier){
    if(!is_dir($dossier)){
        die ("le dossier n'existe pas");
    }
    $retour=array();
    $liste=glob($dossier."/*.{".EXTENSION_OK."}",GLOB_BRACE); // 
    foreach($liste as $num => $element){
        $path_parts = pathinfo($element);
        $retour[]=$dossier."/".$path_parts['basename'];
    }
    /*if(!count($retour)){
        $retour[]="assets/imgs/blank.jpg";
    }*/
    return $retour;
}


function lister_images_zine($dossier){
    if(!is_dir($dossier)){
        die ("le dossier n'existe pas");
    }

    $liste=glob($dossier."/*.{".EXTENSION_OK."}",GLOB_BRACE); // 
    foreach($liste as $num => $element){
        $path_parts = pathinfo($element);
        $fichier_image=$dossier."/".$path_parts['basename'];
        $fichier_yaml=$dossier."/".$path_parts['filename'].".yaml";
        $infos = Spyc::YAMLLoad($fichier_yaml);
        list($width, $height, $type, $attr) = getimagesize($element);

        echo "<li class=''>";
        echo "<img class='w-100' data-original='".$fichier_image."'  src='".lien_vignette($fichier_image,600,600,false)."'>";
        echo "<div class='bloc-info texte-small position-absolute'>";
        echo "<button class='btn btn-sm btn-primary texte' type='button' data-bs-toggle='collapse' data-bs-target='#info".$num."' aria-expanded='false' aria-controls='collapseExample'><i class='bi bi-three-dots'></i></button>

<div class='collapse' id='info".$num."'>
  <div class='card card-body texte-small'>";

        echo "<div class='texte-fat mb-2'>".$infos['titre']."<br>".$infos['auteur']."</div>";
        echo "<div class='texte-tiny'>".$width." / ".$height." px</div>"; 

        echo "</div>";
        echo "</div>";
        echo "</div></li>";
    }
}

// renvoi la liste des pdf imposés et single page d'un dossier
function trouve_pdf($dossier){
    $retour = array();
    $liste=glob($dossier."/*.pdf");
    foreach($liste as $element){
        if(strpos($element, '_impose.pdf') !== false){
            $retour['impose']=$element;
        }
        if(strpos($element, '_single_page.pdf') !== false){
            $retour['single_page']=$element;
        }
    }
    return $retour;
}

function affiche_image($texte,$name){
    echo "<form method='post'><div class='input-group mb-3'>
    <span class='input-group-text w-50' id='addon-wrapping'>".$texte."</span>
    <select class='form-select' name='image_action'>
    <option selected> - - - </option>
    <option value='supprimer'>supprimer</option>
  </select>
  <input type='hidden' name='image_nom' value='".$name."'>
    <input class='btn btn-success' type='submit' name='image_action_soumettre' value='Go'>
</div></form>";
}

function affiche_bande($texte,$name,$horsligne){
    echo "<form method='post'><div class='input-group mb-3'>
    <span class='input-group-text w-50' id='addon-wrapping'>".$texte."</span>
    <select class='form-select' name='zine_action'>
    <option selected> - - - </option>";
    if($horsligne){ echo "<option value='horsligne'>Mettre hors ligne</option>"; }
    echo "<option value='supprimer'>supprimer</option>
  </select>
  <input type='hidden' name='zine_nom' value='".$name."'>
    <input class='btn btn-success' type='submit' name='zine_action_soumettre' value='Go'>
</div></form>";
}

function afficher_message($message){
    return "<div class='toast d-flex align-items-center show' role='alert' aria-live='assertive' aria-atomic='true'>
  <div class='toast-body'>".$message."</div>
  <button type='button' class='btn-close ms-auto me-2' data-bs-dismiss='toast' aria-label='Close'></button>
</div>";
}

function lister_zines($dossier=CHEMIN.DOSSIER_COURANT){
    $zines=glob($dossier."/*",GLOB_ONLYDIR);
    foreach($zines as $zine){
        $load = Spyc::YAMLLoad($zine."/config_zine.yaml");

        echo "<div class='mb-3'>";
        echo "<a href='config_zine.php?zine=".$zine."' class='titre-medium font-medium decoration-hover'>".$load['titre_zine']['contenu']."</a>";
        echo "<div class='texte-tiny'>Créé le ".$load['date_creation']['contenu']." par ".$load['editeur_zine']['contenu']."</div>";
        echo "<div class='texte-tsmall my-1'>".$load['descriptif_zine']['contenu']."</div>";

        $ims=glob($zine."/*.{gif,png,jpg,jpeg}",GLOB_BRACE);
        echo "<div class='texte-tiny texte-fat'>".count($ims)." documents proposés</div>";
        echo "</div>";
    }
}

function deployer_yaml_info($fichier){
    $load = Spyc::YAMLLoad($fichier);
    foreach($load as $cle=> $valeur){ 
        echo "<div class=\"mb-2\"><span class=\"texte-fat\">".$valeur['titre']." </span>: ".$valeur['contenu']."</div>";  
    }
}

function lister_form_images($source){
    echo "ok";
}

function afficher_messages($messages){
    if(!$messages){
        return false;
    }
    if(!is_array($messages)){
        $messages=array($messages);
    }
    echo "<div class='position-fixed top-0 end-0 m-5'>";
    foreach($messages as $message){
        echo "<div class='toast align-items-center mb-3' role='alert' aria-live='assertive' aria-atomic='true'>
<div class='d-flex'>
<div class='toast-body'>";
        echo $message;
        echo "</div>
<button type='button' class='btn-close me-2 m-auto' data-bs-dismiss='toast' aria-label='Close'></button>
</div>
</div>";

    }

    echo "</div>";
}

function zine_get_admin(){
    if(isset($_SESSION['UserData']['Userid'])){
        return $_SESSION['UserData']['Userid'];
    } else {
        return "Inconnu";
    }
}
function zine_get_date(){
    return date('d-m-Y');
    //date("jS F, Y", strtotime("11-12-10"));
    // outputs 11th December, 2010  
}
?>