<?php 
include("../includes/inc-config.php");

include(CHEMIN."includes/inc-header.php");
include(CHEMIN."includes/inc-fonctions.php");

include(CHEMIN."includes/Spyc.php");
include(CHEMIN."includes/yaml-readwriteclass.php");
$zine=new yamlreadwrite(); 

if(isset($_GET['zine'])){
    $source=$_GET['zine'];
    if(!is_dir($source)){
        die ("le dossier n'existe pas");
    }
}
include("inc-admin-header.php");
if(!$zine->yamlread($source."/config_zine.yaml")){
    echo "Impossible de lire les infos du zine!";
    die();
}

$infos = $zine->yaml_simple_array();

//print_r($_POST);
$messages="";
if(isset($_POST['image_action'])){
    $lien_complet=$_POST['image_nom'];
    $path_parts = pathinfo($_POST['image_nom']);
    $nom_image=$path_parts['basename'];
    if($_POST['image_action']=="supprimer"){
        unlink($lien_complet); // image
        unlink(CHEMIN.DOSSIER_COURANT."/".$path_parts['filename'].".yaml"); // fichier yaml
        $messages.= afficher_message("Le fichier ".$nom_image." a été supprimé.");
    } 
}

if(isset($_POST['images_soumettre'])){

    $titre="";
    $auteur="";
    $dossier_zine=$_POST['dossier_zine'];
    $images=traiter_fichiers_upload($source);
    $zine=new yamlreadwrite();

    foreach($images as $image){
        if($image['statut']=='ok'){
            $im=array(
                "titre" => "",
                "auteur" => "",
                "image" => $image['fichier']
            );
            $fi=pathinfo($image['fichier']);
            $zine->source=$dossier_zine."/".$fi['filename'].".yaml";
            $message=$zine->yamlwrite($im);
            // envoyer le message ok au besoin
        }
    }
}
if(isset($_POST['edit_image_info'])){
    $nom_image=$_POST['nom_image'];
    $path_parts = pathinfo($nom_image);
    $dossier_zine=$_POST['dossier_zine'];
    //print_r($_POST);
    if(isset($_POST['supprimer_image'])){
        unlink($nom_image); // image
        unlink($dossier_zine."/".$path_parts['filename'].".yaml"); // fichier yaml

        // probablement vérifier si un original n'existe pas, à supprimer aussi

        $messages.= afficher_message("Le fichier ".$nom_image." a été supprimé.");
    } else {
        $image=new yamlreadwrite();
        $dossier_zine=$_POST['dossier_zine'];

        $image->source=$dossier_zine."/".$path_parts['filename'].".yaml";
        $im=array( 
            "titre" => html_entity_decode($_POST['image_titre'], ENT_QUOTES, 'UTF-8'),
            "auteur" => html_entity_decode($_POST['image_auteur'], ENT_QUOTES, 'UTF-8'),
            "image" => $nom_image
        );
        $message=$image->yamlwrite($im);
    }
}

echo "<div aria-live='polite' aria-atomic='true' class='position-relative'>
<div class='toast-container position-absolute top-0 end-0 p-3'>";
echo $messages;
echo "</div></div>";
?>

<main id="main" class="container-fluid px-4">
    <div class="row my-4">
        <div class="col-12 texte">
            <h3>Gestion des documents du zine<br>"<?= $infos['titre_zine']; ?>"</h3>
            <div>Ici on gère les documents.</div>
        </div>

    </div>

    <div class="row">
        <div class="col-12 col-md-6">

            <div class="border rounded p-3 translucide">
                <h2 class="text-big">Liste des images reçues</h2>

                <div class="texte my-3">
                    <?php
                    $liste=glob($source."/*.{".EXTENSION_OK."}",GLOB_BRACE); 
                    $image=new yamlreadwrite();

                    foreach($liste as $num=>$element){
                        $path_parts = pathinfo($element);

                        $si=$source."/".$path_parts['filename'].".yaml";
                        $image->yamlread($si);

                        //affiche_image(basename($element),$element);
                        echo "<div class='list-group list-group-horizontal mb-3'>\n<div class='list-group-item flex-grow p-0 w-50'>\n";
                        echo "<img src='".lien_vignette($element,600,600,false)."' class='w-100'>";


                        echo "<div class='btn-group position-absolute top-0 start-0 m-3'><button type='button' class='btn btn-primary dropdown-toggle' data-bs-toggle='dropdown' aria-expanded='false'><i class='bi bi-bounding-box-circles'></i></button>";

                        $download=$element;
                        echo "<ul class='dropdown-menu'>
<li><a class='dropdown-item' href='zine_edit_image.php?image=".$element."&zine=".$source."'>Editer l'image</a></li>";
                        if(file_exists($source."/originaux/".basename($element))){
                            $download=$source."/originaux/".basename($element);
                            echo "<li><hr class='dropdown-divider'></li>
<li><a class='dropdown-item' href='zine_edit_image.php?image=".$element."&zine=".$source."&original=true'>Editer l'original</a></li>";
                        }

                        echo "<li><hr class='dropdown-divider'></li><li><a class='dropdown-item' href=\"".str_replace(CHEMIN,URL,$download)."\" download>Télécharger cette image</a></li>";

                        echo "</ul></div>";

                        echo "</div>\n";

                        echo "<div class='list-group-item w-50'>\n";
                        echo "<div class='d-flex flex-column justify-content-between h-100'>\n";
                        echo "<div class='mb-4'>\n";
                        echo "<div class='titre-small texte-fat mb-2'>Récapitulatif</div>\n";
                        recapitulatif_image($element,$tailles_zine,$infos);
                        echo "\n</div>\n";
                        echo "</div>\n";
                        // titre et texte
                        echo "<form action='zine_gerer_propositions.php?zine=".$source."' method='post'>\n";


                        if(isset($infos['afficher_auteur']) && $infos['afficher_auteur']=="oui"){
                            echo "<div class='mb-3'>\n";
                            echo "<label for='titre' class='form-label texte-small texte-fat'>Titre de l'image</label>";
                            echo "<input type='text' class='form-control form-control-sm' name='image_titre' value='".htmlentities($image->get('titre',''), ENT_QUOTES, 'UTF-8')."'></div>\n<div class='mb-3'>";
                        }        
                        if(isset($infos['afficher_titre_image']) && $infos['afficher_titre_image']=="oui"){                     
                            echo "<label for='auteur' class='form-label texte-small texte-fat'>Auteur de l'image</label><input type='text' class='form-control form-control-sm' name='image_auteur' value='".htmlentities($image->get('auteur',''), ENT_QUOTES, 'UTF-8')."'>\n</div>\n";

                        }
                        echo "<div class='mb-3 form-check'>\n<input type='checkbox' class='form-check-input' name='supprimer_image' id='supprimer_im_$num'>\n<label class='form-check-label text-danger' for='supprimer_im_$num'>Supprimer cette image</label>\n</div>";          

                        echo "<input type='hidden' name='dossier_zine' value='".$source."'>\n";
                        echo "<input type='hidden' name='nom_image' value='".$element."'>\n";
                        echo "<input type='submit' name='edit_image_info' class='btn btn-sm btn-primary' value='Updater'>\n";

                        echo "</form>\n";
                        echo "</div>\n"; echo "</div>\n";

                        echo "</div>\n";

                    }

                    ?>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-6">
            <div class="text-end">
                <div class="btn-group mb-3" role="group" aria-label="Basic example">
                    <a type="button" class="btn btn-primary" href="config_zine.php?zine=<?= $source; ?>">Infos du zine</a>
                    <a type="button" class="btn btn-primary disabled" href="zine_gerer_propositions.php?zine=<?= $dossier_zine; ?>">Propositions pour le zine</a> 
                    <a type="button" class="btn btn-primary" href="zine_publier.php?zine=<?= $source; ?>">Générer le PDF</a>
                </div>
            </div>

            <div class="border rounded p-3 translucide mb-4 mt-4 mt-md-0">
                <h2 class="titre-small">Ajouter des documents</h2>
                <div class="texte my-3">
                    <div class="mb-2">Sélectionnez de multiples fichiers à uploader en une fois. Vérifiez la taille et l'extension de ces fichiers!</div>
                    <form method="post" action="zine_gerer_propositions.php?zine=<?= $source; ?>" class="form" enctype="multipart/form-data">
                        <div class="mb-3">
                            <input class="form-control" type="file" id="formFileMultiple" name="zine-fichiers[]" accept="image/*" multiple>
                        </div>
                        <div class="mb-3">
                            <input type="hidden" name="dossier_zine" value="<?= $source; ?>">
                            <input type="submit" name="images_soumettre" class="btn btn-success text-light" value="Uploader">
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
</main>

<?php 
include("inc-admin-footer.php");
include("../includes/inc-footer.php");
?>
