<?php
/*
déployer l'application: création des dossiers, 
copie des fichiers nécessaires
*/
function fix_exists_dir($dir){
    if(!is_dir($dir)){
        mkdir($dir, 0777, true);
    }
}

function deployerAppIfNotYet(){
    $contentht="Options -Indexes";
    if(!is_dir(CHEMIN."contents")){
        $dirs=array(
            "contents", "contents/items", "contents/pages", "contents/sessions", 
            "contents/imports", "contents/cache", "contents/cache/vignettes", "contents/cache/temp", "contents/collections", "upload"
        );
        foreach($dirs as $dir){
            fix_exists_dir(CHEMIN.$dir);
        }
        file_put_contents(CHEMIN."contents/.htaccess",$contentht);
    }

    if(!is_dir(CONTENTS."config")){
        fix_exists_dir(CONFIG."settings");
        fix_exists_dir(CONFIG."access");
        fix_exists_dir(CONFIG."styles");
        fix_exists_dir(CONFIG."snippets");
        
        // dupliquer les fichiers de base
        // structure_item.yaml, theme
        copy(APP."default/settings_website.yaml", CONFIG."settings/settings_website.yaml");
        copy(APP."default/settings_theme.yaml", CONFIG."settings/settings_theme.yaml");

        // protection en lecture
        file_put_contents(CONFIG.".htaccess",$contentht);
    }
}