<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
if(!isset($_GET['item'])){
    echo "Pas d'item spécifié!";
    die();
}

$item_url=$_GET['item'];
$item=new yamlReadwriter();
$item->loadYaml(getTemplate("structure_item.yaml")); // charger la structure complète

// charger le contenu de l'item
$item->loadContentFromYaml(CONTENTS."items/".$item_url);

?>
<!DOCTYPE html> 
<html lang="">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="description" content="Galerie Erg 78-82">
        <title>Galerie Erg 78-82 - printpage</title>


        <link rel="apple-touch-icon" sizes="180x180" href="http://codedrops.net/erg_78-82/app/favicons/apple-touch-icon.png">
        <link rel="icon" type="image/png" sizes="32x32" href="http://codedrops.net/erg_78-82/app/favicons/favicon-32x32.png">
        <link rel="icon" type="image/png" sizes="16x16" href="http://codedrops.net/erg_78-82/app/favicons/favicon-16x16.png">
        <link rel="icon" type="image/x-icon" href="http://codedrops.net/erg_78-82/app/favicons/favicon.svg">
        <link rel="stylesheet" href="http://codedrops.net/erg_78-82/app/css/sfw.css">
        <link rel="stylesheet" href="http://codedrops.net/erg_78-82/app/css/plex/stylesheet.css">
        <link rel="stylesheet" href="http://codedrops.net/erg_78-82/app/css/main.css">
        <link rel="stylesheet" href="modules/module_printpage/printpage.css">
    </head>
    <body id="print">
        <h1 class="fs-medium mb-3"><?= $item->get('titre') ?> <span class="fs-small">(<?= $item->get('code_annee') ?>)</span></h1>

        $im=new thumbnail_tool(CHEMIN,CACHE_VIGNETTES,APP."images/");
        $im->set_source(IMPORTS_URL.$item->get('illustration'));

        <img src="<?= $im->vignette(3000,3000,false) ?>" class="print-illu">

        <?php
    $liste=$item->getFilledValues();
            $idandpart=array(
                "notes"=> "nolabel",
                "auteur" => "smallinline",
            );
            $idandpart2=array(
                "description"=> "smallinline",
                "date_document"=> "smallinline",
                "etat"=> "smallinline",
                "conditions"=> "smallinline",
                "localisation"=> "smallinline",
            );

            echo "<div class='grid grid-reg2 grid-gap-3 my-3'><div>";
            display_idandpart($idandpart, $item);

            echo "</div><div>";

            display_idandpart($idandpart2, $item);
            echo "</div></div>";

            // galerie
            if($item->get("galerie", false)){ 

                echo "<div class='grid grid-reg2 grid-gap-3 my-3 print-galerie'>";
                $docs=$item->getAsarray("galerie");
                foreach($docs as $doc){
                    echo "<div class='print-galerieitem'><img src=\"".IMPORTS_URL.$doc."\" class=\"print-illu my-3\"></div>";
                }
                echo "</div>";
            }

            function display_idandpart($idandpart, $item){
                foreach($idandpart as $id => $part){
                    if(!$item->get($id, false)){ continue; }
                    include(getSnippetFile("display_part_".$part.".php"));
                }
            }


        ?>


    </body>
</html>


