<?php
/*


FONCTIONS


*/
function loadcsv($csv_source){
    if(!file_exists($csv_source)) { return false; }
    if (($open = fopen($csv_source, "r")) !== false) {
        while (($data = fgetcsv($open, 1000, ";")) !== false) {
            $arrays[] = $data;
        }
        fclose($open);
        return $arrays;
    } else {
        return false;
    }
}


function get_directories($docs_source){
    $dossiers=array();
    $iterator = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($docs_source, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::SELF_FIRST
    );
    foreach ($iterator as $item) {
        $path = $item->getPathname();
        if ($item->isDir()) {
            $dossiers[basename($path)]=$path;
        }
    }
    return $dossiers;
}

function write_row($ar){
    echo "<tr>";
    foreach($ar as $num => $i){
        echo "<td class='r$num'>".$i."</td>";
    }
    echo "</tr>";
}

function createcel($content){
    echo "<td>".$content."</td>\n";
}



function copyfiles($file,$listfiles){
    $infos=pathinfo($file);
    $ext = strtolower($infos['extension']);
    if($ext=="jpeg"){ $ext="jpg"; }

    $filename=stripAccents($infos['filename'])."_".hash('adler32',uniqid()).".".$ext;

    if(file_exists(IMPORTS.$filename)){
        echo "<p class='color-notok'>".$filename." namefile existe déjà - renommer en ";
        $filename=stripAccents($infos['filename'])."_".uniqid().".".$ext;
        echo $filename."<p>";
    } 

    switch($ext){
        case 'jpg':
        case 'jpeg':
        case 'png':
        case 'gif':
        case 'webp':
            $listfiles['galerie'][]=$filename;
            break;

        case 'mp4':
        case 'mkv':
            $listfiles['multimedia'][]=$filename;
            break;

        case 'pdf':
            $listfiles['docspdf'][]=$filename;
            break;

        case 'doc':
        case 'xls':
        case 'txt':
        case 'rtf':
            $listfiles['docsautre'][]=$filename;
            break;
    }

    // déplacer le fichier
    if(CREATE_YAML){
        copy($file, IMPORTS.$filename);
        echo "<p class='color-ok my-0'>Copy of ".$filename."</p>";

    } else {
        echo "<p class='color-notok my-0'>NO COPY of ".$filename."</p>";
    }


    return $listfiles;

}

function createitem($row, $listfiles, $sdir=false){
    global $csv_champs;
    /* creation du fichier yaml */
    $item=new yamlReadwriter(); 
    $item->loadYaml(getTemplate("structure_item.yaml"));
    $item->setType("item"); // important
    $item->setDestinationFolder(CONTENTS."items/");

    $compteur=0;
    foreach($csv_champs as $index => $value){
        $item->set($index,$row[$compteur]);
        $compteur++;
    }
    if($sdir){
        $item->set('soustitre',$sdir);
    }

    // mettre la première image comme illustration
    if(isset($listfiles['galerie'][0])){
        $item->set('illustration',$listfiles['galerie'][0]);
        unset($listfiles['galerie'][0]);
    }

    // entrer les docs
    foreach($listfiles as $type => $contenu){
        $item->set($type,$contenu);
    }

    // et on sauve
    if(CREATE_YAML){
        $itemurl=$item->writeyaml();
        echo "<p class='color-ok my-0'>Créé item ".$itemurl."</p>";
    } else {
        echo "<p class='color-notok my-0'>Pas de création de yaml</p>";
    }

}
