<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include("presences_config.php");

function createcel($content, $css=false){
    echo "<td";
    if($css){
        echo " class=\"".$css."\"";
    }
    echo ">".$content."</td>\n";
}

include(getSnippetFile("code-header.php"));
?>
<header id="main-header" class="p-3">
    <?php
    include(getSnippetFile("code-pageheader-top.php"));
    ?>
</header>
<section id="main-container" class="px-3 pb-4">
    <h2 class="pb-3">Présences aux cours</h2>
    <div class="d-none">
        <div class="pr-2">Rechercher&nbsp;: </div>
        <input id="live-search" type="text" class="" placeholder="Tapez quelque chose">
    </div>
    <div id="main-grid" class="d-none"></div>
    <table class="presencetable" id="presences">
        <?php
        
        $cacheorder = CACHE.'cached-mosaique-order.yaml';
        $order=Spyc::YAMLLoad($cacheorder);
        $item=new yamlReadwriter();
        $item->loadYaml(getTemplate("structure_item.yaml"));
        echo "<thead><tr><td class=\"tdnom\" onclick=\"sortTable(0)\">Nom et prenom</td>";
        echo "<td onclick=\"sortTable(1)\">Orientation</td>";

        for($i=0; $i<count($cells);$i++){
            
            $code=str_replace("presence_","",$cells[$i]);
            $d=substr($code, 0, 2);
            $m=substr($code, 2, 2);
        
            createcel($d."/".$m,$cells[$i]);
        }
        echo "</tr></thead>";
        ?>
        <tbody>
            <?php
            foreach($order as $num => $item_url){
                $item=new yamlReadwriter();
                $item->loadYaml(getTemplate("structure_item.yaml"));
                $item->loadContentFromYaml(CONTENTS."items/".$item_url); 
                echo "<tr>\n";
                echo"<td data-source=\"".$item->filename."\" onclick=\"yc_clicItem(this)\" class='table-nom'>";
                echo $item->get("prenom")." ".$item->get("nom");
                if($item->get("usuel",false)){
                    echo " (".$item->get("usuel").")";
                }
                echo "</td>"; 
                
                echo "<td>".$item->getpropre("option")."</td>";
                foreach($cells as $cell){
                    $pres=str_replace($presentsearch,$presentreplace,$item->getpropre($cell,""));
                    createcel($pres,"c-".$pres);
                }
                echo" </tr>\n";
            }
            ?>
        </tbody>
    </table>
    <div class="py-3">
        <table class="fs-small ff-bold-secondary"><tr><td>Légende: </td>
    <?php
        for($i=0;$i<count($presentsearch);$i++){
            echo "<td>".$presentreplace[$i].": ".$presentsearch[$i]." </td><td>&nbsp;</td>";
        }
        ?>
            </tr></table>
    </div>
    <script>
function sortTable(n) {
  var table, rows, switching, i, x, y, shouldSwitch, dir, switchcount = 0;
  table = document.getElementById("presences");
  switching = true;
  // Set the sorting direction to ascending:
  dir = "asc";
  /* Make a loop that will continue until
  no switching has been done: */
  while (switching) {
    // Start by saying: no switching is done:
    switching = false;
    rows = table.rows;
    /* Loop through all table rows (except the
    first, which contains table headers): */
    for (i = 1; i < (rows.length - 1); i++) {
      // Start by saying there should be no switching:
      shouldSwitch = false;
      /* Get the two elements you want to compare,
      one from current row and one from the next: */
      x = rows[i].getElementsByTagName("TD")[n];
      y = rows[i + 1].getElementsByTagName("TD")[n];
      /* Check if the two rows should switch place,
      based on the direction, asc or desc: */
      if (dir == "asc") {
        if (x.innerHTML.toLowerCase() > y.innerHTML.toLowerCase()) {
          // If so, mark as a switch and break the loop:
          shouldSwitch = true;
          break;
        }
      } else if (dir == "desc") {
        if (x.innerHTML.toLowerCase() < y.innerHTML.toLowerCase()) {
          // If so, mark as a switch and break the loop:
          shouldSwitch = true;
          break;
        }
      }
    }
    if (shouldSwitch) {
      /* If a switch has been marked, make the switch
      and mark that a switch has been done: */
      rows[i].parentNode.insertBefore(rows[i + 1], rows[i]);
      switching = true;
      // Each time a switch is done, increase this count by 1:
      switchcount ++;
    } else {
      /* If no switching has been done AND the direction is "asc",
      set the direction to "desc" and run the while loop again. */
      if (switchcount == 0 && dir == "asc") {
        dir = "desc";
        switching = true;
      }
    }
  }
}
        sortTable(0)
    </script>

</section>

<?php

include(getSnippetFile("code-viewer.php"));
include(getSnippetFile("code-footer.php"));


?>