<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include("csv_import_config.php");
include("csv_functions.php");

$modir=__DIR__;

include(getSnippetFile("code-header.php"));
?>
<header id="main-header" class="p-3">
    <?php
    include(getSnippetFile("code-pageheader-top.php"));
    ?>
</header>
<section id="main-container" class="px-3 pb-4">
    <h2 class="pb-3">Importation depuis un CSV</h2>
    <div class="pb-3">
        Ce module permet d'importer des xml depuis un fichier CSV (dérivé d'un XLS). 

        <h3>Structure requise</h3>
        <div>Le dossier "data" du module doit contenir:<br>
            - Un fichier csv.csv qui contient les données.<br>
            - Un rang de ce fichier doit contenir les nom des champs à associer<br>
            - Un rang correspond à un item (qui peut être un séparateur, voir le module "séparateur")<br>
            - Une des colonnes du fichier doit contenir le nom du dossier associé à l'item<br>
            - Un dossier "documents" doit contenir les fichiers associés à chaque item, avec un nom de dossier sans accent ni caractère spéciaux
        </div>

        <div>
            Pour préparer la création des items:<br>
            1) Vérifiez la présence des fichiers décrits plus haut.<br>
            2) Editez le fichier csv_import_config.php. Il est commenté pour aider cette manoeuvre.<br>
            3) Choisissez l'option d'importation: ajouter ou remplacer<br>
            Ensuite cliquer sur "Lancer l'importation" si le bouton apparait en bas de cette page.
        </div>
    </div>
    <div class="d-none">
        <div class="pr-2">Rechercher&nbsp;: </div>
        <input id="live-search" type="text" class="" placeholder="Tapez quelque chose">
    </div>
    <div id="main-grid" class="d-none"></div>

    <div class="">
        <h2 class="mb-3">Check des données</h2>
        <div class='border-2 border-rounded p-3'>
            <h3 class="fs-medium mb-1">Fichier CSV</h3>
            <?php
            $ok=true;

            $csv=$modir."/data/csv.csv";
            $arrays=loadcsv($csv);
            if($arrays){
                echo "Fichier CSV présent"; 

                echo "<h3 class=\"fs-medium mb-1\">Table de conversion</h3>";
                echo "<div class='mb-3'>Modifiez la variable csv_champs le fichier cvs_import_config.php au besoin.</div>";

                $keys_corr=array_flip($csv_champs);
                $keys_csv=array_flip($arrays[1]);
                foreach($keys_corr as $cle => $corr){
                    echo "<div>";
                    echo "<b>".$cle."</b>";
                    if(isset($keys_csv[$cle])){
                        echo " sera encodé dans ".$corr;
                    } else {
                        echo " n'a pas de correspondance";
                    }
                    echo "</div>";
                }
            } else {
                echo "Fichier CSV absent"; 
                $ok=false;
            }

            echo "<hr class='my-3'>";
            echo "<h3 class=\"fs-medium mb-1\">Dossier documents</h3>";
            if(is_dir($modir."/data/documents")){

                $fi = new FilesystemIterator($modir."/data/documents", FilesystemIterator::SKIP_DOTS);
                if(iterator_count($fi) > 0){
                    echo "Le dossier \"documents\" contient des dossiers ou fichiers";
                } else {
                    echo "Le dossier documents est vide. Vérifiez qu'il existe et porte le bon nom (documents).";
                }
            } else {
                echo "Le dossier \"documents\" n'existe pas.";
            }
            if($ok){
                
                echo "<select name='type_import'>";
                echo "<option value='add'>Ajouter les items</option>"
                echo "<option value='replace'>Remplacer le contenu par celui du CSV</option>"
                echo "</select>";
                
                
                echo "<div class='nodecoration mt-4'><a href=\"?template=modules/module_csv_import/csv_import.php\" class='btn btn-ok'>Lancer l'importation</a></div>";
            }
            ?>
        </div>
    </div>
</section>

<?php

include(getSnippetFile("code-viewer.php"));
include(getSnippetFile("code-footer.php"));