<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$modir=__DIR__;
//include(getSnippetFile("code-header.php"));


include("import_trombinoscope_config.php");
include("docs_functions.php");

//exec("convert test.pdf -resize 120 image.pdf.jpg", $output, $returnVar);

//print_r($returnVar);
include(getSnippetFile("code-header.php"));
?>
<header id="main-header" class="p-3">
    <?php
    include(getSnippetFile("code-pageheader-top.php"));
    ?>
    <hr class="hr-light">
</header>
<section id="main-container" class="container px-3 pb-4">
    <h2 class="pb-3">Importation des éléments du trombinoscope</h2> 
    <div class="">
        <?php
        $uploads=glob(CHEMIN."upload/*.{".getext()."}",GLOB_BRACE);
        $ok=count($uploads);

        if($ok){
            foreach($uploads as $upload){
                $infos=pathinfo($upload);
                $ext = strtolower($infos['extension']);
                if($ext=="jpeg"){ $ext="jpg"; }

                $filename=stripAccents($infos['filename']).".".$ext;
                if(file_exists(IMPORTS.$filename)){
                    echo "<p class='color-notok'>".$filename." namefile existe déjà - renommer en ";
                    $filename=stripAccents($infos['filename'])."_".uniqid().".".$ext;
                    echo $filename."<p>";
                }

                // déplacer le fichier
                if(CREATE_YAML){
                    rename($upload, IMPORTS.$filename);
                    echo "<p class='color-ok my-0'>Move doc to ".$filename."</p>";
                } else {
                    echo "<p class='color-notok my-0'>NO COPY of ".$filename."</p>";
                }

                $item=new yamlReadwriter(); 
                $item->loadYaml(getTemplate("structure_item.yaml"));
                $item->setType("item"); // important
                $item->setDestinationFolder(CONTENTS."items/");

                // nommage
                $pn=preg_split("/[_ ]+/", $infos['filename']);
                
                //$pn=explode("_",$infos['filename']);

                switch($_GET['nommage']){
                    case "nom":
                        $item->set('nom',human_name($infos['filename']));
                        break;
                    case "nomprenom":

                        if(count($pn) > 1){
                            $item->set('nom',ucfirst(array_shift($pn)));
                            $item->set('prenom',ucwords(implode(" ",$pn)));
                        } else {
                            $item->set('nom',human_name($infos['filename']));
                        }
                        break;

                    default:
                        // retirer l'extension et lettre le nom de fichier
                        $item->set('nom',$infos['filename']);

                }
                $item->set(IMPORTAG,$filename);  
                // et on sauve
                if(CREATE_YAML){
                    $itemurl=$item->writeyaml();
                    echo "<p class='color-ok my-0'>Créé item ".$itemurl."</p>";
                } else {
                    echo "<p class='color-notok my-0'>NO YAML CREATION</p>";
                }        
            }
            supprimer_cache();
        } else {
            echo "Pas de fichiers éligibles.";

        }
        ?>
    </div>
</section>
<?php

include(getSnippetFile("code-viewer.php"));
include(getSnippetFile("code-footer.php"));