<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$modir=__DIR__;
//include(getSnippetFile("code-header.php"));


include("importconfig.php");
include("docs_functions.php");

//exec("convert test.pdf -resize 120 image.pdf.jpg", $output, $returnVar);

//print_r($returnVar);
include(getSnippetFile("code-header.php"));
?>
<header id="main-header" class="p-3">
    <?php
    include(getSnippetFile("code-pageheader-top.php"));
    ?>
</header>
<section id="main-container" class="container px-3 pb-4">
    <h2 class="pb-3">Importation de documents</h2> 
    <div class="">
        <?php
        $uploads=glob(CHEMIN."upload/*.{".getext()."}",GLOB_BRACE);
        $ok=count($uploads);
        if($ok){
            foreach($uploads as $upload){
                $infos=pathinfo($upload);
                $ext = strtolower($infos['extension']);
                if($ext=="jpeg"){ $ext="jpg"; }
                $filename=stripAccents($infos['filename'])."_".hash('adler32',uniqid()).".".$ext;
                if(file_exists(IMPORTS.$filename)){
                    echo "<p class='color-notok'>".$filename." namefile existe déjà - renommer en ";
                    $filename=stripAccents($infos['filename'])."_".uniqid().".".$ext;
                    echo $filename."<p>";
                }

                // déplacer le fichier
                if(CREATE_YAML){

                    if(COPYDOC){
                        copy($upload, IMPORTS.$filename);
                        echo "<p class='color-ok my-0'>Copy doc to ".$filename."</p>";
                    } else {
                        rename($upload, IMPORTS.$filename);
                        echo "<p class='color-ok my-0'>Move doc to ".$filename."</p>";
                    } 
                } else {
                    echo "<p class='color-notok my-0'>NO COPY of ".$filename."</p>";
                }

                $item=new yamlReadwriter(); 
                $item->loadYaml(getTemplate("structure_item.yaml"));
                $item->setType("item"); // important
                $item->setDestinationFolder(CONTENTS."items/");

                $item->set(TITRE,human_name($infos['filename']));  
                $item->set(IMPORTAG,$filename);  

                // et on sauve
                if(CREATE_YAML){
                    $itemurl=$item->writeyaml();
                    echo "<p class='color-ok my-0'>Créé item ".$itemurl."</p>";
                } else {
                    echo "<p class='color-notok my-0'>NO YAML CREATION</p>";
                }        
            }
            supprimer_cache();
        } else {
            echo "Pas de fichiers éligibles.";

        }
        ?>
    </div>
</section>
<?php

include(getSnippetFile("code-viewer.php"));
include(getSnippetFile("code-footer.php"));