<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include("table_conversion.php");
include("functions.php");

function createcel($content, $css=false){
    echo "<td";
    if($css){
        echo " class=\"".$css."\"";
    }
    echo ">".$content."</td>\n";
}

include(getSnippetFile("code-header.php"));
?>
<header id="main-header" class="p-3">
    <?php
    include(getSnippetFile("code-pageheader-top.php"));
    ?>
</header>
<section id="main-container" class="px-3 pb-4">
    <h2 class="pb-3">Importation des XML</h2>
    <div class="pb-3">
        Ce module permet d'importer des xml depuis le logiciel XML collection. Pour ce faire:<br>
        1) placez le fichier de description structure_xml dans le dossier<br>
        2) placer une copie des xml dans le dossier  <b>modules/module_import_xml/to_import/</b><br> <b>modules/module_import_xml/to_import/xmls</b><br>et 3) éventuellement les documents dans <b>modules/module_import_xml/to_import/fichiers</b>.<br>
        Ensuite rechargez cette page.

    </div>
    <div class="d-none">
        <div class="pr-2">Rechercher&nbsp;: </div>
        <input id="live-search" type="text" class="" placeholder="Tapez quelque chose">
    </div>
    <div id="main-grid" class="d-none"></div>

    <div class="">
        <?php
        $etape=0;

        if(isset($_GET['etape'])){
            $etape=$_GET['etape'];
        }



        $modir=__DIR__;
        // etape 0 : lister les contenus
        if($etape==0){
            $ok=true;
            echo "<div class='border-2 border-rounded p-3'>";

            // fichier de description xml
            echo "<h2 class=\"mb-3\">Structure des XML</h2>";
            $structureurl=$modir."/to_import/structure_xml.xml";
            if(file_exists($structureurl)){
                echo "<div class='pb-3'>Fichier de description présent!</div>";
                $structure=xml2array($structureurl);

            } else {
                echo "<div class='pb-3 color-notok'>Fichier de description absent!</div>";
                $ok=false;
            }
            echo "<hr>";

            // xmls présents
            $liste=getlist($modir."/to_import/xmls","xml");
            if($liste == false){
                $ok=false; 
            }
            echo "<hr>";

            // fichiers éventuels
            getlist($modir."/to_import/fichiers");


            echo "<hr>";



            // comparaison des clés xml - yaml
            echo "<h2>Clés des XML</h2>";

            // le yaml
            $syaml=new yamlReadwriter();
            $syaml->loadYaml(getTemplate("structure_item.yaml")); 


            $cleok=0;

            $cles=listecles($structure,$syaml->content,$table);

            foreach($structure['item'] as $cle=> $valeur){
                if(strpos($cle, "_attr")==true){ continue; }

                if(isset($cles[$cle])){
                    echo $cle." sera converti en ".$cles[$cle]."<br>";
                } else {
                    echo $cle." ne sera pas converti <br>";
                }
            }
            if(count($cles)==0){
                echo "<div class='pb-3 color-notok'>Il faut au moins une clé en commun entre les deux fichiers!</div>";
                $ok=false; // au moins une clé pour que ça marche
            }

            echo "<hr>";

            if($ok){
                echo "<div class='pb-3'>La conversion est possible: l'import va créer les fichiers yaml et les placer dans le dossier prévu. Les fichiers vont aussi être transférés. Vérifiez que tout est ok et lancez l'opération.</div>";
                echo "<div class='mt-3'><a class='btn btn-ok nodecoration' href='?".$_SERVER['QUERY_STRING']."&etape=1'>Lancer l'import</a></div>";
            } else {
                echo "<div>impossible d'aller plus loin. Vérifiez les infos</div>";
            }

            echo "</div>";
        }

        if($etape==1){
            echo "<h2 class=\"mb-3\">Etape 2</h2>";
            echo "<div class='fs-tiny'>";
            $syaml=new yamlReadwriter();
            $syaml->loadYaml(getTemplate("structure_item.yaml")); 
            $syaml->setDestinationFolder(CONTENTS."items/");
            $syaml->setType("item");

            $structure=xml2array($modir."/to_import/structure_xml.xml");
            $xmls=glob($modir."/to_import/xmls/*.xml");
            $fichiers=glob($modir."/to_import/fichiers/*");
            $cles=listecles($structure,$syaml->content,$table);

            $clesfiles=clesfiles($structure,$syaml->content,$table);

            foreach($xmls as $xml){
                // xml
                $structure=xml2array($xml);
                $f=pathinfo($xml);
                $syaml->cleanContents();
                $syaml->filename=$f['filename']."_".uniqid().".yaml";

                $out=(array) null;
                foreach($structure['item'] as $cle => $valeur){
                    if(isset($cles[$cle])){
                        $syaml->set($cles[$cle],$valeur);
                    } else {
                        $syaml->set($cle,$valeur); // on laisse écrire
                    }
                }

                // imports
                foreach($clesfiles as $cle => $conv){
                    $fs=$syaml->getAsarray($conv);
                    foreach($fs as $num => $f){
                        $from=$modir."/to_import/fichiers/".$f;
                        if(is_file($from)){
                            $infos=pathinfo($f);
                            $ext=strtolower($infos['extension']);
                            $nom=$infos['filename'];
                            $nfn=$nom."_".uniqid().".".$ext;
                            copy($from,IMPORTS.$nfn);
                            $fs[$num]=$nfn;
                            echo "<div>Fichier $f copié sous le nom de $nfn</div>";
                        } else {
                            echo "<div>Fichier $from absent, non copié</div>";
                        }
                        if(count($fs)==1){
                            $fs=implode("",$fs);
                        }
                        $syaml->set($conv,$fs);
                    }
                }
                $fichier=$syaml->writeyaml();
                if($fichier){
                    echo "<div>Fichier ".$fichier." écrit</div>";
                } else {
                    echo "<div>Erreur d'écriture</div>";
                }
                echo "<hr>";
            }
            echo "</div>";
            echo "<div>Terminé!<br><a href='./'>Retour à la mosaique</a></div>";

        }
        ?> 


    </div>
</section>

<?php

include(getSnippetFile("code-viewer.php"));
include(getSnippetFile("code-footer.php"));


?>