<?php
// creer l'url
if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on'){
    $link = "https://".$_SERVER['HTTP_HOST'].preg_replace("/\?.*$/","",$_SERVER["REQUEST_URI"]);
} else {
    $link = "http://".$_SERVER['HTTP_HOST'].preg_replace("/\?.*$/","",$_SERVER["REQUEST_URI"]);
}
define("URL",$link);

setlocale (LC_TIME, 'fr_FR.utf8','fra');

define("CONTENTS",CHEMIN."contents/");
define("THEMES",CHEMIN."themes/");
define("CONFIG",CONTENTS."config/");
define("IMPORTS",CONTENTS."imports/");
define("CACHE",CONTENTS."cache/");
define("CACHE_VIGNETTES", CACHE."vignettes/");
define("TEMP", CACHE."temp/");

// adresses publiques
define("IMPORTS_URL","contents/imports/");
define("CACHE_VIGNETTES_URL", "contents/cache/vignettes/");
define("TEMP_URL", "contents/cache/temp/");

// taille maximum des imports d'image
define("FILE_MAXSIZE", 15700000); // 15 mégas

// starter: charger les fichiers nécessaire
include(APP."code/Spyc.php");
include(APP."code/yaml_readwriter.php");

// déployer le site si c'est une fresh install
include(APP."code/deploy.php");
deployerAppIfNotYet();

// charger le thème
$theme=new yamlReadwriter();
$theme->loadYaml(CONFIG."settings/settings_theme.yaml");
define("THEME", $theme->get('theme'));

// charger les composantes du thème lui-même
$themespec=new yamlReadwriter();
$themespec->loadYaml(THEMES.THEME."/config.yaml");
foreach($themespec->content as $key=>$val){
    $theme->contentAddField($key,$val);
}
// charger les fonctions principales
include(APP."code/main_functions.php");
include(APP."code/image_functions.php");
include(APP."code/cache_functions.php");

// charger les listes pour les formulaires
define("LISTES",Spyc::YAMLLoad(getTemplate("listes.yaml")));

// session
session_save_path(CONTENTS.'sessions');
ini_set('session.gc_probability', 1);
if(session_status() === PHP_SESSION_NONE) @session_start(); // erreur silencieuse
if(isset($_SESSION['id'])){
    define("STATUS","admin"); 
} else {
    define("STATUS","visitor"); 
}

// charger le fichier de settings général
$site=new yamlReadwriter();
$site->loadYaml(CONFIG."settings/settings_website.yaml");
define("VIGNETTE_W", $theme->get('vignette_width')); 
define("VIGNETTE_H", $theme->get('vignette_height'));
define("VIGNETTE_C", $theme->bool('vignette_crop'));
define("FULLSIZE_W", $theme->get('fullimage_width'));
define("FULLSIZE_H", $theme->get('fullimage_height'));
define("FULLSIZE_INFOS", $site->get('fw_info'));

// Charger les modules éventuels
define("MODULES",chargerModules());