init_navigation()

function init_navigation(){
    const toggles = document.querySelectorAll('[data-toggle-button], [data-nav-button]');
    toggles.forEach(function(el){
        const target=el.getAttribute("data-toggle-button") || el.getAttribute("data-nav-button")
        el.onclick=function(){
            let state=el.getAttribute("data-toggle-state")
            
            // fermer tous les onglets de la meme famille "data-toggle-unique"
            if(el.hasAttribute("data-toggle-unique")){
                let u=el.getAttribute("data-toggle-unique")
                document.querySelectorAll("[data-toggle-unique='"+u+"']").forEach(function(el2){
                    el2.setAttribute("data-toggle-state","hide")
                })
            }
            
            if(state=='show'){
                el.setAttribute("data-toggle-state","hide")
                document.querySelectorAll("[data-toggle-target='"+target+"'], [data-nav-menu='"+target+"']").forEach(function(item){
                    item.setAttribute("data-toggle-state","hide")
                })
            } else {
                el.setAttribute("data-toggle-state","show")
                document.querySelectorAll("[data-toggle-target='"+target+"'], [data-nav-menu='"+target+"']").forEach(function(item){
                    item.setAttribute("data-toggle-state","show")
                })
            } 
        }
    })
} 

/* navigation en scroll 
attribuer data-nav-scroll au conteneur des liens
*/
document.querySelectorAll('[data-nav-scroll] a[href^="#"]')
    .forEach(trigger => {
    trigger.onclick = function(e) {
        e.preventDefault();
        let hash = this.getAttribute('href');
        let target = document.querySelector(hash);
        let headerOffset = 20;
        let elementPosition = target.offsetTop;
        let offsetPosition = elementPosition - headerOffset;

        window.scrollTo({
            top: offsetPosition,
            behavior: "smooth"
        });
    };
});

/* fullscreen */
function openFullscreen(lequel) {
    var elem = document.querySelector(lequel)
    if (elem.requestFullscreen) {
        elem.requestFullscreen();
    } else if (elem.mozRequestFullScreen) { /* Firefox */
        elem.mozRequestFullScreen();
    } else if (elem.webkitRequestFullscreen) { /* Chrome, Safari & Opera */
        elem.webkitRequestFullscreen();
    } else if (elem.msRequestFullscreen) { /* IE/Edge */
        elem.msRequestFullscreen();
    }
}

function closeFullscreen(){
    if (document.exitFullscreen) {
        document.exitFullscreen();
    } else if (document.webkitExitFullscreen) {
        document.webkitExitFullscreen();
    } else if (document.mozCancelFullScreen) {
        document.mozCancelFullScreen();
    } else if (document.msExitFullscreen) {
        document.msExitFullscreen();
    }
}