<?php


function display_modinput($ad,$check,$css="bg-light"){
    $configfile=$ad."/modconfig.yaml";
    if(!file_exists($configfile)){
        echo "Pas de fichier de config pour ".$configfile;
        return;
    }
    $config=Spyc::YAMLLoad($configfile);
    echo "<div class='p-2 mb-2 flex flex-gap-2 justify-content-between ".$css."' style='flex-wrap:nowrap'><div>";
    echo "<div class='ff-bold-primary'>".$config['title']."</div>";
    if(isset($config['description'])){
        echo "<div class='fs-small my-1'>".$config['description']."</div>";
    }

    echo "</div><div>";
    echo "<input type='checkbox' name='modulename[]' value='".$ad."'";
    if($check == true){ echo " checked"; }
    echo ">"; 

    echo "</div></div>";
}
?>

<div class="p-3">
    <h2 class="mb-2">Gérer les modules</h2>
    <div class="mb-3 ff-secondary fs-small">Les modules peuvent être activés et désactivés ici. Selon les cas, les modules injectent du code php, css, js, des éléments dans le menu des pages ou de l'admin, ou des éléments dans les items. Désactivez donc les modules inutiles pour éviter des comportements inattendus.</div>
    <div>
    Attention: certains thèmes peuvent comporter leurs propres modules, qui ne sont pas activables ou désactivables ici. 
    
    </div>
    <form id="yc-form" method="post">

        <input type="hidden" name="type" value="module">
        <input type="hidden" name="action" value="modules_activation">
        <input type="hidden" name="callback" value="yc_filldestination">

        <h3 class="mb-2">Modules actifs</h3>
        <?php 
        // formulaire d'affichage
        $modactifs=glob(CHEMIN."modules/module_*",GLOB_ONLYDIR); 

        foreach($modactifs as $modactif){
            display_modinput($modactif, true, "bg-ok");
        }
        if(!count($modactifs)){
            echo "<div>Pas de module actif</div>";
        }
        ?>
        <h3 class="mb-2 mt-3">Modules inactifs</h3>
        <?php 
        // formulaire d'affichage
        $modinactifs=glob(CHEMIN."modules/-module_*",GLOB_ONLYDIR); 

        foreach($modinactifs as $modinactif){
            display_modinput($modinactif,false);
        }
        if(!count($modinactifs)){
            echo "<div>Pas de module inactif</div>";
        }
        ?>

        <div class="my-3" data-role="submit">
            <input type="submit" name="submit" class="btn btn-ok text-light" value="Updater la liste">
        </div>

    </form>

</div>