<?php
/* 
fonctions utiles
*/
function isadmin(){
    if(isset($_SESSION['login']) && isset($_SESSION['id'])){
        return true;
    }
    return false;
}

// permet l'inclusion soit depuis config, soit depuis le thème, soit depuis l'app
function getSnippetFile($file){
    if(file_exists(CONFIG."snippets/".$file)){
        return CONFIG."snippets/".$file;
    } else if(file_exists(THEMES.THEME."/snippets/".$file)){
        return THEMES.THEME."/snippets/".$file;
    } else {
        return APP."snippets/".$file; // worst case
    }
}

function getThemeFile($file){
    if(file_exists(CONFIG.$file)){
        return str_replace(CHEMIN,"",CONFIG.$file);
    } else if(file_exists(THEMES.THEME."/".$file)){
        return str_replace(CHEMIN,"",THEMES.THEME."/".$file);
    } else {
        return str_replace(CHEMIN,"",APP.$file);
    }
}

function getContentsFile($file){
    if(file_exists(CONTENTS.$file)){
        return str_replace(CHEMIN,"",CONTENTS.$file);
    } else {
        return str_replace(CHEMIN,"",APP.$file);
    }
}

function getTemplate($file){
    if(file_exists(CONFIG."settings/".$file)){
        return CONFIG."settings/".$file;
    } else if (file_exists(THEMES.THEME."/settings/".$file)){
        return THEMES.THEME."/settings/".$file;
    } else {
       return APP."default/".$file; 
    }
}

function writehtmlcode($file){
    if(file_exists($file)){
        $p = pathinfo($file);
        $file=str_replace(CHEMIN,"",$file);
        switch ($p['extension']){
            case "css":
                echo "<link rel=\"stylesheet\" href=\"".$file."\">\n";
                break;
            case "js":
                echo "<script src=\"".$file."\"></script>\n";
                break;
        }
    }
}

function duplicateFile($source,$dest){
    if(!is_file($source)){
        echo "Le fichier ".$source." n'existe pas, sorry.";
        return false;
    }
    if (!copy($source, $dest)) {
        echo "La copie $source du fichier a échoué...\n";
        return false;
    }
}



function supprimer_cache(){
    @unlink(CACHE."cached-mosaique.html"); 
    //@unlink(CACHE."cached-mosaique-order.yaml");
}

function supprimer_cache_images($image=false){
    if($image){
        $f=pathinfo(basename($image));
        $nom=$f['filename'];
        $images=glob(CACHE_VIGNETTES.$nom."*.{gif,png,jpg,webp}",GLOB_BRACE);
    } else {
        $images=glob(CACHE_VIGNETTES."*.{gif,png,jpg,webp}",GLOB_BRACE);
    }

    foreach($images as $image){
        @unlink($image); 
    }
    // vider le cache pour permettre la recréation des vignettes
    supprimer_cache(); 
}


function makeid($string){
    return strtolower(stripAccents($string));
}

function extractUrls( $string ) {
    preg_match_all("/(?:(?:https?|ftp):\/\/)(?:\S+(?::\S*)?@)?(?:(?!10(?:\.\d{1,3}){3})(?!127(?:\.\d{1,3}){3})(?!169\.254(?:\.\d{1,3}){2})(?!192\.168(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z\x{00a1}-\x{ffff}0-9]+-?)*[a-z\x{00a1}-\x{ffff}0-9]+)(?:\.(?:[a-z\x{00a1}-\x{ffff}0-9]+-?)*[a-z\x{00a1}-\x{ffff}0-9]+)*(?:\.(?:[a-z\x{00a1}-\x{ffff}]{2,})))(?::\d{2,5})?(?:\/[^\"\'\s]*)?/uix", $string, $post_links);

    $post_links = array_unique( array_map( 'html_entity_decode', $post_links[0] ) );

    return array_values( $post_links );
}

function stripAccents($string){
    $string= \Transliterator::create('NFD; [:Nonspacing Mark:] Remove; NFC')
        ->transliterate($string);
    $string = strtolower(str_replace(array(" ","°","+","=","'",'"',"(",")"),"_",$string));
    return $string;
}

function human_name($str){
    $t=explode(" ",str_replace(array("-","_",'.')," ",$str));
    for($i=0; $i<count($t);$i++){
        $t[$i]=ucfirst($t[$i]);
    } 
    return implode(" ",$t);
}
/* bouger le fichier du dossier temp au dossier import si le fichier existe là */
function validateTempfile($file){
    if(file_exists(TEMP.$file)){
        rename(TEMP.$file, IMPORTS.$file);
    }
    return $file;
}

function getcompletefilepath($file, $url=false){
    if(file_exists(IMPORTS.$file) && !$url){ return IMPORTS.$file; }
    if(file_exists(IMPORTS.$file) && $url){ return IMPORTS_URL.$file; }        
    if(file_exists(TEMP.$file) && !$url){ return TEMP.$file; }
    if(file_exists(TEMP.$file) && $url){ return TEMP_URL.$file; }
    return $file;
}

function human_filesize($bytes, $decimals = 2) {
    $factor = floor((strlen($bytes) - 1) / 3);
    if ($factor > 0) $sz = 'KMGT';
    return sprintf("%.{$decimals}f", $bytes / pow(1024, $factor)) . @$sz[$factor - 1] . 'B';
}

function formate_date($date, $type="full"){
    if(!$date){ return ""; }
    $date = date_parse($date);
    $return="";
    switch($type){
        case "full":
            $return= sprintf("%02d", $date["day"])."/".sprintf("%02d", $date["month"])."/".$date["year"];
            break;
        case "fullshort":
            $return= sprintf("%02d", $date["day"])."/".sprintf("%02d", $date["month"])."/".substr( $date["year"], -2);
            break;
        case "monthyear":
            $return= sprintf("%02d", $date["month"])."/".substr( $date["year"], -2);
            break;
        case "year":
            $return= $date["year"];
            break;
    }

    return $return;
}

function chargerModules(){
   $lmod=array_merge(glob(CHEMIN."modules/module_*",GLOB_ONLYDIR),glob(THEMES.THEME."/modules/module_*",GLOB_ONLYDIR)); // charger les modules du dossier modules et du thème
    $modules=array();
    $catmod=array("insert_admin","insert_pages","insert_item","insert_css","insert_js");
    foreach($catmod as $cat){
        $modules[$cat]=array();
    }
    foreach($lmod as $mod){
        $basemod=str_replace(CHEMIN,"",$mod);
        $configfile=$mod."/modconfig.yaml";
        if(!file_exists($configfile)){
            continue;
        }

        $ar = Spyc::YAMLLoad($configfile);
        foreach($catmod as $cat){
            if(isset($ar[$cat])){
                $modules[$cat][]=$basemod."/".$ar[$cat];
            }
        }
    }
    return $modules;
}