<?php

function get_file_icon($file){
    $ext=strtolower(pathinfo($file, PATHINFO_EXTENSION));
    switch($ext){
        case "jpg":
        case "webp":
        case "png":
        case "gif":
            $im=new thumbnail_tool(CHEMIN,CACHE_VIGNETTES,APP."images/");
            $im->set_source($file);
            $icon= $im->vignette(300,300,false);
            break;
        case "svg":
            $icon=getcompletefilepath($file);
            break;
        case "mp3":
        case "aac":
            $icon="app/images/file-music.svg";
            break;
        case "mp4":
        case "avi":
            $icon="app/images/file-movie.svg";
            break;
        case "zip":
            $icon="app/images/file-zip.svg";
            break;
        case "pdf":
            $icon="app/images/file-pdf.svg";
            break;
        default:
            $icon="app/images/file-base.svg";

    }
    return $icon;
} 

/*  
Classe de manipulation d'image
reçoit un dossier par défaut des images 
setsource envoie une adresse 

usage
$im=new thumbnail_tool(CHEMIN,CACHE_VIGNETTES,APP."images/");
$im->set_source($file);
$im->vignette(VIGNETTE_W,VIGNETTE_H,true)
$im->vignette(VIGNETTE_W,VIGNETTE_H) // le crop est true par défaut 

*/
class thumbnail_tool {
    public $im_defaut="defaut.png";
    public $im_defauto="defaut-oversize.png";

    public $source_folder=false; // depuis la racine, le dossier source
    public $dest_folder=false; // depuis la racine, le dossier dest

    public $im_file;
    public $vignette_file;

    //public $src_completepath; // depuis la racine du serveur
    //public $src_publicpath; // depuis la racine du site
    public $src_w;
    public $src_h;

    public $root;

    //public $src_publicfolder=false;
    //public $src_serverfolder=false;

    //public $vignette_publicfolder=false; // adresse serveur de la vignette
    //public $vignette_serverfolder=false; // adresse publique de la vignette

    public $maxsize=10000000000; // taille maximale de l'image en octet
    public $vignette_w=10000; // largeur max en pixels
    public $vignette_h=100000; // hauteur max en pixels
    public $vignette_crop=false;

    public $im_info;
    public $im_extension;
    public $im_size;

    /*
    constructeur: 
    fournir le dossier source $imsf 
    le dossier des vignettes  $imvf
    et le dossier des images par défaut $im_df
    */
    function __construct($root=__DIR__."/", $dest_folder=false,$defaut_folder=false ) {

        if(!is_dir($dest_folder) || !is_dir($defaut_folder)){
            return "Erreur, pas de folders";
        }

        // racine du serveur
        $this->root=$root;
        // rendre le path relatif
        $this->dest_folder=str_replace($root,"",$dest_folder);
        // images par défaut
        $defaut_folder=str_replace($root,"",$defaut_folder);
        $this->im_defaut=$defaut_folder.$this->im_defaut;
        $this->im_defauto=$defaut_folder.$this->im_defauto;
    }

    public function set_source($imsrc){
        // nettoyer le lien serveur pour obtenir le lien public
        $imsrc=str_replace($this->root,"",trim($imsrc));
        // si l'image n'existe par, préparer la vignette par défaut
        if($imsrc=="" || !is_file($this->root.$imsrc) ){
            $this->im_file=$this->im_defaut;
        } else {
           $this->im_file=$imsrc; 
        }

        $this->im_info=pathinfo($this->root.$this->im_file);
        $this->im_extension=$this->im_info['extension'];

        // vérifier l'extension
        $ext_image=array('jpg','jpeg','png','gif','webp','svg');
        if(!in_array($this->im_extension,$ext_image)){ 
            $this->im_file=$this->im_defaut;
        }

        // vérifier la taille
        $this->im_size=filesize($this->root.$this->im_file);
        if($this->im_size > $this->maxsize){
            $this->im_file=$this->im_defauto;
        } 

        // encoder la taille
        list($width, $height, $type, $attr) = getimagesize($this->root.$this->im_file);
        $this->src_w=$width;
        $this->src_h=$height;
    }

    public function vignette($dw=false,$dh=false,$crop=true){
        if(!$dw){ $dw= $this->vignette_w; }
        if(!$dh){ $dw= $this->vignette_h; }
        return $this->get_vignette($dw,$dh,$crop);
    }

    private function get_vignette($dw,$dh,$crop){

        // si l'image est plus petite que la vignette, renvoyer l'original
        if($this->src_w < $dw || $this->src_h < $dh){ 
            return $this->im_file."?".filectime($this->root.$this->im_file);
        }

        // c'est parti !
        $suffixe="_".$dw."x".$dh.($crop ? "_crop" : "_nocrop")."_".hash('adler32',filectime($this->root.$this->im_file));
        $vignettefile=$this->im_info['filename'].$suffixe.".".$this->im_extension;

        // voir si la vignette existe déjà, si oui la renvoyer directement
        if(file_exists($this->root.$this->dest_folder.$vignettefile)){
            return $this->dest_folder.$vignettefile."?".filectime($this->root.$this->dest_folder.$vignettefile);
        } 

        switch($this->im_extension){
            case 'gif': $img = imagecreatefromgif($this->root.$this->im_file); break;
            case 'jpg': $img = imagecreatefromjpeg($this->root.$this->im_file); break;
            case 'png': $img = @imagecreatefrompng($this->root.$this->im_file); break;
            case 'webp': $img = imagecreatefromwebp($this->root.$this->im_file); break;
            default : return $this->im_defaut;
        }
        if($crop){
            $ratio = max($dw/$this->src_w, $dh/$this->src_h);
            $y= ($this->src_h - $dh / $ratio) /2;
            $x = ($this->src_w - $dw / $ratio) / 2;
            $nheight = $dh / $ratio;
            $nwidth = $dw / $ratio;
        } else {
            $ratio = min($dw/$this->src_w, $dh/$this->src_h);
            $dw = intval($this->src_w * $ratio);
            $dh = intval($this->src_h * $ratio);
            $x = 0;
            $y = 0;
            $nheight = $this->src_h;
            $nwidth = $this->src_w;
        }

        $vignette = imagecreatetruecolor($dw, $dh);

        // preserve transparency
        if($this->im_extension == "gif" || $this->im_extension == "png"){
            imagecolortransparent($vignette, imagecolorallocatealpha($vignette, 0, 0, 0, 127));
            imagealphablending($vignette, false);
            imagesavealpha($vignette, true);
        }

        imagecopyresampled($vignette, $img, 0, 0, $x, $y, $dw, $dh, $nwidth, $nheight);
        //$sharpen = array([-1,-1,-1], [-1, 16, -1], [-1,-1,-1]);
        //imageconvolution($vignette, $sharpen, 8, 0);

        switch($this->im_extension){
            case 'gif': imagegif($vignette, $this->root.$this->dest_folder.$vignettefile); break;
            case 'jpg': imagejpeg($vignette, $this->root.$this->dest_folder.$vignettefile); break;
            case 'png': imagepng($vignette, $this->root.$this->dest_folder.$vignettefile); break;
            case 'webp': imagewebp($vignette, $this->root.$this->dest_folder.$vignettefile); break;
        }
        imagedestroy($vignette);
        imagedestroy($img);

        return $this->dest_folder.$vignettefile."?".filectime($this->root.$this->dest_folder.$vignettefile);

    }

    public function human_size($decimals = 2) {
        $factor = floor((strlen($this->im_size) - 1) / 3);
        if ($factor > 0) $sz = 'KMGT';
        return sprintf("%.{$decimals}f", $this->im_size / pow(1024, $factor)) . @$sz[$factor - 1] . 'B';
    }

}