<main id="main-container" class="px-3">
    <?php
    /*
    Si une requete get est passée
    l'analyser et la vérifier 
    elle doit correspondre à un item ou une collection
    ?c= ou ?i=
    */
    $visitor=STATUS."-";
    $show="";

    if($site->get('param_mode_visiteur')=="fullopen"){
        $show="open";
    }

    // récupérer la requete get
    if(isset($_GET['i'])){
        $item_url=$_GET['i'].".yaml"; // arrive sans extension
        // vérifier l'existence du yaml
        if(is_file(CONTENTS."items/".$item_url)){
            $show="item";
        }
    }
    if(isset($_GET['c'])){
        $collection_url=$_GET['c'].".yaml"; // arrive sans extension
        // vérifier l'existence du yaml et que les collections sont utilisées
        if(is_file(CONTENTS."collections/".$collection_url) && $site->bool("tool_collections")){
            $show="collection";
        }
    }

    // verifier que le requetes pour les visiteurs sont possibles
    if($site->get('param_mode_visiteur')=="closed"){
        $show="closed";
    }

    // on charge en fonction des cas
    switch($visitor.$show){
        case "visitor-collection":
            $file="code-main-request-collection.php";
            echo "je charge la collection";
            include(getSnippetFile($file));
            break;
        case "visitor-item":
            $file="code-main-requestitem.php";
            include(getSnippetFile($file));
            break;
        case "admin-collection":
            $file="code-main-mosaic.php";
            include(getSnippetFile($file));
            echo "<script>window.onload = function(event) { yc_showCollection(this,'".$collection_url."') }</script>";
            break;        
        case "admin-item":
            $file="code-main-mosaic.php";
            include(getSnippetFile($file));
            echo "<script>window.onload = function(event) { document.querySelector('#main-grid .item').click() }</script>";
            break;
        case "admin-":
        case "admin-open":
        case "admin-closed":
        case "visitor-open":
            $file="code-main-mosaic.php";
            include(getSnippetFile($file));
            break;
        case "visitor-":
        case "visitor-closed":
            $file="code-main-closed.php";
            include(getSnippetFile($file));
            // ici déclencher le javascript pour afficher la collection
            break;
    }

    ?> 
    <?php
    // afficher le message de création d'un accès
    $acc=GLOB(CONFIG."access/*.yaml");
    if(!count($acc)){
    ?>
    <div class="text-center py-4">
        Il semble que vous venez d'installer YAML Collection.<br>
        <div class="my-3">
            <span class="link-behavior underline py-4" onclick="yc_loadform('access')">Créez votre login et mot de passe</span>
        </div>
        <div>puis</div>
        <div class="py-3"><span class="link-behavior underline " onclick="yc_editTheme()">sélectionnez un thème adapté à vos contenus</span>
        </div>pour démarrer efficacement.

    </div>
    <?php
    }
    ?>
</main>