<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include("csv_import_config.php");
include("csv_functions.php");

$modir=__DIR__;
$ext_image=array('jpg','jpeg','png','gif','webp');
$rapport="";

// pour visualiser sans exécuter , placer à FALSE
define("CREATE_YAML", true); 
define("IMPORT_FILES", true);

/*

présets d'import

*/

//$csv_source="data/csv_GEN_78.csv";
//$csv_source="data/csv_79-80.csv";
$csv_source="data/csv_81-82.csv";
//$csv_source="data/csv-complet.csv";
$docs_source="data/documents/";
$dossiers=get_directories($modir."/".$docs_source);


// affichage de la page
include(getSnippetFile("code-header.php"));
?>
<header id="main-header" class="p-3">
    <?php
    include(getSnippetFile("code-pageheader-top.php"));
    ?>
</header>
<section id="main-container" class="px-3 pb-4">
    <h3 class="pb-3">Importation depuis un CSV</h3>
    <div class="d-none">
        <div class="pr-2">Rechercher&nbsp;: </div>
        <input id="live-search" type="text" class="" placeholder="Tapez quelque chose">
    </div>
    <div id="main-grid" class="d-none"></div>

    <div class="">
        <?php

        $arrays=loadcsv($modir."/".$csv_source);

        // virer les premières lignes
        unset($arrays[0]);
        unset($arrays[1]);

        echo "<table class='fs-small ff-secondary'>";
        echo "<thead>";
        write_row($csv_champs);

        echo "</thead>";

        $le=count($csv_champs);
        $code_annee="";
        $descriptif_meta="";
        $pattern_descriptif="/GE-\d{4}-\d{1,2}(-\d{0,2})?(.*)/i";
        $pattern_codeannee="/GE-\s?(\d{4}|GEN).*/i";

        foreach($arrays as $num => $row){

            if($row[1]==""){ 
                /*
            Le deuxième champ est vide: c'est une ligne de séparation avec code
        detecter les code type 'GE-1981' qui deviennent le code date

        detecter les codes type 'GE-1981-1 et un texte' qui deviennent le libellé de l'expo

        */
                $string=trim($row[0]);
                if(preg_match($pattern_descriptif, $string, $matches, PREG_OFFSET_CAPTURE)){
                    $descriptif_meta=trim($matches[2][0]);
                } elseif(preg_match($pattern_codeannee, $string, $matches, PREG_OFFSET_CAPTURE)){
                    $code_annee=$matches[1][0];
                    if($code_annee=='GEN'){
                        $code_annee="Generalia";
                    }
                }

                continue; 
            }

            $row[15]=$code_annee;
            $row[16]=$descriptif_meta;
            


            // raccourcir à la taille des champs
            $row=array_slice($row, 0, $le);
            write_row($row);

            // traitement du yaml et des imports
            echo "<tr><td colspan='".$le."'>";
            $dossier=$row[0];

            // trouver le dossier dans la liste, si pas de correspondance, sauter

            if(isset($dossiers[$dossier])){ 
            $url_dossier=$dossiers[$dossier];
            } else{
                $dossier=false;
            }

            if(is_dir($url_dossier)){
                echo "Recherche dans ".$url_dossier."<br>";
                $row[14]="Dossier:".$url_dossier;
                echo "<p class='mt-0'>Techspecs ".$row[14]."</p>";
                echo "Code : ".$row[15]."<br>";
                echo "Méta descriptif : -".$row[16]."-";

                // fichiers du dossier: un item
                $files=glob($url_dossier."/*.*");

                // sous-dossiers éventuels
                $dirs=glob($url_dossier."/*",GLOB_ONLYDIR);

                foreach ($dirs as $dir) {
                    echo "<div class='color-ok'>Trouvé un sous-directory".$dir."</div>";
                    $morefilesfiles=glob($dir."/*.*");
                    $files = array_merge($files, $morefilesfiles);
                }

                $listfiles=array();
                foreach($files as $file){
                    echo "<p class='color-ok mb-0'>Trouvé ".$file."</p>";
                    $listfiles=copyfiles($file,$listfiles);

                    $infos=pathinfo($file);
                    $ext=strtolower($infos['extension']);
                    // check du poids des images
                    if(in_array($ext,$ext_image)){ 
                        // si le fichier est trop lourd, envoyer une image warning
                        if(filesize($file) > FILE_MAXSIZE){ 

                            $nom=explode("/data/",$file);

                            echo "<div class='color-notok'>".$nom[1]." : taille supérieure au maximum serveur: ".filesize($file)."</div>";
                            $rapport.=$nom[1]."\n";
                        }
                    }
                }

                createitem($row, $listfiles);
            } else {
                echo "<p class='color-notok my-0'>Pas trouvé de dossier ".$dir."</p>";
                $listfiles=array();
                createitem($row, $listfiles);
            }
            echo "</td></tr>";
        }
        echo "</table>";

        echo "<h3 class='mb-1'>Ecriture du rapport</h3>";
        $entete="Liste des fichiers dont la taille dépasse les limites serveur autorisée (".FILE_MAXSIZE.")\n\r";
        $wr=file_put_contents($modir."/rapport.txt", $entete.$rapport);
        if($wr){
            echo "<div class='mb-4'>Rapport écrit</div>";
        }

        ?>
    </div>
</section>
<?php
include(getSnippetFile("code-viewer.php"));
include(getSnippetFile("code-footer.php"));
?>