// fonction de gestion des upload en ajax

function yc_init_uploadform(){ 
    tags=document.querySelectorAll("[data-uploader-init='false']")
    tags.forEach(function(elem){

        let inputf=elem.querySelector("input")

        let filesettings= {
            inputParent: elem, 
            inputField: inputf,
            inputAccept: inputf.getAttribute("accept"),
            multiple: inputf.getAttribute("multiple"),
            name: inputf.getAttribute("name"),
            uploadContainer: elem.querySelector(".files-container"),
            plusbutton: elem.querySelector(".file-add"),
            plusbuttonText: elem.querySelector(".file-add span")
        }

        // initialiser le bouton +
        filesettings.plusbutton.onclick=function(){
            filesettings.inputField.click()
        }

        filesettings.inputField.onchange = function(event){
            console.log("start onchange")
            
            var args = new FormData();
            args.append("accept", filesettings.inputAccept)
            args.append("tagname", filesettings.name)
            args.append("item", filesettings.inputSource) // en fait, pas nécessaire

            args.append("type", "file")
            args.append("multiple", filesettings.multiple)
            args.append("action", "getfile")
            args.append("warning", true)

            var file_number = 1;
            var error = '';

            console.log("files: "+filesettings.inputField.files.length)
            console.log(filesettings.inputField.value)

            elem.classList.add("wait")

            for(var count = 0; count < filesettings.inputField.files.length; count++){                
                args.append("files[]", filesettings.inputField.files[count]);
                file_number++;
            }

            for (var pair of args.entries()) {
                console.log(pair[0]+ ', ' + pair[1]); 
            }

            if(error != ''){
                filesettings.uploadContainer.innerHTML = error;
                //inputf.value = '';
            } else {
                let http = new XMLHttpRequest()
                http.open("POST", 'app/async/async_start.php', true)
                http.send(args);

                http.onloadstart = function(){
                    //destination.classList.add("wait")
                }
                http.onloadend = function(){
                    //destination.classList.remove("wait")
                    yc_file_controlUploadState(elem)
                    settings.viewerwarning="savebeforeclose"

                    elem.classList.remove("wait")

                }
                http.onreadystatechange = function() {
                    if (this.readyState == 4 && this.status == 200) {
                        filesettings.uploadContainer.innerHTML+=this.responseText
                    }
                }
            }
        }
        elem.setAttribute("data-uploader-init","done")
        yc_file_controlUploadState(elem)
    })
}

function yc_file_delete(elem){
    if(promptIt("Etes-vous sûr de supprimer ce fichier")){        
        let box=document.querySelector("[data-file='"+elem+"']")
        let inputfield=box.querySelector("input")
        let attr=inputfield.getAttribute("name")
        let filecontainer=box.closest(".filecontainer")

        box.classList.add("f-disabled")
        inputfield.setAttribute("name","delete-"+attr)

        settings.viewerwarning="savebeforeclose"

        yc_file_controlUploadState(filecontainer)
    }
}

function yc_file_controlUploadState(elem){
    // regarde le nombre de documents uploadés
    // regarde si multiple
    // affiche ou pas le signe plus avec le commentaire
    let filescontainer=elem.querySelector(".files-container")
    let plusbutton= elem.querySelector(".file-add")
    let plusbuttonText= elem.querySelector(".file-add span")

    let maininput= elem.querySelector("input[type='file']")
    let multiple= maininput.hasAttribute("multiple")

    let nb= filescontainer.querySelectorAll(".f-box:not(.f-disabled)").length
    if(nb==0){
        plusbuttonText.innerHTML="Sélectionner le fichier"
        plusbutton.style.display="flex"
        console.log("montrer nb 0")

    } else if(nb > 0 && multiple!==false){
        plusbuttonText.innerHTML="Ajouter le fichier"
        plusbutton.style.display="flex"
        console.log("montrer")

    } else if(nb > 0 && multiple===false){
        plusbutton.style.display="none"
        console.log("cacher")
    }
}