<?php

/* Fonction activée si
 - une nouvelle liste d'ordre des items est envoyée 
 - le cache html n'existe pas, il faut recharger l'ordre et l'updater

 */
function create_mosaique_order($items=false){
    // 1
    // demande de reconstruction de l'ordre sur base de liste fournie
    // demande prioritaire
    if(is_array($items)){
        write_order_cache($items);
        return;
    }

    $realitems=array();
    $l = glob(CONTENTS."items/*.yaml",GLOB_BRACE);
    for($i=0;$i< count($l); $i++){
        $realitems[$i]=basename($l[$i]); 
    }

    // 2
    // le cache n'existe pas, on le crée et l'envoie
    $ordercachefile = CACHE.'cached-mosaique-order.yaml';
    if(!file_exists($ordercachefile)){
        write_order_cache($realitems);
        return;
    }

    //3
    // le cache existe. Le vérifier
    // quels items n'existent plus, lesquels sont nouveaux?
    $oldordercache= Spyc::YAMLLoad($ordercachefile);
    $newordercache=array();
    $update_cache=false;
    for($i=0;$i<count($oldordercache);$i++){
        // est ce que l'élément existe réellement? Sinon le supprimer du cache d'ordre
        if(in_array($oldordercache[$i],$realitems)){
            // l'element existe, le retirer de la liste du folder pour ne garder que les nouveaux éventuels
            $newordercache[]=$oldordercache[$i];

            // le supprimer de la liste des items pour repérer les nouveaux ajouts plus tard
            $key=array_search($oldordercache[$i], $realitems);
            unset($realitems[$key]);

        } else {
            // l'élément n'existe pas physiquement, le supprimer du cache
            //unset($oldordercache[$i]);
            $update_cache=true;
        }
    }
    
    
    // check fini, voir s'il reste des éléments physique non supprimé, donc à ajouter au cache
    if(count($realitems) > 0){        
        $newordercache=array_merge($newordercache,$realitems);
        $update_cache=true;
    }
    if($update_cache){
        write_order_cache($newordercache);
    }
    return true;
}

function write_order_cache($new_cache){
    $yaml_str = Spyc::YAMLDump($new_cache);
    $cachefile=CACHE.'cached-mosaique-order.yaml';
    if(file_put_contents($cachefile,$yaml_str)){
        return true;
    } else {
        echo "Probleme lors de l'écriture de ".$cachefile;
        return false;
    }
}

?>