<?php
switch($_POST['action']){
    case "loadform":
        $menu_edit= array();
        include(APP."snippets/menu-viewer.php");

        $item=new yamlReadwriter();
        $item->loadYaml(getTemplate("structure_item.yaml"));
        $item->setType("items_modify"); // important
        
        $item->addHidden("action","submitform");
        $item->addHidden("callback","yc_updategriditems");           
        $item->addHidden("endaction","yc_closeViewer");         
        
        $item->setSnippetFolder(APP."form_parts/");
        $item->form_title="Modifier plusieurs items";
        $item->form_comment="Sélectionnez les items à modifier dans la mosaïque.<br>Seuls les champs remplis ci-dessous seront modifiés pour chaque élément sélectionné.";
        $item->writeForm();
        break; 

    case "submitform":
        $item=new yamlReadwriter();
        $item->loadYaml(getTemplate("structure_item.yaml"));
        $item->setType("item"); // important
        $item->setDestinationFolder(CONTENTS."items/");
        $item->processPost(false);

        $retour=array();

        // récupérer les champs remplis
        $updatevals=$item->getFilledValues();
        
        // prendre les items un par un
        $files=$_POST['sources'];
        foreach($files as $item_url){
            $item->cleanContents();
            $item->loadContentFromYaml(CONTENTS."items/".$item_url);
            $item->loadContentFromArray($updatevals);
            $item->writeyaml();

            ob_start(); // Start the output buffer
            $snippet=getSnippetFile("display_item_mosaique.php");
            include($snippet);
            $html=ob_get_contents();
            ob_end_clean();

            $retour[] = array(
                'id' => $item->filename,
                'html' => $html
            );

        }
        echo json_encode($retour, JSON_HEX_QUOT | JSON_HEX_TAG);
        supprimer_cache();
        break;
}