<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$modir=__DIR__."/";
include("csv_functions.php");
include("csv_import_config.php");

$rapport="";
/*

présets d'import

*/
// affichage de la page
include(getSnippetFile("code-header.php"));
?>
<header id="main-header" class="p-3">
    <?php
    include(getSnippetFile("code-pageheader-top.php"));
    ?>
</header>
<section id="main-container" class="px-3 pb-4">
    <h3 class="pb-3">Importation depuis un CSV</h3>
    <div class="d-none">
        <div class="pr-2">Rechercher&nbsp;: </div>
        <input id="live-search" type="text" class="" placeholder="Tapez quelque chose">
    </div>
    <div id="main-grid" class="d-none"></div>

    <div class="">
        <?php
        $arrays=loadcsv($modir."/data/".$csv_source);
        // virer les lignes avant la description des colonnes
        for($i=0;$i<$rang_ids;$i++){
            unset($arrays[$i]); 
        }

        echo "<table class='fs-small ff-secondary'>";
        echo "<thead>";
        write_row($csv_champs);

        echo "</thead>";

        $le=count($csv_champs);
        $code_annee="";
        $descriptif_meta="";
        //$pattern_descriptif="/GE-\d{4}-\d{1,2}(-\d{0,2})?(.*)/i";
        //$pattern_codeannee="/GE-\s?(\d{4}|GEN).*/i";

        foreach($arrays as $num => $row){
            if(!$row[0] && !$row[1] && !$row[2]){
                continue;
            }
            // Puzlp structure d'intercalaire
            // 2e champ = intercalaire 1
            if($row[1]!=""){
                $row[3]=$row[1];
                $row[16]="separatorniv1";

            }
            // 3e champ - intercalaire 2
            if($row[2]!=""){
                $row[3]=$row[2];
                $row[16]="separatorniv2";
            }
            // raccourcir à la taille des champs
            $row=array_slice($row, 0, $le);
            write_row($row);

            // traitement du yaml et des imports
            echo "<tr><td colspan='".$le."'>";
            $dossier=trim($row[$docs_num_champ]);

            // chercher les documents afférants
            // soit un dossier, soit un fichier
            $files=array();

            if(!$dossier){
                createitem($num,$row, $files);
                echo "<p class='color-notok my-0'>Pas de cote</p>";
                continue; 
            }
            if(is_dir($modir."data/".$docs_source.$dossier)){
                // charger les fichiers du dossier 
                echo "<div>Trouvé dossier ".$modir."data/".$docs_source.$dossier."</div>";
                $files=glob($modir."data/".$docs_source.$dossier."/*.*");
            } else {
                // tester s'il existe un fichier
                $files=glob($modir."data/".$docs_source.$dossier."/.*");
            } 
            if(count($files) == 0){
                // pas de dossier, on passe
                createitem($num,$row, $files);
                echo "<p class='color-notok my-0'>Pas trouvé de fichier pour ".$modir."data/".$docs_source.$dossier."</p>";
                continue; 
            }

            $listfiles=array();
            foreach($files as $file){
                echo "<p class='color-ok mb-0'>Trouvé ".$file."</p>";
                $listfiles=copyfiles($file,$listfiles);

                $infos=pathinfo($file);
                $ext=strtolower($infos['extension']);
                // check du poids des images
                if(in_array($ext,$ext_image)){ 
                    // si le fichier est trop lourd, envoyer une image warning
                    if(filesize($file) > FILE_MAXSIZE){ 

                        $nom=explode("/data/",$file);

                        echo "<div class='color-notok'>".$nom[1]." : taille supérieure au maximum serveur: ".filesize($file)."</div>";
                        $rapport.=$nom[1]."\n";
                    }
                } else {

                }
            }

            createitem($num,$row, $listfiles);

            echo "</td></tr>";
        }
        echo "</table>";

        echo "<h3 class='mb-1'>Ecriture du rapport</h3>";
        $entete="Liste des fichiers dont la taille dépasse les limites serveur autorisée (".FILE_MAXSIZE.")\n\r";
        $wr=file_put_contents($modir."/rapport.txt", $entete.$rapport);
        if($wr){
            echo "<div class='mb-4'>Rapport écrit</div>";
        }

        ?>
    </div>
</section>
<?php
include(getSnippetFile("code-viewer.php"));
include(getSnippetFile("code-footer.php"));
?>