// script pour la création de player son
// s'attend à une structure comme
// <div class="lecteur"><audio controls><source="monmp3.mp3" type="audio/mp3"></audio></div>
function yc_init_audios(){
    var audios=document.querySelectorAll(".lecteur_audio:not(.init)")
    if(audios.length==0){ return }
    
    var controldiv ="<div class='playpause'><button class='play'></button><button class='pause'></button></div><div class='playtime'><span class='elapsed'>00:00</span> / <span class='total'>00:00</span></div><div class='timeline'><div class='bar-played'></div></div>";

    audios.forEach(function(player){
        var drag=false;
        var add=document.createElement( 'div' );
        add.classList.add("lecteur_son_container")
        add.innerHTML=controldiv;
        player.appendChild(add);

        var son=player.querySelector("audio");
        var bplay=player.querySelector(".play");
        var bpause=player.querySelector(".pause");
        var telapsed=player.querySelector(".elapsed");
        var ttotal=player.querySelector(".total");
        var ttimeline=player.querySelector(".timeline");

        // on cache la barre de controle et le bouton pause
        son.removeAttribute("controls");
        bpause.style.display="none";

        // gestion des bouton play et pause
        bplay.onclick = function(){
            son.play();
            bplay.style.display="none";
            bpause.style.display="block";
        };
        bpause.onclick = function(){
            son.pause();
            bpause.style.display="none";
            bplay.style.display="block";
        };

        // montrer les infos pendant la lecture
        son.addEventListener("timeupdate", function() {
            // ligne du temps
            var pc=(son.currentTime/son.duration)*100;
            ttimeline.querySelector(".bar-played").style.width= pc+"%";
            telapsed.innerHTML=formate_temps(son.currentTime);
        }, false);

        // gestion du clic et drag sur la barre de temps
        ttimeline.onclick = function(e){
            var rect = e.target.getBoundingClientRect();
            var x = e.clientX - rect.left;
            var lt=this.clientWidth;

            son.currentTime=son.duration*(x/lt);
        };
        ttimeline.onmousedown=function() {
            drag=true;
        };
        ttimeline.onmouseup=function(){
            drag=false;
        };
        ttimeline.onmousemove=function(e){
            if(drag){
                var lt=this.clientWidth;
                var rect = e.target.getBoundingClientRect();
                var x = e.clientX - rect.left;
                son.currentTime=son.duration*(x/lt);
            }
        };

        // récupérer les metadatas
        son.addEventListener('loadedmetadata',function(){
            ttotal.innerHTML=formate_temps(son.duration);
        },false);

        // eviter un double init
        player.classList.add("init")
    });
}

function yc_init_videos(){
    var videos=document.querySelectorAll(".lecteur_video:not(.init)");
    if(videos.length==0){ return }
    
    var controldiv ="<div class='timeline'><div class='bar-played'></div></div><div class='playpause'><button class='play'></button><button class='pause'></button></div><div class='playtime'><span class='elapsed'>00:00</span> / <span class='total'>00:00</span></div><div class='fullscreen'><span class='f-enter'></span><span class='f-exit'></span></div>";

    videos.forEach(function(player){
        var drag=false;
        var add=document.createElement( 'div' );
        add.classList.add("lecteur_video_container")
        add.innerHTML=controldiv;
        player.appendChild(add);

        var video=player.querySelector("video");
        var bplay=player.querySelector(".play");
        var bpause=player.querySelector(".pause");
        var telapsed=player.querySelector(".elapsed");
        var ttotal=player.querySelector(".total");
        var ttimeline=player.querySelector(".timeline");
        var fulls=player.querySelector(".f-enter");
        var fullse=player.querySelector(".f-exit");

        // on cache la barre de controle et le bouton pause
        video.removeAttribute("controls");
        bpause.style.display="none";

        // gestion des bouton play et pause
        bplay.onclick = function(){
            video.play();
            bplay.style.display="none";
            bpause.style.display="block";
        };
        bpause.onclick = function(){
            video.pause();
            bpause.style.display="none";
            bplay.style.display="block";
        };

        // play-pause en clic sur la vidéo
        video.onclick=function(){
            if(!video.paused){
                bpause.click()
            } else {
                bplay.click()
            }
        }

        // récupérer les metadatas
        video.addEventListener('loadedmetadata',function(){
            ttotal.innerHTML=formate_temps(video.duration);
        },false);

        // montrer les infos pendant la lecture
        video.addEventListener("timeupdate", function() {
            // ligne du temps
            var pc=(video.currentTime/video.duration)*100;
            ttimeline.querySelector(".bar-played").style.width= pc+"%";
            telapsed.innerHTML=formate_temps(video.currentTime);
        }, false);

        // gestion du clic et drag sur la barre de temps
        ttimeline.onclick = function(e){
            var rect = e.target.getBoundingClientRect();
            var x = e.clientX - rect.left;
            var lt=this.clientWidth;

            video.currentTime=video.duration*(x/lt);
        };
        ttimeline.onmousedown=function() {
            drag=true;
        };
        ttimeline.onmouseup=function(){
            drag=false;
        };
        ttimeline.onmousemove=function(e){
            if(drag){
                var lt=this.clientWidth;
                var rect = e.target.getBoundingClientRect();
                var x = e.clientX - rect.left;
                video.currentTime=video.duration*(x/lt);
            }
        };

        // fullscreen
        fulls.onclick=function(){
            let i=player.id
            yc_openFullscreen(document.querySelector("#"+i))
        }        
        fullse.onclick=function(){
            yc_closeFullscreen()
        }

        // eviter un double init
        player.classList.add("init")
    });
}

// Transformer la durée (en secondes brutes, 221 par ex)
// vers une structure minutes/secondes (3:41 par ex)
function formate_temps(temps){
    s = parseInt(temps % 60);
    m = Math.floor( temps / 60 ) % 60;
    s = s < 10 ? "0"+s : s;
    m = m < 10 ? "0"+m : m;
    return m+":"+s;
}

