<?php  
/*  
Classe de manipulation d'image
reçoit un dossier par défaut des images 
setsource envoie une adresse 


*/
class thumbnail_tool {
    public $im_vd="defaut.png";
    public $im_vdo="defaut-oversize.png";

    public $src_completepath; // depuis la racine du serveur
    public $src_publicpath; // depuis la racine du site
    public $src_w;
    public $src_h;

    public $root;

    public $src_publicfolder=false;
    public $src_serverfolder=false;

    public $vignette_publicfolder=false; // adresse serveur de la vignette
    public $vignette_serverfolder=false; // adresse public de la vignette

    public $maxsize=10000000000; // taille maximale de l'image en octet
    public $vignette_w=10000; // largeur max en pixels
    public $vignette_h=100000; // hauteur max en pixels
    public $vignette_crop=false;

    public $im_info;
    public $extension;
    public $size;

    function __construct($server=__DIR__."/", $im_vi_folder="",$def_folder="" ) {
        ini_set('memory_limit', '256M');
        if(!is_dir($def_folder) ){
            return false;
        }
        $def_folder=str_replace($server,"",$def_folder);
        
        $this->im_vd=$def_folder.$this->im_vd;
        $this->im_vdo=$def_folder.$this->im_vdo;

        // racine du serveur
        $this->root=$server;

        // créer les serverpath et publicpath
        // on assume que le sf et vf sont fournis en public link
        $vf_public=str_replace($server,"",$im_vi_folder);
        $this->vignette_publicfolder=$vf_public;
        $this->vignette_serverfolder=$this->root.$vf_public;
    }

    public function set_source($imbase){
        // si l'image n'existe par, préparer la vignette par défaut
        if($imbase=="" || !file_exists($imbase) ){
            $imbase=$this->im_vd;
        }
        $this->src_completepath=$imbase;
        $this->im_info=pathinfo($imbase);
        $this->extension=$this->im_info['extension'];

        $this->src_publicfolder=$this->im_info['dirname']."/";
        $this->src_serverfolder=$this->root.$this->im_info['dirname']."/";

        // donner déjà une vignette par défaut
        $this->size=filesize($this->src_completepath);
        if($this->size > $this->maxsize){
            $vignette_spath=$this->im_vdo;
        } else {
            $vignette_spath=$this->im_vd;
        }

        list($width, $height, $type, $attr) = getimagesize($this->src_completepath);

        $this->src_w=$width;
        $this->src_h=$height;
    }

    public function vignette($dw=false,$dh=false,$crop=false){
        if(!$dw){ $dw= $this->vignette_w; }
        if(!$dh){ $dw= $this->vignette_h; }
        return $this->get_vignette($dw,$dh,$crop);
    }

    private function get_vignette($dw,$dh,$crop){
        $ext_image=array('jpg','jpeg','png','gif','webp');
        if($this->extension=="svg" || !in_array($this->extension,$ext_image)){ 
            return $vignette_spath; 
        }
        // si l'image est plus petite que la vignette, renvoyer l'original
        if($this->src_w < $dw or $this->src_h < $dh){ 
            return $this->src_completepath."?".filectime($this->src_completepath);
        }

        // c'est parti !
        $suffixe="_".$dw."x".$dh.($crop ? "_crop" : "_nocrop")."_".hash('adler32',filectime($this->src_completepath));
        $vignettefile=$this->im_info['filename'].$suffixe.".".$this->extension;

        // voir si la vignette existe déjà, si oui la renvoyer directement
        if(file_exists($this->vignette_serverfolder.$vignettefile)){
            return $this->vignette_publicfolder.$vignettefile."?".filectime($this->vignette_serverfolder.$vignettefile);
        } 

        switch($this->extension){
            case 'gif': $img = imagecreatefromgif($this->src_completepath); break;
            case 'jpg': $img = imagecreatefromjpeg($this->src_completepath); break;
            case 'png': $img = @imagecreatefrompng($this->src_completepath); break;
            case 'webp': $img = imagecreatefromwebp($this->src_completepath); break;
            default : echo "image does not exists"; return $image_default;
        }
        if($crop){
            $ratio = max($dw/$this->src_w, $dh/$this->src_h);
            $y= ($this->src_h - $dh / $ratio) /2;
            $x = ($this->src_w - $dw / $ratio) / 2;
            $nheight = $dh / $ratio;
            $nwidth = $dw / $ratio;
        } else {
            $ratio = min($dw/$this->src_w, $dh/$this->src_h);
            $dw = $this->src_w * $ratio;
            $dh = $this->src_h * $ratio;
            $x = 0;
            $y = 0;
            $nheight = $this->src_h;
            $nwidth = $this->src_w;
        }

        $vignette = imagecreatetruecolor($dw, $dh);

        // preserve transparency
        if($this->extension == "gif" || $this->extension == "png"){
            imagecolortransparent($vignette, imagecolorallocatealpha($vignette, 0, 0, 0, 127));
            imagealphablending($vignette, false);
            imagesavealpha($vignette, true);
        }

        imagecopyresampled($vignette, $img, 0, 0, $x, $y, $dw, $dh, $nwidth, $nheight);
        //$sharpen = array([-1,-1,-1], [-1, 16, -1], [-1,-1,-1]);
        //imageconvolution($vignette, $sharpen, 8, 0);

        switch($this->extension){
            case 'gif': imagegif($vignette, $this->vignette_serverfolder.$vignettefile); break;
            case 'jpg': imagejpeg($vignette, $this->vignette_serverfolder.$vignettefile); break;
            case 'png': imagepng($vignette, $this->vignette_serverfolder.$vignettefile); break;
            case 'webp': imagewebp($vignette, $this->vignette_serverfolder.$vignettefile); break;
        }
        imagedestroy($vignette);
        imagedestroy($img);

        return $this->vignette_publicfolder.$vignettefile."?".filectime($this->vignette_serverfolder.$vignettefile);

    }

    public function human_size($decimals = 2) {
        $factor = floor((strlen($this->size) - 1) / 3);
        if ($factor > 0) $sz = 'KMGT';
        return sprintf("%.{$decimals}f", $this->size / pow(1024, $factor)) . @$sz[$factor - 1] . 'B';
    }

}