<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include("import_trombinoscope_config.php");
include("docs_functions.php");

$modir=__DIR__;

include(getSnippetFile("code-header.php"));
?>
<header id="main-header" class="p-3">
    <?php
    include(getSnippetFile("code-pageheader-top.php"));
    ?>
    <hr class="hr-light">
</header>

<section id="main-container" class="container px-3 pb-4 ">
    <h2 class="pb-3">Importation des éléments du trombinoscope</h2>
    <div class="pb-3">
        Ce module permet d'importer des photos (jpg, etc.) comme éléments du trombinoscope. Pour ce faire:<br>
        1) placez les documents dans le dossier "uploads".<br>La structure des noms de fichiers sert à nommer automatiquement chaque élément.<br>La structure est prenom_nom.jpg par exemple.<br>
        2) vérifiez la liste des imports en rechargeant cette page.<br>
        Ensuite cliquer sur "Lancer l'importation" si le bouton apparait en bas de cette page.

    </div>
    <div class="d-none">
        <div class="pr-2">Rechercher&nbsp;: </div>
        <input id="live-search" type="text" class="" placeholder="Tapez quelque chose">
    </div>
    <div id="main-grid" class="d-none"></div>

    <div class="">
        <h2 class="mb-2">Import de documents</h2>
        <div class="">
            <div class="mb-3">Vérification des fichiers présents dans le dossier /uploads</div>

            <h3 class="fs-medium mb-1">Fichiers importables</h3>
            <div class="mb-3">
                Fichiers autorisés: <?= getext() ?>
            </div>
            <div class='border-2 border-rounded p-3'>
                <?php
    // reçoit une liste de nom de yaml et renvoie une liste de snippet html
    $uploads=glob(CHEMIN."upload/*.{".getext()."}",GLOB_BRACE);
                $ok=count($uploads);
                if($ok){
                    foreach($uploads as $upload){
                        echo "<div class=''>".basename($upload)."</div>";
                    }
                } else {
                    echo "Pas de fichiers éligibles.";

                }
                ?>
            </div>
            <div class="">
                <?php
                if($ok){
                ?>

                <div class="my-3">
                    <h2 class="mb-2">Réglages d'importation</h2>
                    <div class="">

                        <form action="" method="get" class="fw-form">
                            
                            <input type="hidden" name="template" value="themes/trombinoscope/modules/module_import_trombinoscope/import_trombinoscope_import.php">
                            
                            
                            <div class="fs-medium ff-bold-secondary">Conversion des noms de fichier</div>
                            <fieldset class="my-3">
                                <div>

                                    <input type="radio" name="nommage" value="brut"> <label>Nom de fichier vers <b>nom brut sans extension</b></label>
                                </div>
                                <div>

                                    <input type="radio" name="nommage" value="nom"> <label>Nom de fichier vers <b>nom nettoyé</b></label>
                                </div>
                                <div>

                                    <input type="radio" name="nommage" value="nomprenom" checked> <label>Nom de fichier vers <b>nom et prenom nettoyés</b></label>
                                </div>
                            </fieldset>
                            <fieldset>
                                <button type="submit" class="btn btn-ok">Lancer l'importation</button>
                            </fieldset>
                        </form>
                    </div>
                </div>

                <?php
                }
                ?>
            </div>
        </div>        
    </div>
</section>

<?php

include(getSnippetFile("code-viewer.php"));
include(getSnippetFile("code-footer.php"));