<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include("importconfig.php");
include("docs_functions.php");

$modir=__DIR__;

include(getSnippetFile("code-header.php"));
?>
<header id="main-header" class="p-3">
    <?php
    include(getSnippetFile("code-pageheader-top.php"));
    ?>
</header>
<section id="main-container" class="container px-3 pb-4">
    <h2 class="pb-3">Importation de documents</h2>
    <div class="pb-3">
        Ce module permet d'importer des documents (pdf, mp4, etc.) comme item. Pour ce faire:<br>
        1) placez les documents dans le dossier "uploads"<br>
        2) vérifiez la liste des imports en rechargeant cette page.<br>
        Ensuite cliquer sur "Lancer l'importation" si le bouton apparait en bas de cette page.

    </div>
    <div class="d-none">
        <div class="pr-2">Rechercher&nbsp;: </div>
        <input id="live-search" type="text" class="" placeholder="Tapez quelque chose">
    </div>
    <div id="main-grid" class="d-none"></div>

    <div class="">
        <h2 class="mb-3">Import de document</h2>
        
    <div class="">
        <div class="mb-3">Vérification des fichiers présents dans le dossier /uploads</div>

        <h3 class="fs-medium mb-1">Fichier importables</h3>
        <div class="mb-3">
            Fichiers autorisés: <?= getext() ?>
        </div>
        <div class='border-2 border-rounded p-3'>
            <?php
    // reçoit une liste de nom de yaml et renvoie une liste de snippet html
    $uploads=glob(CHEMIN."upload/*.{".getext()."}",GLOB_BRACE);
            $ok=count($uploads);
            if($ok){
                foreach($uploads as $upload){
                    echo "<div class=''>".basename($upload)."</div>";
                }
            } else {
                echo "Pas de fichiers éligibles.";

            }

            ?>
        </div>
        <div class="">
            <?php
            if($ok){
                echo "<div class='nodecoration mt-3'><a href=\"?template=modules/module_importdocs/importdocs_import.php\" class='btn btn-ok'>Lancer l'importation</a></div>";
            }
            ?>
        </div>


    </div>        
        
     

    </div>
</section>

<?php

include(getSnippetFile("code-viewer.php"));
include(getSnippetFile("code-footer.php"));