<section id="main-grid" class="mosaique-grid">
    <?php
    // Si le cache existe, l'envoyer et c'est fini
    $cachefile = CACHE.'cached-mosaique.html';
    if(file_exists($cachefile)) {
        echo "<!-- Cached copy, generated ".date('H:i', filemtime($cachefile))." -->\n";
        readfile($cachefile);
    } else {
        // vérifier l'existence du cache d'ordre
        $cacheorder = CACHE.'cached-mosaique-order.yaml';
        create_mosaique_order();

        ob_start(); // Start the output buffer
        $order=Spyc::YAMLLoad($cacheorder);
        $item=new yamlReadwriter();
        // trouver le bon snippet
        $snippet_item=getSnippetFile("display_item_mosaique.php");
        $item->loadYaml(getTemplate("structure_item.yaml")); // charger la structure complète

        foreach($order as $num => $item_url){
            $item->cleanContents();
            $item->loadContentFromYaml(CONTENTS."items/".$item_url);            
            include($snippet_item);
        }
        // Cache the contents to a cache file
        $cached = fopen($cachefile, 'w');
        fwrite($cached, ob_get_contents());
        fclose($cached);
        ob_end_flush(); // Send the output to the browser
    }
    ?>
</section>
<footer class="mt-3">
<div class="border-top py-2 fs-small color-light ff-secondary">Nombre d'items: <span id="items_total"></span></div>
</footer>