<?php
// charger le fichier de settings général
$theme=new yamlReadwriter();
$theme->loadYaml(getTemplate("settings_theme.yaml")); // charger la structure complète

$theme->filename="settings_theme.yaml"; 
$theme->setDestinationFolder(CONFIG."settings/");

// charger le contenu de l'item
//$theme->loadContentFromYaml(CONTENTS."items/".$item_url);

$theme->compact_output=0;
$theme->setType("theme"); // important

// récupérer thème et config
$theme_actuel=$theme->get("theme");
$theme_listingoption=$theme->get("listingoption");


/*
sep_mode_visiteur:
  type: separateur
  label: Mode d'accès visiteurs
  value: Mode d'accès visiteurs 
*/

switch($_POST['action']){
    case "loadform":
        $menu_edit= array();
        $theme->form_title="Paramètres du thème";
        $theme->form_comment="Modifiez ici le thème d'affichage pour la mosaïque, l'affichage latéral et en pleine fenêtre.<br>Attention, le thème affecte les champs des formulaires. Choisissez le thème dès l'installation en fonction de l'usage désiré.";
        $theme->form_submit="Modifier";

        $theme->form_comment.="<div class='mt-3'>Thème actuel: ".$theme_actuel." (".$theme_listingoption.")</div>";

        $theme->content['theme']['type']="select";
        $theme->content['listingoption']['type']="hidden";
        
        

        // constituer la liste des thèmes disponibles
        $themelist=array();
        $themes_base=GLOB(THEMES."*",GLOB_ONLYDIR);

        $theme_list=array();

        foreach($themes_base as $tb){
            $theme_info=Spyc::YAMLLoad($tb."/config.yaml");
            $tt=$theme_info['title'];
            $to=$theme_info['options'];
            // ajouter à la liste des thèmes
            $themurl=str_replace(THEMES,"",$tb);
            
            $theme->content['theme']['options'][$themurl]=$tt;

            $theme->contentAddField("options_".basename($tb),array(
                "label"=>"Options de ".$tt,
                "help"=> $theme_info['descr'],
                "type"=>"select",
                "options"=>$to,
                "value"=>$theme_listingoption // meme si ça ne correspond pas
            ));
        }

        //print_r($theme->content);


        $theme->addHidden("action","submitform");
        $theme->addHidden("endaction","yc_reloadpage");         

        include(APP."snippets/menu-viewer.php");
        $theme->setSnippetFolder(APP."form_parts/");
        echo "<div class='generic-viewercontent'>";
        $theme->writeForm();
        
        echo "<script>yc_init_theme_options()</script>";
        echo "</div>";
        break;

    case "submitform":
        // on processe à la main
        $theme_choisi=$_POST['theme'];
        $theme_option=$_POST['options_'.$theme_choisi];
        $_POST['listingoption']=$theme_option;
        $theme->processPost(true);
        // supprimer le cache
        supprimer_cache();
}