<?php
// reçoit une liste de nom de yaml et renvoie une liste de snippet html
$uploads=glob(CHEMIN."upload/*.{gif,png,jpg,webp,svg}",GLOB_BRACE);
switch($_POST['action']){
    case "loadform":
        $menu_edit= array();
        include(APP."snippets/menu-viewer.php");

        $items=new yamlReadwriter();
        // charger la structure complète
        $items->loadYaml(getTemplate("structure_additems.yaml"));
        // charge le snippet/
        $items->setType("items"); // important
        
        
        $items->addHidden("action","submitform");
        $items->addHidden("callback","yc_updategriditems yc_closeViewer");         
        
        $items->setSnippetFolder(APP."form_parts/");

        $items->form_title="Importer des items";
        $items->form_comment="Cette fonction permet d'importer des images depuis le dossier \"uploads\" ou depuis votre ordinateur. Attention, le processus peut produire un timeout en fonction de la taille des images, de leur nombre et de la puissance du serveur.";
        if(count($uploads)==0){
            $items->contentDeleteField("uploads");
        }        
        $items->writeForm();
        break; 

    case "submitform":
        $item=new yamlReadwriter();
        $item->loadYaml(getTemplate("structure_item.yaml"));
        $item->setType("item"); // important
        $item->setDestinationFolder(CONTENTS."items/");

        $titleoption=$_POST['titleoption'];

        $retour=array();

        if(isset($_POST['uploads']) && $_POST['uploads']=="true"){
            foreach($uploads as $upload){
                $fi=pathinfo($upload);
                $ext = strtolower($fi['extension']);
                if (!in_array($ext, array("jpg","png","gif","webp","svg"))) { 
                    unlink($upload); // supprimer
                    continue; 
                }
                $titre=$fi['filename'];
                $filename=stripAccents($fi['basename']);

                if($_POST['titleoption']=="propre"){
                    $titre=human_name($titre);
                }

                if(file_exists(IMPORTS.$filename)){
                    $filename=uniqid()."_".$filename;
                }

                rename($upload,IMPORTS.$filename);
                $item->set("titre",$titre);
                $item->set("illustration",$filename);
                $item->filename=false;
                $item->writeyaml();

                ob_start(); // Start the output buffer
                $snippet=getSnippetFile("display_item_mosaique.php");
                include($snippet);
                $html=ob_get_contents();
                ob_end_clean();

                $retour[] = array(
                    'id' => $item->filename,
                    'html' => $html
                );
            }

        } else {
            $illus=$_POST["illustrations"];
            foreach($illus as $illu){
                $illu=validateTempfile(basename($illu));
                $t=pathinfo($illu);
                $titre=$t['filename'];

                $pattern = '/([0-9]*_)(.*)/i';            
                $replacement = '$2';
                $titre=preg_replace($pattern, $replacement, $titre);

                // $titre=pathinfo($file, PATHINFO_FILENAME);
                if($_POST['titleoption']=="propre"){
                    $titre=human_name($titre);
                } 
                $item->set("titre",$titre);
                $item->set("illustration",$illu);
                $item->filename=false;
                $item->writeyaml();

                ob_start(); // Start the output buffer
                $snippet=getSnippetFile("display_item_mosaique.php");
                include($snippet);
                $html=ob_get_contents();
                ob_end_clean();

                $retour[] = array(
                    'id' => $item->filename,
                    'html' => $html
                );
            }
        }

        echo json_encode($retour, JSON_HEX_QUOT | JSON_HEX_TAG);

        supprimer_cache();
        break;



}