<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

function createcel($content){
    echo "<td>".$content."</td>\n";
}


include(getSnippetFile("code-header.php"));
?>
<header id="main-header" class="p-3">
    <?php
    include(getSnippetFile("page-top-header.php"));
    ?>
</header>
<section id="main-container" class="px-3 pb-4">
    <h2 class="pb-3">Présences aux cours</h2>
    <div class="d-none">
        <div class="pr-2">Rechercher&nbsp;: </div>
        <input id="live-search" type="text" class="" placeholder="Tapez quelque chose">
    </div>
    <?php
    $cells=array(
        "p2209", "p2909", "p0610", "p1310", "p2010", "p2710", "p1011", "p1711", "p2411", "p0112", "p0812", "p1512"
    );
    ?>

    <div id="main-grid"></div>
    <table class="" id="presences">
        <?php
        $cacheorder = CACHE.'cached-mosaique-order.yaml';
        $order=Spyc::YAMLLoad($cacheorder);
        $item=new yamlReadwriter();
        $item->loadYaml(getTemplate("structure_item.yaml"));
        echo "<thead><tr><td class=\"tdnom\" onclick=\"sortTable(0)\">Nom</td><td class=\"tdor\" onclick=\"sortTable(1)\">OR</td>";

        for($i=0; $i<count($cells);$i++){
            createcel($item->getParam($cells[$i],"label"));
        }
        echo "</tr></thead>";
        ?>
        <tbody>
            <?php
            foreach($order as $num => $item_url){
                $item=new yamlReadwriter();
                $item->loadYaml(getTemplate("structure_item.yaml"));
                $item->loadContentFromYaml(CONTENTS."items/".$item_url); 
                echo "<tr>\n";
                echo"<td data-source=\"".$item->filename."\" onclick=\"yc_clicItem(this)\" class='table-nom'>";
                echo $item->get("titre");
                if($item->get("pronom",false)){
                    echo " - ".$item->get("pronom");
                }
                echo "</td>"; 
                createcel($item->get("orientation","0"));

                foreach($cells as $cell){
                    createcel($item->getpropre($cell,"0"));
                }
                echo" </tr>\n";
            }
            ?>
        </tbody>
    </table>
    <script>
function sortTable(n) {
  var table, rows, switching, i, x, y, shouldSwitch, dir, switchcount = 0;
  table = document.getElementById("presences");
  switching = true;
  // Set the sorting direction to ascending:
  dir = "asc";
  /* Make a loop that will continue until
  no switching has been done: */
  while (switching) {
    // Start by saying: no switching is done:
    switching = false;
    rows = table.rows;
    /* Loop through all table rows (except the
    first, which contains table headers): */
    for (i = 1; i < (rows.length - 1); i++) {
      // Start by saying there should be no switching:
      shouldSwitch = false;
      /* Get the two elements you want to compare,
      one from current row and one from the next: */
      x = rows[i].getElementsByTagName("TD")[n];
      y = rows[i + 1].getElementsByTagName("TD")[n];
      /* Check if the two rows should switch place,
      based on the direction, asc or desc: */
      if (dir == "asc") {
        if (x.innerHTML.toLowerCase() > y.innerHTML.toLowerCase()) {
          // If so, mark as a switch and break the loop:
          shouldSwitch = true;
          break;
        }
      } else if (dir == "desc") {
        if (x.innerHTML.toLowerCase() < y.innerHTML.toLowerCase()) {
          // If so, mark as a switch and break the loop:
          shouldSwitch = true;
          break;
        }
      }
    }
    if (shouldSwitch) {
      /* If a switch has been marked, make the switch
      and mark that a switch has been done: */
      rows[i].parentNode.insertBefore(rows[i + 1], rows[i]);
      switching = true;
      // Each time a switch is done, increase this count by 1:
      switchcount ++;
    } else {
      /* If no switching has been done AND the direction is "asc",
      set the direction to "desc" and run the while loop again. */
      if (switchcount == 0 && dir == "asc") {
        dir = "desc";
        switching = true;
      }
    }
  }
}
        sortTable(0)
    </script>

</section>

<?php

include(getSnippetFile("page-viewer.php"));
include(getSnippetFile("code-footer.php"));


?>