<?php
// chargement du dossier custom
// si il n'existe pas, c'est que la première installation n'a pas eu lieu
// donc renommer config-custom en config
if (!is_dir("config")) {
    if (is_dir("config-sample")) {
        rename("config-sample","config");
        // on dirait une première installation, créer le directory "content" au besoin
        if(!is_dir("contenus")){
            mkdir("contenus", 0775, true);
            mkdir("contenus/cache", 0775, true);
            mkdir("contenus/fichiers", 0775, true);
            mkdir("contenus/xmls", 0775, true);
        } 
    } else {
        die("Problème : pas de dossier config-sample ni config. Il doit y avoir un problème");
    }
}
include("config/config.php");
require(APP."inc/inc-functions.php");
require(APP."inc/inc-display-functions.php");
require(APP."inc/classe_xml.php");

// charger la structure pour le menu
$xml=new classe_xml(MODELE);
$structure=$xml->get_contenu();

include(APP."inc/inc-head.php");
?>

<section class="container-fluid mb-3">
    <div id="tools-multi" style="display:none">
        <div class='mb-3  mx-3 pb-2 border-bottom'>
            <div class='mt-1 d-inline-block mr-4 fat' >
                Ajouter des éléments par simple clic
            </div>
            <div class='mt-1 d-inline-block mr-4 pointer' onclick='collection_items_filtre("cochertout")'>
                Tout cocher
            </div>
            <div class='mt-1 d-inline-block mr-4 pointer' onclick='collection_items_filtre("cocherrien")'>
                Tout décocher
            </div>
            <div class='mt-1 d-inline-block mr-4 pointer' onclick='collection_items_filtre("showselect")'>
                Ne montrer que la sélection
            </div>
            <div class='mt-1 d-inline-block mr-4 pointer' onclick='collection_items_filtre("showall")'>
                Montrer tout
            </div>
        </div>

    </div>

    <div data-affichage="mosaique" id="big-container">
        <div class="row mt-2" id="items-container" data-cle="<?php echo $xml->cle; ?>">
            <?php
            // charger le cache s'il existe
            // sinon le fabriquer
            if(file_exists(CHEMIN.DOSSIER_CACHE."cache.html")){
                echo file_get_contents(CHEMIN.DOSSIER_CACHE."cache.html");
            } else {
                $page="";
                // afficher les éléments
                //$xml=new classe_xml(MODELE);
                $liste=glob(CHEMIN.DOSSIER_XML."*.xml",GLOB_BRACE);
                foreach($liste as $item){
                    $xml->lire_xml($item);
                    $page.=display_mosaique_item($xml,true);
                } 
                file_put_contents(CHEMIN.DOSSIER_CACHE."cache.html", $page);
                echo $page;
            }
            ?> 
        </div>

        <div id="side-container">
            <div class='mover'></div> 
            <div class="container-inner"></div>
        </div>
    </div>
</section>
<section id="fullpage-container" class="fullframe">
    <div class="container-inner"></div>
</section>
<section id="gal-container" class="fullframe">
    <div class="container-inner"></div>
</section>

<?php
// insert du pipeline en bottom
if(file_exists(CHEMIN.DOSSIER_CUSTOM."insert-post-mosaique.php")){
    include(CHEMIN.DOSSIER_CUSTOM."insert-post-mosaique.php");
}

include(APP."inc/inc-footer.php");
?>