<?php
session_start();
// infos de base du site
$site=array(
    "titre"=>"Xml collection 2020",
    "descriptif"=>"Un dérivé de XML collection avec une fonction d'import. Comment montrer un grand nombre de documents et les classer de la manière la plus fluide possible ?",
    "keywords"=>"collection, xml, outil, galerie",
    "footer" => "Copyleft XML Collection v3",
);

// accès 
$logins = array(
    "admin"=> array( // the login
        "nom"=>"admin", // the name (! not the login)
        "pwd"=>"admin" // the password
    )
);

// choix du menu du header 
$menu_header = array(
    "Rechercher" => array(
        "display" => true, // affichage ou pas: true ou false
        "id"=>"tool-items-search", // id (nécessaire pour identifier l'élémént en javascript)
        "file"=>"tool_search.php", // fichier à charger depuis l'admin
        "default"=>""
    ),
    "Tri" => array(
        "display" => true, // affichage ou pas
        "id"=>"tool-tri", // id (nécessaire pour identifier l'élémént en javascript)
        "file"=>"tool_tri.php", // fichier à charger depuis l'admin
        "default"=>"id|desc"
    ),
    "Affichage" => array(
        "display" => true,
        "id"=>"tool-items-infos",
        "file"=>"tool_infos.php",
        "default"=>""
    ),
    "Action" => array(
        "display" => true,
        "id"=>"tool-action",
        "file"=>"tool_action.php",
        "default"=>"showlateral"
    ),
    "Collections" => array(
        "display" => true,
        "id"=>"tool-affichage",
        "file"=>"tool_collections.php"
    ),
);

// taille des vignettes
define("ILLU_WIDTH",500);
define("ILLU_HEIGHT",500);
define("IMG_DEFAULT","images/defaut.jpg");

// chemin pour toutes les manipulations de fichier
define("CHEMIN", str_replace(array("/admin","/process","/inc","/app"),"",realpath(''))."/");
@$url_dir = preg_replace('/[^\/]+\.php(\?.*)?$/i', '',($_SERVER['REQUEST_SCHEME'] ? $_SERVER['REQUEST_SCHEME']."://" : "http://"). $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
define("URL",str_replace(array("/config","/process","/inc"),"",$url_dir));

/* constantes utiles */
define("APP",CHEMIN."app/");
define("IMG_DEFAULT",URL."app/images/defaut.jpg");
define("DOSSIER_XML","contenus/xmls/"); // dossier des xml
define("DOSSIER_FICHIERS","contenus/fichiers/"); // dossier des fichiers
define("DOSSIER_VIGNETTES","contenus/cache/vignettes/"); // dossier des vignettes
define("DOSSIER_CACHE","contenus/cache/"); // cache pour vignettes et des items
define("MODELE",CHEMIN."config/structure_xml.xml");
define("DOSSIER_UPLOAD","upload/");
define("DOSSIER_CUSTOM","config/custom/");
define("DOSSIER_COLLECTION","contenus/collections/"); // dossier des xml
define("MODELE_COLLECTION",CHEMIN."config/structure_collection.xml");

// afficher les messages d'erreur ou log obligé
define("DEBUG",false);
?>