<?php
require("../../config/config.php");
require(APP."inc/inc-functions.php");
require(APP."inc/classe_xml.php");
require(APP."inc/inc-display-functions.php");

// import simple depuis une image 

if(isset($_POST['import'])){
    $image=$_POST['import'];
    unset($_POST['import']);

    $xml=new classe_xml(MODELE);
    // traitement de l'import
    $ext = strtolower(pathinfo($image, PATHINFO_EXTENSION));
    $ext_ok=array("gif","png","jpg","jpeg");
    
    if(file_exists($image) && in_array($ext,$ext_ok)){        
        $fileParts = pathinfo(CHEMIN.$image);
        $nom_seul=$xml->stripAccents($fileParts['filename']);
        if(file_exists(CHEMIN.DOSSIER_FICHIERS.$nom_seul.".".$ext)){
            $ad= hash('adler32', date("Y-m-d H:i:s"));
            $nom_seul=$nom_seul."_".$ad; // ce serait mieux entre le nom et l'extension
        }
        if(rename($image, CHEMIN.DOSSIER_FICHIERS.$nom_seul.".".$ext)){
            $xml->set("illustration",$nom_seul.".".$ext);

            $xml->traiter_formulaire();
            if($xml->get('titre',"rien")=="rien"){
                $xml->set('titre',human_name($fileParts['filename']));
            }
            // fabriquer le nom de fichier
            $nom_xml=date("YmdHis")."_".$xml->nettoie_lien($nom_seul)."_".hash('adler32', date("Y-m-d H:i:s").rand(1,99)).".xml";
            $xml->fichier=CHEMIN.DOSSIER_XML.$nom_xml;
            $xml->fichier_seul=$nom_xml;
            $xml->ecrit_xml();
            display_mosaique_item($xml);
        } else { 
            echo 'notok'; 
        }
        //hydratation de l'objet
        // sauvegarde

    }
    supprimer_cache();
    die();
}

?>
<div class="container-buttons"><div class="buttons-left"></div><div class="buttons-right"><div class="button button-close ml-3" onclick="close_viewer()"><span class="titre-tiny">Close</span> <i class="fas fa-chevron-right"></i></div></div></div>
<div class="p-3">
    <h2 class="titre-medium mb-3">Ajouter des items</h2>
    <div class="texte-small">
        Cet outil permet de créer des entrées dans la collection générale à partir d'un ensemble d'image déposées dans le dossier "upload".
    </div> 

    <hr>
    <div class="bg-light" id="import_infos">
        <?php
        $xml=new classe_xml(MODELE);

        $action=array(
            "titre"=>"Informations communes aux items",
            "action"=>"ajouter_item",
            "submit"=>"Ajouter",
            "exclure_champ"=>array("illustration","galerie","fichier"),
            "no_submit"=>true
        );
        echo $xml->deployer_formulaire($action);
        ?>
    </div>
    <hr>
    <h3 class="titre-small">Liste des éléments</h3>
    <div class="texte-tiny">
        Images présentes dans le dossier upload
    </div>
    <div id="import-list" class="my-3 texte-mini">
        <?php
        // afficher les éléments

        $liste=glob(CHEMIN.DOSSIER_UPLOAD."*.{jpg,JPG,gif,png,jpeg}",GLOB_BRACE);
        foreach($liste as $item){
            echo "<div data-source='".$item."' data-import='true' class='p-1 border mb-1' onclick='import_toggle_item(this);'><i class='fas fa-times text-warning px-2' ></i> ".fichier_seul($item)."</div>";
        }
        if(count($liste)==0){
            echo "<div class='text-warning'>pas d'éléments</div>";
        }
        ?>

    </div>

    <div class="btn btn-primary" onclick="import_proceed();">Uploader</div>

</div>