var search_c;  
var type_action, show_type, type_tri;
var is_editing=false;
var multi=false;
var sort;
$.trumbowyg.svgPath = 'css/icons.svg';
// cacher les sous-menus
$("[data-hideonstart='oui']").hide();
$(document).ready(function(){
    /*  - - - - - - - - tools  */
    // elements de menu à montrer ou cacher
    $("a[data-showhide]").click(function(){
        var dest=$(this).attr("data-showhide");
        if($(this).hasClass("actif")){
            $(this).removeClass("actif");
            $("#"+dest).slideUp("fast");
            if(dest=="tool-affichage"){
                collection_close();
            }
        } else {
            $("a[data-showhide]").removeClass("actif");
            $("#toolbar [id^='tool-']").slideUp("fast");

            $(this).addClass("actif");
            $("#"+dest).slideDown("fast");
            if(dest=="tool-affichage"){
                //collection_close();
            }
        }
        return false;
    });
    $('#live-search').keyup(function(){
        filtre_items();
    });

    // - - - - - - - affichage
    // ajouter/retirer data-affichage-texte par exemple 
    // en fonction des critères encodé
    //
    var valeurs=cookie_get("items-infos");
    if(valeurs != undefined){
        $("body").attr("data-items-infos",valeurs);
    } else {
        valeurs=$("body").attr("data-items-infos");
    }
    coche_criteres(valeurs,"#tool-items-infos");
    infos_affiche_items();
    $("#tool-items-infos [data-critere]").click(function(){
        infos_modifier_critere("items-infos");
        infos_affiche_items();
    });

    // - - - - - -zones de recherche
    valeurs=cookie_get("items-search");
    if(valeurs != undefined){
        $("body").attr("data-items-search",valeurs);
    } else {
        valeurs=$("body").attr("data-items-search");
    }
    coche_criteres(valeurs,"#tool-items-search");
    $("#tool-items-search [data-critere]").click(function(){
        infos_modifier_critere("items-search");
        search_c=charge_search_elem();
        filtre_items();
    });
    search_c=charge_search_elem();

    // - - - - - - - tri
    type_tri=$("body").attr("data-type-tri");
    var tri=cookie_get("tool-tri");
    if(tri != undefined){
        $("#tool-tri [data-critere='"+tri+"']").prop('checked',true);
        $("body").attr("data-type-tri",tri);
        type_tri=tri;
    } else {
        $("#tool-tri [data-critere='"+type_tri+"']").prop('checked',true);
    }
    trie_items();
    $("#tool-tri input").click(function(){
        var cle=$("#tool-tri input:checked").attr("data-critere");

        type_tri=cle;
        console.log("cle changée : "+cle);
        Cookies.set("tool-tri", cle);
        $("body").attr("data-type-tri",cle);
        trie_items();
    });
    // - - - - - type d'action en click
    type_action=$("body").attr("data-type-action");
    var action=cookie_get("tool-action");
    if(action != undefined){
        $("body").attr("data-type-action",action);
        $("#tool-action [data-critere='"+action+"']").prop('checked',true);
        type_action=action;
    }
    $("#tool-action input").click(function(){
        type_action=$(this).attr("data-critere");
        $("body").attr("data-type-action", type_action).attr("display-viewer","off");

        Cookies.set("tool-action", type_action);
    });

    init_login();
    init_load_vignettes()
    var n=$("#items-container article").length;
    $("#compteur_elems").html(n);
});

/* gestion du clavier */
$(document).keydown(function(e){
    if(is_editing==false){ // pas de fleches si on edite item ou texte
        if (e.keyCode == 39){
            item_suivant();
        } else if (e.keyCode == 37){ 
            item_precedent();
        } 
    }
    if (e.keyCode == 27){
        // tout cacher
        close_viewer();
    }
});

function init_load_vignettes(){
    setTimeout(function(){
        load_vignettes() 
    }, 500);
}[]

function load_vignettes(){
    console.log('Chargement des vignettes')
    let lv=document.querySelectorAll("#items-container article:not(.loaded)")
    if(lv.length == 0){ return false }
    nb_vignettes=20
    if(lv.length < nb_vignettes){ nb_vignettes=lv.length }
    // charger 20 vignettes
    for(let i=0;i<nb_vignettes;i++){
        let il=lv[i].querySelector(".item-illu")
        il.setAttribute("src",il.getAttribute("data-source"))
        lv[i].classList.add("loaded")
    }
    setTimeout(function(){
        load_vignettes() 
    }, 200);
}


// cocher les criteres par checkbox
function coche_criteres(valeurs,menu){
    $(menu+" [data-critere]").prop('checked',false);
    valeurs=valeurs.split(",");
    valeurs.forEach(function (tag) {
        $(menu+" [data-critere='"+tag+"']").prop('checked',true);
    });
}

// affichage des infos dans la liste d'items
function infos_affiche_items(){
    $(".item [data-contenu], #collections-wrapper").hide();
    var valeur=$("body").attr("data-items-infos");
    valeur=valeur.split(",");
    valeur.forEach(function(tag) {
        switch (tag) {
            case 'show-collections':
                $("#collections-wrapper").show();
                break;
            default:
                $(".item [data-contenu='"+tag+"']").show();
        }
    }); 
}

//infos_modifier_critere($(this),bodydata,cookiedata);
function infos_modifier_critere(menu){
    var valeurs=[];
    $("#tool-"+menu+" [data-critere]").each(function(){
        if($(this).is(":checked")){
            valeurs.push($(this).attr("data-critere"));
        }
    });
    valeurs=valeurs.join(",");
    $("body").attr("data-"+menu,valeurs); 
    Cookies.set(menu, valeurs);
}

function trie_items(){
    sortliste=[];

    var cletri=$("body").attr("data-type-tri")
    // traiter pour séparer le champ et le sens
    var criteres = cletri.split('|')
    var champ=criteres[0]
    var sens=criteres[1]

    let itemslist=document.querySelectorAll("#items-container .item")
    itemslist.forEach(function(it){
        var i=it.getAttribute("data-xml")
        var t
        if(champ=="id"){
            t=i; // tri sur l'id
        } else {
            var selectchamp=it.querySelector("[data-contenu='"+champ+"']")
            if(selectchamp.hasAttribute("data-rawvalue")){
                t=selectchamp.getAttribute("data-rawvalue")
            } else {
                t=selectchamp.innerHTML.toLowerCase()
            }
        }
        sortliste.push({id: i, valeur: t})
    })

    if(sens=="asc"){
        sortliste.sort(function(a,b) {
            if(a.valeur.toLowerCase() > b.valeur.toLowerCase()){
                return 1
            } else if(b.valeur.toLowerCase() > a.valeur.toLowerCase()){
                return -1
            } else {
                return 0
            }
        });
    } else {
        sortliste.sort(function(a,b) {
            if(a.valeur.toLowerCase() < b.valeur.toLowerCase()){
                return 1
            } else if(b.valeur.toLowerCase() < a.valeur.toLowerCase()){
                return -1
            } else {
                return 0
            }
        }); 
    }

    // replacer les éléments dans l'ordre demandé
    let ci=document.querySelector("#items-container")
    sortliste.forEach(function(item){
        ci.append(ci.querySelector(".item[data-xml='"+item.id+"']"))
    })
    console.log("tri "+cletri+" terminé")
}

function item_click(elem){
    if(multi){
        var item=$(elem).closest( ".item" ).toggleClass("selected");
    } else {
        $("#items-container .item.actuel").removeClass("actuel");
        var item=$(elem).closest( ".item" ).addClass("actuel");
        item_show(item);
    }
}

function item_suivant(){
    var i=$("#items-container .item.actuel").eq(0);
    if(i.length==0){
        i=$("#items-container .item:visible").eq(0);
        i.addClass("actuel");
    }
    var n=$(i).nextAll(".item:visible:first");
    if(n.length>0){
        $(n).addClass("actuel");
        $(i).removeClass("actuel");
    } else {
        //alert("rien apres");
    }
    if($("body").attr("display-viewer")=="on"){
        item_show();
    }
}

function item_precedent(){
    var i=$("#items-container .item.actuel").eq(0);
    if(i.length==0){
        i=$("#items-container .item:visible:last");
        i.addClass("actuel");
    }
    var p=$(i).prevAll(".item:visible:first");
    if(p.length>0){
        $(i).removeClass("actuel");
        $(p).addClass("actuel");
    } else {
        //alert("rien avant");
    }
    if($("body").attr("display-viewer")=="on"){
        item_show();
    }
}

// affichage de l'élément si un des systeme d'info est ouvet 
function item_show(){
    var actuel=$("#items-container .item.actuel");
    var xml=actuel.attr("data-xml");

    rewrite("?item="+xml); // réécrire l'url

    switch(type_action) {
        case "showgal":
            //display_showgal(item);
            data={ "xml": xml, "display": "item-galerie" };
            fill_viewer(data,"app/inc/inc-ajax-display.php","gal-container","full");
            break;
        case "showlateral":
            data={ "xml": xml, "display": "item-lateral" };
            fill_viewer(data,"app/inc/inc-ajax-display.php","side-container","full");
            break;
        case "showfullpage":
            data={ "xml": xml, "display": "item-fullpage" };
            fill_viewer(data,"app/inc/inc-ajax-display.php","fullpage-container","full");
            break; 
        case "showslidepage":
            data={ "xml": xml, "display": "item-lateral" };
            fill_viewer(data,"app/inc/inc-ajax-display.php","item-container","full");
            break;
        default:
            // code block
            alert("erreur de destination du viewer");
    } 
}

function cookie_get(nom, defaut){
    if(Cookies.get(nom)!=undefined){
        return Cookies.get(nom);
    } else {
        return defaut;
    } 
}

function filtre_items(){
    var val = $('#live-search').val().toLowerCase();
    if(val.length > 1){
        $(".item").each(function(){
            var elem=$(this);
            var text="";
            search_c.forEach(function(item){
                //item=item.replace("s-", "");
                text+=elem.find("[data-contenu='"+item+"']").text().toLowerCase();
                text+=" ";
            });
            if(text.indexOf(val) != -1) {
                elem.fadeIn();
            } else {
                elem.fadeOut();
            }
        }); 
    } else {
        $(".item").fadeIn();
    }
} 


/* gestion des collections */

function collection_click(elem){
    var xml=$(elem).attr("data-xml");
    rewrite("?collection="+xml); // réécrire l'url
    data={"display":"collection", "collection":xml};
    fill_viewer(data,"app/inc/inc-ajax-display.php","collection-display","only-close",function(){ init_ajax_show_collection("") });
}

function collection_edit(item){
    if(item){
        data={ xml: item };  
    } else {
        data={ };
        // le viewer n'est potentiellement pas ouvert, le faire
    }
    fill_viewer(data,"app/inc/inc-ajax-form-collection.php","collection-display","only-close",function(){ init_ajax_submit_collection(item) }); 
    rewrite("");
    return false;
}

function init_multi_select(){
    // init du select et drag
    multi=true;
    $("#items-container").addClass("multi-select"); 
    $("#tools-multi").slideDown(200);

    var grille = document.getElementById('items-container');
    sort = new Sortable(grille, {
        draggable: ".item",
        ghostClass: "item-ghost",
        animation: 150
    }); 
}

function destroy_multi_select(){
    // destruction du select et drag
    if($("#items-container").hasClass("multi-select")){
        multi=false;
        $("#items-container").removeClass("multi-select");
        $("#items-container .item.actuel").removeClass("actuel");
        sort.destroy(); // supprimer la fonction de réorganisation
        $("#tools-multi").slideUp(200);
    }
}

function init_ajax_submit_collection(item){
    collection_container_show();

    $(".fieldset-items").hide();
    $("#items-container").removeClass("show-collection");
    if(item){ 
        var url_collection="?xml="+item; 
    } else { 
        var url_collection=""; 
    }
    $("#items-container .item.selected").removeClass("selected");

    // selectionner les items
    $("#form-collection input[name^='items']").each(function(){
        var xml=$(this).val();
        $("#items-container .item[data-xml='"+xml+"']").addClass("selected");
        $(this).parent().remove();
    });

    init_multi_select();

    $("#collection-display form").on('submit',(function(e) {
        e.preventDefault();
        // recupérer la liste des items clickés
        var formData = new FormData(this);

        if($("#items-container .selected").length == 0){
            alert("Vous devez ajouter au moins un élément à votre collection !");
            return false;
        }

        $("#items-container .selected").each(function(){
            formData.append('items[]', $(this).attr("data-xml"));
        });
        // preparer le submit
        $.ajax({
            url: "app/inc/inc-ajax-form-collection.php"+url_collection,
            type: "POST",
            data:  formData,
            contentType: false,
            cache: false,
            processData:false,
            beforeSend : function(){
                $("#side-container form").addClass("wait-submit");
            },
            success: function(data){
                // ici, on injecte la nouvelle collection ou update l'existant
                if(data =="delete"){
                    $("#collections-container [data-xml='"+item+"']").remove();
                    // supprimer l'element
                } else {
                    if(item){
                        $("#collections-container [data-xml='"+item+"']").replaceWith(data);
                    } else {
                        $("#collections-container").append(data);
                    }

                    //infos_affiche_items();
                    is_editing=false;
                    destroy_multi_select();
                    collection_close();
                }
            },
            complete: function(){
                close_viewer();
                is_editing=false;
            },
            error: function(e) {
                alert("Une erreur de traitement ");
                $("#side-container form").removeClass("wait-submit");
            }          
        });
    }));
}

function init_ajax_show_collection(){
    collection_container_show();

    // disposer les éléments dans l'ordre de la liste
    sortliste=[];
    $("#collection-items .collection-item").each(function(){
        var i=$(this).html();
        sortliste.push({id: i});
    });
    sortliste.reverse();
    sortliste.forEach(function(item){
        // donner la css à chaque element
        $("#items-container .item[data-xml='"+item.id+"']").addClass("selected").prependTo("#items-container"); 
    });
}
function collection_container_show(){
    if(!$("[data-showhide='tool-affichage']").hasClass("actif")){
        $("[data-showhide='tool-affichage']").click();
    } 

    $("#items-container").addClass("show-collection");
    $("#collections-container").hide();
    $("#collection-display").show();

}
function collection_close(){
    $("#collection-display").slideUp("fast",function(){
        $("#collection-display .container-inner").empty();
    });
    $("#collections-container").slideDown("fast");
    $("#items-container").removeClass("show-collection");
    $("#items-container .item").show().removeClass("selected");
    trie_items();
}

function collection_items_filtre(filtre){
    switch (filtre) { 
        case 'cochertout':
            $("#items-container .item").show();
            $("#items-container .item").addClass("selected");
            break;
        case 'cocherrien':
            $("#items-container .item").show();
            $("#items-container .item").removeClass("selected");
            break;
        case 'showselect':
            $("#items-container .item").not(".selected").hide();
            break;
        case 'showall':
            $("#items-container .item").show();
            break;
    }
}

/* Gestion des containers          - - - -            */
function close_viewer(){
    $("body").attr("display-viewer","off");
    $(".container-inner").empty();
    document.exitFullscreen();
    destroy_multi_select();
    is_editing=false;
}

// passer d'un système à l'autre
function change_display(nouveau){
    type_action=nouveau;
    var ac=$("#items-container .item.actuel").attr("data-xml");
    item_show();
}

function charge_search_elem(){
    var c=[];
    $("#tool-items-search [data-critere]:checked").each(function(){
        c.push($(this).attr("data-critere"));
    });
    return c;
}

function item_ajouter(){
    is_editing=true;
    var url="app/inc/inc-ajax-form.php?";
    $.ajax({
        type: "POST",
        url: url,
        success: function(msg){
            $("#side-container .container-inner").html(msg);
        },
        complete: function(){
            $("body").attr("display-viewer","on").attr("display-container","side-container");
            init_ajax_submit_item("");
        },
        error: function(e) {
            alert("Une erreur de chargement. Désolé.");
        }
    });
    return false;
}

function item_edit(item){
    is_editing=true;
    var url="app/inc/inc-ajax-form.php";
    $.ajax({
        type: "GET",
        url: url,
        data: {xml: item},
        success: function(msg){
            $("#side-container .container-inner").html(msg);
        },
        complete: function(){
            $("body").attr("display-viewer","on").attr("display-container","side-container");
            $("#side-container").attr("data-nav","only-close");
            init_ajax_submit_item(item);
        },
        error: function(e) {
            alert("Une erreur de chargement. Désolé.");
        }
    });
}

function modifier_items(){
    is_editing=true;
    data={ "edit_items": "edit" };
    fill_viewer(data,'app/inc/inc-ajax-edit-items.php','side-container','only-close',function(){ init_ajax_modifier_items(); });
    rewrite("");
    return false;
}
function supprimer_items(){
    data={ "supprimer_items": "supprimer" };
    fill_viewer(data,'app/inc/inc-ajax-edit-items.php','side-container','only-close',function(){ init_ajax_supprimer_items(); });
    rewrite("");
    return false;
}

function init_ajax_supprimer_items(){
    // init du multi
    init_multi_select();

    $("form#form-item").on('submit',(function(e) {
        e.preventDefault();
        // recupérer la liste des items clickés
        var formData = new FormData(this);

        if($("#items-container .selected").length == 0){
            alert("Vous devez ajouter au moins un élément à votre collection !");
            return false;
        }

        $("#items-container .selected").each(function(){
            formData.append('items[]', $(this).attr("data-xml"));
        });
        formData.append('action','supprimer');
        // preparer le submit
        $.ajax({
            url: "app/inc/inc-ajax-edit-items.php",
            type: "POST",
            data:  formData,
            contentType: false,
            cache: false,
            processData:false,
            beforeSend : function(){
                $("#side-container form").addClass("wait-submit");
            },
            success: function(data){
                //alert(data);
                // ici, on passe en revue les items sélectionnés
                // et on les supprimer tous !
                var r = JSON.parse(data);
                Object.keys(r).forEach(function(item){
                    $("#items-container [data-xml='"+item+"']").remove();
                });

                is_editing=false;
                destroy_multi_select();
                collection_close();
            },
            complete: function(){
                close_viewer();
                is_editing=false;
                load_vignettes()
            },
            error: function(e) {
                alert("Une erreur de traitement ");
                $("#side-container form").removeClass("wait-submit");
                //$("#err").html(e).fadeIn();
            }          
        });
    }));
}

function init_ajax_modifier_items(){
    // init du multi
    init_multi_select();

    $("#side-container form").on('submit',(function(e) {
        e.preventDefault();
        // recupérer la liste des items clickés
        var formData = new FormData(this);

        if($("#items-container .selected").length == 0){
            alert("Vous devez ajouter au moins un élément à votre collection !");
            return false;
        }

        $("#items-container .selected").each(function(){
            formData.append('items[]', $(this).attr("data-xml"));
        });
        formData.append('action','editer');

        // preparer le submit
        $.ajax({
            url: "app/inc/inc-ajax-edit-items.php",
            type: "POST",
            data:  formData,
            contentType: false,
            cache: false,
            processData:false,
            beforeSend : function(){
                $("#side-container form").addClass("wait-submit");
            },
            success: function(data){
                // ici, on passe en revue les items sélectionnés
                // et on les updates tous !
                var r = JSON.parse(data);
                Object.keys(r).forEach(function(item){
                    $("#items-container [data-xml='"+item+"']").replaceWith(r[item]);
                });
                is_editing=false;
                destroy_multi_select();
                collection_close();
            },
            complete: function(){
                close_viewer();
                is_editing=false;
                load_vignettes();
            },
            error: function(e) {
                alert("Une erreur de traitement ");
                $("#side-container form").removeClass("wait-submit");
            }          
        });
    }));
}

function init_ajax_submit_item(item){
    $('textarea').trumbowyg({
        lang: 'fr',
        btns: [
            ['viewHTML'],
            ['undo', 'redo'], // Only supported in Blink browsers
            ['formatting'],
            ['strong', 'em'],
            ['link'],
            ['justifyLeft', 'justifyCenter'],
            ['removeformat']
        ] 
    });

    if(item){ 
        var url_item="?xml="+item; 
    } else { 
        var url_item=""; 
    }
    $("#side-container form").on('submit',(function(e) {
        e.preventDefault();
        $.ajax({
            url: "app/inc/inc-ajax-form.php"+url_item,
            type: "POST",
            data:  new FormData(this),
            contentType: false,
            cache: false,
            processData:false,
            beforeSend : function(){
                $("#side-container form").addClass("wait-submit");
            },
            success: function(data){
                // ici, on injecte le nouveau item ou update l'existant
                if(data =="delete"){
                    $("#items-container [data-xml='"+item+"']").remove();
                    // supprimer l'element
                } else {
                    if(item){
                        $("#items-container [data-xml='"+item+"']").replaceWith(data);
                    } else {
                        $("#items-container").append(data);
                    }
                    infos_affiche_items();
                    is_editing=false;
                }
            },
            complete: function(){
                close_viewer();
                is_editing=false;
                load_vignettes();
            },
            error: function(e) {
                alert("Une erreur de traitement ");
                $("#side-container form").removeClass("wait-submit");
                //$("#err").html(e).fadeIn();
            }          
        });
    }));
} 

function show_next(elem){
    $(elem).next().fadeIn('fast');
    return false;
}

// procédure générique d'affichage dans les contenueurs
// exemple: fill_viewer("truc.xml","inc-ajax-display.php","#galerie-container","full");
// parametres: xml, page appelée, element vers lequel envoyer, boutons à aficher (full ou only-close)
function fill_viewer(data,url,destination,nav,callbackfunction){
    $.ajax({
        url: url,
        method: "GET",
        data: data,
        beforeSend : function(){
            $("#"+destination).addClass("wait");
            $("body").attr("display-viewer","on").attr("display-container",destination);
        },
        success: function(data){
            $("#"+destination+" .container-inner").html(data); 
            $("#"+destination).attr("data-nav",nav);
            if(callbackfunction){
                callbackfunction();
            }
        },
        complete: function(){
            $("#"+destination).removeClass("wait");
            $('textarea').trumbowyg({
                lang: 'fr',
                btns: [
                    ['viewHTML'],
                    ['undo', 'redo'], // Only supported in Blink browsers
                    ['formatting'],
                    ['strong', 'em'],
                    ['link'],
                    ['justifyLeft', 'justifyCenter'],
                    ['removeformat']
                ]
            }); 
        },
        error: function(e) {
            alert("Une erreur de traitement. Désolé.");
        }          
    });
}


// init_fullpage : un click sur l'image princpale replace celle-ci par les images de la galerie
function init_fullpage(){
    var nb_im=$("#fullpage-container img").length;
    if(nb_im > 1){
        $(".viewer-main-illu").css("cursor","pointer").attr("data-compteur",0).click(function(){
            var ca=$(".viewer-main-illu").attr("data-compteur");
            ca++;
            var src=$("#fullpage-container [data-original]").eq(ca).attr("data-original");
            if(src==undefined){
                src=$("#fullpage-container [data-original]").eq(0).attr("data-original");
                ca=0;
            }
            $(".viewer-main-illu").attr("src",src);
            $(".viewer-main-illu").attr("data-compteur",ca);
        });
    }
}

function show_page(page){
    data={ "page": page, "display": "item-page" };
    fill_viewer(data,"app/inc/inc-ajax-display.php","side-container","only-close"); 
    rewrite("?page="+page);
    return false;
}
function ajouter_page(){
    is_editing=true;
    data={ "page": "new" };
    fill_viewer(data,'app/inc/inc-ajax-edit-pages.php','side-container','only-close');
    return false;
}
function edit_page(page){
    is_editing=true;
    data={ "page": page };
    fill_viewer(data,'app/inc/inc-ajax-edit-pages.php','side-container','only-close');
    is_editing=true;
    return false;
}

function init_ajax_submit_page(page){
    $("#side-container form").on('submit',(function(e) {
        e.preventDefault();
        $.ajax({
            url: "app/inc/inc-ajax-edit-pages.php?page_edit="+page,
            type: "POST",
            data:  new FormData(this),
            contentType: false,
            cache: false,
            processData:false,
            beforeSend:function(){
                $("#side-container form").addClass("wait-submit");
            },
            success: function(retour){
                // ici, on injecte le nouveau item ou update l'existant
                // recharger la page
                if(retour=="delete"){
                    //close_viewer(); 
                    // on doit recharger la page
                    document.location.reload(true);
                } else {
                    $("#side-container .container-inner").html(retour);
                    $("#side-container").attr("data-nav","only-close");
                }
            },
            complete: function(){
                //close_viewer(); 
            },
            error: function(e) {
                alert("Une erreur de traitement ");
                $("#side-container form").removeClass("wait-submit");
                //$("#err").html(e).fadeIn();
            }          
        });
    }));
} 

function ajouter_zip(){
    is_editing=true;
    fill_viewer("truc.xml","app/inc/inc-add-zip.php","side-container","only-close");
    setTimeout(function(){ init_form_zip(); }, 2000);
}

function init_form_zip(){
    $('#form-zip').on('submit', function(e) {
        e.preventDefault(); // J'empêche le comportement par défaut du navigateur, c-à-d de soumettre le formulaire
        var $this = $(this); // L'objet jQuery du formulaire
        var form = $('#form-zip')[0];

        // Create an FormData object 
        var data = new FormData(form);
        data.append("submit-zip", "oui");
        // Envoi de la requête HTTP en mode asynchrone
        $.ajax({
            url: "app/inc/inc-add-zip.php",
            type: "POST",
            enctype: 'multipart/form-data',
            data: data,
            processData: false,
            contentType: false,
            cache: false,
            timeout: 600000,
            beforeSend: function(){
                $("#side-container form").addClass("wait-submit");
                console.log("demarre dezip");
            },
            success: function(data){
                $("#side-container .container-inner").html(data);
                is_editing=true;
                // lancer le formulaire d'import
                fill_viewer("truc.xml","app/inc/inc-add-items.php","side-container","only-close");
                console.log("dezip terminé, envoie vers add items");
                console.log(data);
            }, 
            complete: function(){
                $("#side-container form").removeClass("wait-submit");
            },
            error: function(e) {
                $("#side-container form").removeClass("wait-submit");
                alert("Une erreur de traitement ");
            }          
        });
    });
}

function ajouter_items(){
    is_editing=true;
    fill_viewer("truc.xml","app/inc/inc-add-items.php","side-container","only-close");
}

function import_toggle_item(elem){
    if($(elem).attr("data-import")=="true"){
        $(elem).attr("data-import","false");
    } else {
        $(elem).attr("data-import","true");
    }
}

function import_proceed(){
    var elem=$("#import-list [data-import='true']:first");

    if(elem.length > 0){
        var lien=elem.attr("data-source");
        var params = $("#import_infos form").serialize()+"&import="+lien;

        $.ajax({
            url: "app/inc/inc-add-items.php",
            type: "post",
            data: params,
            //data: data + '&import=' + lien ,
            //data: { "import": lien },
            success: function(retour){
                // reçoit le bloc
                $("#items-container").append(retour);
                //alert(retour);
            },
            complete: function(){
                $(elem).remove();
            },
            error: function(e) {
                alert("Une erreur de traitement ");
                //$("#err").html(e).fadeIn();
            }          
        });
        window.setTimeout("import_proceed()",500);
    }  
}

function init_login(){
    $('.form-login').on('submit', function(e) {
        e.preventDefault(); // J'empêche le comportement par défaut du navigateur, c-à-d de soumettre le formulaire
        var $this = $(this); // L'objet jQuery du formulaire

        // Envoi de la requête HTTP en mode asynchrone
        $.ajax({
            url: "app/inc/inc-ajax-login.php",
            type: "post",
            data: $this.serialize(),
            success: function(data){
                //alert(data);
                $("#admin-menu").html(data);
                init_login();
            },
            error: function(e) {
                alert("Une erreur de traitement "+e);
                //$("#err").html(e).fadeIn();
            }          
        });
    });
}

function logout(){
    $.ajax({
        url: "app/inc/inc-ajax-login.php",
        type: "post",
        data: {logout: "logout"},
        success: function(data){
            //alert(data);
            $("#admin-menu").html(data);
            init_login();
        },
        error: function(e) {
            alert("Une erreur de traitement "+e);
            //$("#err").html(e).fadeIn();
        }          
    });
}

function vider_cache(lequel){
    $.ajax({
        url: "inc/inc-ajax-display.php",
        type: "get",
        data: {vider_cache: lequel},
        success: function(data){
            alert("cache image "+lequel+" - rechargez");
        },
        error: function(e) {
            alert("Cache non vidé - erreur "+e);
            //$("#err").html(e).fadeIn();
        }          
    });
}

function visible_check(elem){
    $(elem).toggleClass('check');
}

function form_input_duplicate(elem){
    var lequel=$(elem).attr("data-duplicate");
    var part_form=$( "[data-form-base='"+lequel+"']" ).eq(0).clone();
    part_form.children("input").val("");
    $("[data-form-dest='"+lequel+"']").append(part_form);
}

function viewer_show_image(elem){
    var image=$(elem).attr("data-original");
    $(".viewer-main-illu:visible").attr("src",image);
    $(".viewer-main-illu:visible").next(".button-back").show();
}

function viewer_back_image(){
    var image=$(".viewer-main-illu:visible").attr("data-original");
    $(".viewer-main-illu:visible").attr("src",image);
    $(".viewer-main-illu:visible").next(".button-back").hide();
}

function image_rotate(image_url,angle,item_url){
    $.ajax({
        method: "POST",
        url: "inc/inc-ajax-display.php",
        data: { url: image_url, angle: angle, rotation_image: 1 },
        beforeSend: function() {
        },
        success: function( msg ) {
            // recharger l'image latérale et l'item de mosaique
            $("#side-container [data-original='"+image_url+"'],[data-xml='"+item_url+"'] img").each(function(){
                var str=$(this).attr('src');
                var res = str.split("?"); 
                $(this).attr('src',res[0]+"?"+msg);
            });
        },
        error: function(){
            alert("Une erreur s'est produite");
        }
    });
}

function reload_image(){

}

function rewrite(adresse){
    var stateObj = {}; 
    var res = adresse.split("?");
    if(res[1]){
        var adresse_checked="?"+res[1];
        history.replaceState(stateObj, "page", adresse_checked);
    }
}

function openFullscreen() {
    var elem = $("#fullpage-container").get(0);
    if (elem.requestFullscreen) {
        elem.requestFullscreen();
    } else if (elem.mozRequestFullScreen) { /* Firefox */
        elem.mozRequestFullScreen();
    } else if (elem.webkitRequestFullscreen) { /* Chrome, Safari & Opera */
        elem.webkitRequestFullscreen();
    } else if (elem.msRequestFullscreen) { /* IE/Edge */
        elem.msRequestFullscreen();
    }
}