<?php

function supprimer_cache(){
    @unlink(CHEMIN.DOSSIER_CACHE."cache.html"); 
}

function supprimer_cache_images(){
    $images=glob(CHEMIN.DOSSIER_VIGNETTES."*.{gif,png,jpg,webp}",GLOB_BRACE);
    foreach($images as $image){
        @unlink($image); 
    }
    // vider le cache pour permettre la recréation des vignettes
    @unlink(CHEMIN.DOSSIER_CACHE."cache.html"); 
}

// donne lien : reçoit une adresse de fichier et une taille, verifie si une vignette a cette taille existe et produit une version de cette image le cas échaant renvoie cette adresse
function donne_lien($file,$l_vignette=600,$h_vignette=600,$crop=true){
    // creer le dossier pour les images petites
    fix_exists_dir(CHEMIN.DOSSIER_VIGNETTES);
    if(!is_file(CHEMIN.$file)){ 
        $file=IMG_DEFAULT; 
    }

    $ext_image=array('jpg','png','gif','webp');

    $fi=pathinfo($file);
    $ext=strtolower($fi['extension']);
    $nom=$fi['filename'];

    $add="_".$l_vignette."x".$h_vignette.($crop ? "_crop" : "_nocrop");
    $local_name=DOSSIER_VIGNETTES.$nom.$add.".".$ext;

    // - - - image : traitement des icones
    if(in_array($ext,$ext_image)){
        // charger l'image brute
        // vérifier que l'image existe
        // sinon la créer
        if (!file_exists(CHEMIN.$local_name)) {
            if(image_resize(CHEMIN.$file, CHEMIN.$local_name, $l_vignette, $h_vignette, $crop)){
                return $local_name."?".filectime(CHEMIN.$local_name);
            } else {
                return $file."?".filectime(CHEMIN.$file);
            }
        } else {
            return $local_name."?".filectime(CHEMIN.$local_name);   
        }
    } else {
        return "img-default/error.jpg";   
    }
    // - - - - fin traitement des images   
}

function image_resize($src, $dst, $width=500, $height=400, $crop=0){
    ini_set('memory_limit', '256M');
    if(!list($w, $h) = getimagesize($src)) {
        echo "image does not exists";
        return false;
    }

    $type = strtolower(substr(strrchr($src,"."),1));
    if($type == 'jpeg') $type = 'jpg';
    switch($type){
        case 'gif': $img = imagecreatefromgif($src); break;
        case 'jpg': $img = imagecreatefromjpeg($src); break;
        case 'png': $img = imagecreatefrompng($src); break;
        case 'webp': $img = imagecreatefromwebp($src); break;
        default : echo "image does not exists"; return false;
    }

    // resize
    if($crop){
        if($w < $width or $h < $height){ 
            return false;
        };
        $ratio = max($width/$w, $height/$h);
        $y= ($h - $height / $ratio) /2;
        $x = ($w - $width / $ratio) / 2;
        $h = $height / $ratio;
        $w = $width / $ratio;
    }
    else{
        if($w < $width and $h < $height) {
            return false;
        }
        $ratio = min($width/$w, $height/$h);
        $width = $w * $ratio;
        $height = $h * $ratio;
        $x = 0;
        $y = 0;
    }

    $new = imagecreatetruecolor($width, $height);

    // preserve transparency
    if($type == "gif" or $type == "png"){
        imagecolortransparent($new, imagecolorallocatealpha($new, 0, 0, 0, 127));
        imagealphablending($new, false);
        imagesavealpha($new, true);
    }
    imagecopyresampled($new, $img, 0, 0, $x, $y, $width, $height, $w, $h);
    $sharpen = array([-1,-1,-1], [-1, 16, -1], [-1,-1,-1]);
    imageconvolution($new, $sharpen, 8, 0);
    switch($type){
        case 'gif': imagegif($new, $dst); break;
        case 'jpg': imagejpeg($new, $dst); break;
        case 'png': imagepng($new, $dst); break;
        case 'webp': imagewebp($new, $dst); break;
    }
    return true;
}

function traiter_rotation_image($filename, $degrees){
    supprimer_cache();
    $rotang = $degrees;

    // traiter les versions de cette images dans les vignettes !
    $fi=pathinfo($filename);
    $nom_seul=$fi['filename'];

    //$filename=CHEMIN.DOSSIER_FICHIERS.$filename; // au même endroit

    $liste=glob(CHEMIN.DOSSIER_VIGNETTES.$nom_seul."*");
    $liste[]=CHEMIN.DOSSIER_FICHIERS.$filename; // au même endroit

    foreach ($liste as $filename){
        //unlink($version);
        list($width, $height, $type, $attr) = getimagesize($filename);
        $size = getimagesize($filename);

        switch($size['mime']){
            case 'image/webp':
                $source =imagecreatefromwebp($filename);
                $bgColor=imageColorAllocateAlpha($source, 0, 0,0, 0);
                $rotation = imagerotate($source,$rotang,$bgColor);
                imagealphablending($rotation, false);
                imagesavealpha($rotation, true);
                imagecreate($width,$height);
                imagewebp($rotation,$filename);
                chmod($filename, 0777);
                break;
            case 'image/jpeg':
                $source =imagecreatefromjpeg($filename);
                $bgColor=imageColorAllocateAlpha($source, 0, 0,0, 0);
                $rotation = imagerotate($source,$rotang,$bgColor);
                imagealphablending($rotation, false);
                imagesavealpha($rotation, true);
                imagecreate($width,$height);
                imagejpeg($rotation,$filename);
                chmod($filename, 0777);
                break;
            case 'image/png':

                $source =imagecreatefrompng($filename);
                $bgColor=imageColorAllocateAlpha($source, 0, 0,0, 0);
                $rotation = imagerotate($source,$rotang,$bgColor);
                imagealphablending($rotation, false);
                imagesavealpha($rotation, true);
                imagecreate($width,$height);
                imagepng($rotation,$filename);
                chmod($filename, 0777);
                break;
            case 'image/gif':

                $source =imagecreatefromgif($filename);
                $bgColor=imageColorAllocateAlpha($source, 0, 0,0, 0);
                $rotation = imagerotate($source,$rotang,$bgColor);
                imagealphablending($rotation, false);
                imagesavealpha($rotation, true);
                imagecreate($width,$height);
                imagegif($rotation,$filename);
                chmod($filename, 0777);
                break;
            case 'image/vnd.wap.wbmp':
                $source =imagecreatefromwbmp($filename);
                $bgColor=imageColorAllocateAlpha($source, 0, 0,0, 0);
                $rotation = imagerotate($source,$rotang,$bgColor);
                imagealphablending($rotation, false);
                imagesavealpha($rotation, true);
                imagecreate($width,$height);
                imagewbmp($rotation,$filename);
                chmod($filename, 0777);
                break;
        }
    }
}

// Vérifie l'existence d'un doccier, le Crée au besoin
function fix_exists_dir($dir){
    if(!is_dir($dir)){
        mkdir($dir, 0777, true);
    }
}

// renvoie uniquement le nom du fichier complet à partir de l'adresse
function fichier_seul($file){
    $file = preg_replace('/.*\//i', '', $file);
    return $file;	
}

function human_name($str){
    $t=explode(" ",str_replace(array("-","_",'.')," ",$str));
    for($i=0; $i<count($t);$i++){
        $t[$i]=ucfirst($t[$i]);
    }
    return implode(" ",$t);
}

function contenu_xml($source){
    $structure=array();
    $document_xml = new DomDocument(); 
    $document_xml->load($source);

    $champs = $document_xml->getElementsByTagName('item')->item(0)->childNodes;
    foreach ($champs as $champ){
        if ($champ->nodeType != XML_TEXT_NODE){ 
            $structure[$champ->nodeName]=$champ->nodeValue;
        } 
    }
    return $structure;
}
?>