<?php
/*
Fonctions d'affichage générales
en latéral ou frontal

Charger le fichier de surcharge éventuel
*/
if(file_exists(CHEMIN.DOSSIER_CUSTOM."custom-functions.php")){
    include(CHEMIN.DOSSIER_CUSTOM."custom-functions.php");
}
// afficher le contenu des pages (fichiers xml de contenus situées dans config/custom)
function display_page($page,$url){
    echo "<div class='p-3'>";
    echo display_buttons("edit_page('".$url."')",true); 
    echo "<h3 class=\"titre-small my-2\">".$page["titre"]."</h3>";
    echo "<div class=\"texte\">";
    echo $page["texte"];
    echo "</div>";
    echo "</div>";
}

// affiche chaque item dans la galerie générale
function display_mosaique_item($xml,$return=false){
    if(function_exists('display_mosaique_item_custom')){
        $item = display_mosaique_item_custom($xml,$return);
        if($return){
            return $item;
        } else {
            echo $item;
        }
    } else {
        $item = "<article class=\"col-12 col-sm-6 col-md-4 col-lg-3 col-xl-2 mb-3 item\" data-xml=\"".$xml->fichier_seul."\" data-mainillu=\"".$xml->get("illustration", IMG_DEFAULT)."\">\n";
        $item .= "<div class=\"mb-2\" onclick=\"item_click(this)\">\n";
        $item .= "<img class=\"img-fluid item-illu\" src=\"";
        $item .=donne_lien(IMG_DEFAULT,ILLU_WIDTH,ILLU_HEIGHT,true);
        $item .= "\" alt=\"\" data-source=\"";
                $item .= donne_lien(DOSSIER_FICHIERS.$xml->get("illustration", IMG_DEFAULT),ILLU_WIDTH,ILLU_HEIGHT,true);

        $item .= "\">\n";
        $item .= "</div>\n";

        $l=$xml->get_liste_pour_attribut("afficher","oui",array("illustration"));
        foreach($l as $tag){
            $item .= "<div class=\"tag-$tag\" data-contenu=\"$tag\">".flat_array($xml->get($tag))."</div>\n";
        }
        $item .= "</article>\n";
        if($return){
            return $item;
        } else {
            echo $item;
        } 
    }
}

// affiche le contenu d'un xml dans l'espace latéral
function display_lateral_item($xml,$return=false){
    if(function_exists('display_lateral_item_custom')){
        $item = display_lateral_item_custom($xml,$return);
    } else {
        echo "<div class='px-3'>";
        echo display_buttons("item_edit('".$xml->fichier_seul."')",true);
        echo "<div class='viewer-main-illu-container'>";
        $original=donne_lien(DOSSIER_FICHIERS.$xml->get("illustration", IMG_DEFAULT),1200,1200,false);
        echo "<img class=\"img-fluid viewer-main-illu\" src=\"";
        echo $original;
        echo "\" alt=\"\" data-original=\"".$original."\">\n";
        echo "<div class=\"button button-back\" onclick=\"viewer_back_image();\"><i class=\"fas fa-arrow-left\"></i></div>";
        echo "</div>";

        foreach($xml->get_partial_contenu(array("illustration")) as $tag => $tag_contenu){
            echo $xml->display_tag($tag);
        }
        echo "</div>";

    }
}

// affiche la fiche complète en pleine page
function display_fullpage_item($xml){
    if(function_exists('display_fullpage_item_custom')){
        display_fullpage_item_custom($xml);
    } else {
        echo "<article class=\"row mx-0 h-100\">";
        echo "<div class=\"col-12 col-sm-9 p-0 p-md-3 mb-3 h-100 text-center\">\n";
        $original=donne_lien(DOSSIER_FICHIERS.$xml->get("illustration", IMG_DEFAULT),1200,1200,false);
        echo "<img class=\"img-fluid viewer-main-illu\" src=\"";
        echo $original;
        echo "\" alt=\"\" data-original=\"".$original."\">\n";
        echo "<div class=\"button button-back\" onclick=\"viewer_back_image();\"><i class=\"fas fa-arrow-left\"></i></div>";
        echo "</div>\n";
        echo "<div class='col-12 col-sm-3 p-0 pt-md-3 pr-md-3 mb-3 h-100vh'>";
        
        
        echo "<div class='pl-3'>".display_buttons("item_edit('".$xml->fichier_seul."')",true)."</div>";
        echo "<div class='mt-3'>";
    echo "<div class='px-3 content-scrollable'>";

        foreach($xml->get_partial_contenu(array("illustration")) as $tag => $tag_contenu){
            echo $xml->display_tag($tag);
        }

        echo "</div><div></div>"; 
        echo "<script>init_fullpage();</script>";
        echo "</article>";
    }
}
// affiche l'image et le titre en pleine page
function display_galerie_item($xml){
    if(function_exists('display_galerie_item_custom')){
        display_galerie_item_custom($xml);
    } else {
        echo display_buttons("item_edit('".$xml->fichier_seul."')",false);
        echo "<img src=\"";
        echo donne_lien(DOSSIER_FICHIERS.$xml->get("illustration", IMG_DEFAULT),1200,800,false);
        echo "\" class=\"\"></div><div class=\"item-info\"><div>";
        echo $xml->get("titre");
        echo "</div></div>";
    }
}

// affiche le contenu d'un xml dans l'espace latéral
function display_menu_collection($xml,$return=false){
    if(function_exists('display_lateral_collection_custom')){
        $item = display_menu_collection_custom($xml,$return);
    } else {
        
        echo "<div class='row'>";
        
        echo "<div class='viewer-main-illu-container col-auto'>";
        echo "<img class=\"img-fluid collection-illu mb-2\" src=\"";
        $c=new classe_xml(MODELE);
        $i=$xml->get_tag_array("items");
        $c->lire_xml(CHEMIN.DOSSIER_XML.$i[0]);
        echo donne_lien(DOSSIER_FICHIERS.$c->get("illustration", IMG_DEFAULT),400,200,true);
        echo "\" alt=\"\">\n";
        echo "</div><div class='col'>";
        
        echo '<div class="container-buttons"><div class="buttons-left"><div class="button button-edit" onclick="collection_edit(\''.$xml->fichier_seul.'\')"><i class="fas fa-pencil-alt"></i></div></div><div class="buttons-right"><div class="button button-close ml-3" onclick="collection_close();"><span class="titre-tiny">Close</span> <i class="fas fa-chevron-right"></i></div></div></div>';
        
        foreach($xml->get_partial_contenu(array("items")) as $tag => $tag_contenu){
            echo $xml->display_tag($tag);
        }
        echo "<div class=\"texte-small my-2\">".$xml->get_tag_nb("items"). " éléments</div>";
        
        $items=$xml->get_tag_array("items");
        echo "<div id='collection-items' class='d-none'>";
        foreach($items as $it){
            echo "<div class='collection-item'>".$it."</div>";
        }
        
        echo "</div></div></div>";

    }
}

// affichage des collections
function display_mosaique_collection($xml,$return=false){
    if(function_exists('display_mosaique_collection_custom')){
        $item = display_mosaique_collection_custom($xml,$return);
        if($return){
            return $item;
        } else {
            echo $item;
        }
    } else {
        $item = "<article class=\"col-6 col-sm-4 col-md-2 mb-3 collection\" data-xml=\"".$xml->fichier_seul."\" onclick=\"collection_click(this);\">\n";
        
        $item .= "<img class=\"img-fluid collection-illu mb-2\" src=\"";
        
        $c=new classe_xml(MODELE);
        $i=$xml->get_tag_array("items");
        $c->lire_xml(CHEMIN.DOSSIER_XML.$i[0]);
        
        $item .= donne_lien(DOSSIER_FICHIERS.$c->get("illustration", IMG_DEFAULT),400,300,true);
        $item .= "\" alt=\"\">\n";
        
        $item .= "<div class=\"titre-mini fat mb-1\">".$xml->get("titre")."</div>";
        $item .= "<div class=\"texte-small mb-1\">".$xml->get("tags")."</div>";
        $item .= "<div class=\"texte-small\">".$xml->get_tag_nb("items"). " éléments</div>";

        $item .= "</article>\n";
        if($return){
            return $item;
        } else {
            echo $item;
        } 
    }
}

// affichage des boutons avant-après-edit-close 
function display_buttons($url,$edit=false){
    $buttons="<div class=\"container-buttons\">";
    $buttons .="<div class=\"buttons-left\">";
    $buttons .="<div class=\"button button-prev\" onclick=\"item_precedent();\"><i class=\"fas fa-chevron-left\"></i></div>";
    $buttons .="<div class=\"button button-next\" onclick=\"item_suivant();\"><i class=\"fas fa-chevron-right\"></i></div>";

    if((isset($_SESSION['login']) || DEBUG) && $edit==true){
        $buttons .="<div class=\"button button-edit\" onclick=\"".$url."\"><i class=\"fas fa-pencil-alt\"></i></div>";
    } 
    $buttons .="</div><div class=\"buttons-right\">"; 
    $buttons .="<div class=\"button button-full\" onclick=\"openFullscreen();\" title=\"Plein écran\"><i class=\"fas fa-expand\"></i></div>";
    $buttons .="<div class=\"button icon-viewer icon-showgal\" title='Affichage en galerie' onclick=\"change_display('showgal');\"><img src='app/images/icon-gal.svg'></div>";
    $buttons .="<div class=\"button icon-viewer icon-showfull\" onclick=\"change_display('showfullpage');\" title='Affichage en pleine page'><img src='app/images/icon-full.svg'></div>";
    $buttons .="<div class=\"button icon-viewer icon-showlat\" onclick=\"change_display('showlateral');\" title='Affichage latéral'><img src='app/images/icon-lateral.svg'></div>"; 
    $buttons .="<div class=\"button button-close ml-3\" onclick=\"close_viewer();\"><span class=\"titre-tiny\">Close</span> <i class=\"fas fa-chevron-right\"></i></div></div></div>"; 
    return $buttons; 
}

function flat_array($c,$glu=", "){
    if(is_array($c)){
        $c=implode($glu,$c);
    }
    return $c;
}
?>