<?php
session_start();
function _high($page){
    if($page==basename($_SERVER['PHP_SELF'])){ echo " class='on'"; }
}

function affiche_menu_admin(){
    if (!isset($_SESSION['login']) && !isset($_SESSION['pwd'])) {
        include("menus/form-login.php");
    } else {
        include("menus/admin-menu.php");   
    }
}

function fix_exists_dir($dir){
    if(!is_dir($dir)){
        mkdir($dir, 0777, true);
    }
}
// - - - fonction de lecture / ecriture du xml 
function read_xml($file,$lurl=false){
    $contenu=json_decode(json_encode((array)simplexml_load_file($GLOBALS['root'].$file)),1);
    if($lurl){ $contenu['url']=$file;}
    return $contenu;
}

function contenu_xml($source){
    $structure=array();
    $document_xml = new DomDocument();
    $document_xml->load($source);

    $champs = $document_xml->getElementsByTagName('contenu')->item(0)->childNodes;
    foreach($champs as $champ){
        if ($champ->nodeType != XML_TEXT_NODE){ 
            $structure[$champ->nodeName]=$champ->nodeValue;
        }
    }
    return $structure;
}

// encode le xml sur base d'un array, la plupart du temps $_POST
function write_xml($contenus,$ecrase=false,$hometag="item"){
    if($hometag == "selection"){
        $dest = $GLOBALS['dossier_selections'];
    } else {
        $dest=$GLOBALS['dossier_xml']; 
    }

    fix_exists_dir($GLOBALS['root'].$dest); // creer le dossier de stockage xml s'il n'existe pas
    //print_r($structure);

    if($contenus['url']['value'] != ""){
        // retirer le path du xml et ne garde que son nom, le path sera ajouté au moment de l'écriture
        $nom=fichier_seul($contenus['url']['value']);
    } else {
        $nom=nettoie_lien($contenus['title']['value'])."_".hash('adler32', date("Y-m-d H:i:s")).".xml";
    }

    $type=$contenus['@attributes']['type'];

    unset($contenus['@attributes']);
    unset($contenus['url']);
    unset($contenus['definition']);

    $doc = new DOMDocument();
    $doc->formatOutput = true;
    $doc->encoding = "UTF-8";
    $item = $doc->createElement( $hometag );
    $item->setAttribute('type', $type);

    foreach($contenus as $tag => $contenu){
        // print_r($contenu);
        if(isset($contenu['value'])){
            if($contenu['value']!=""){
                if(is_array($contenu['value'])){
                    // type "multiple", prendre chaque item pour le rentrer
                    foreach($contenu['value'] as $e){
                        $elem = $doc->createElement( $tag );
                        $elem->appendChild(
                            $doc->createTextNode( $e )
                        );
                        $item->appendChild( $elem );
                    }
                } else {
                    // contenu unique, créer un noeud
                    $elem = $doc->createElement( $tag );
                    $elem->appendChild(
                        $doc->createTextNode( $contenu['value'] )
                    );
                    $item->appendChild( $elem );
                }
            }
        }
    }
    $doc->appendChild( $item );

    $doc->save($GLOBALS['root'].$dest.$nom);

    if($hometag=='item'){
        remove_cache("collection.html");
    } else {

        $savename=basename($nom, ".xml");

        remove_cache($savename.".html");
    }
    return $dest.$nom;

}
// - - - affichage des elements
function deployer_info($item=array(),$definition=false){
    $code="";
    $contenus = structured_item($item,$definition);
    unset($contenus["@attributes"]);
    unset($contenus["url"]);
    unset($contenus["definition"]);

    $code .= "<ul class='info-container'>\n";
    foreach($contenus as $tag => $contenu){
        if(!empty($contenu['value'])){
            $type= $contenu['@attributes']['type'];

            if(isset($contenu['@attributes']['multiple'])){
                $multiple="multiple clearfix";
            } else {
                $multiple="unique";
            }

            $code .="<li class='display display-$tag $type $multiple' title='"._esc($contenu['@attributes']['titre'])."'>\n";

            if(isset($contenu['@attributes']['multiple'])){
                $code.="<label>".$contenu['@attributes']['titre']."</label>";
            }
            
            if(!is_array($contenu['value'])){
                $code .= "<div class='info-content $tag'>\n";
                $code.= value_html($contenu['value'],$type);
                $code .= "</div>\n";
            } else {
                foreach($contenu['value'] as $part){
                    if(!empty($part)){
                        $code .= "<div class='info-content $tag'>\n";
                        $code.= value_html($part,$type);
                        $code .= "</div>\n";
                    }
                }
            }


            $code .="</li>\n";
        }
    }
    $code .="</ul>\n";
    return $code;
}

function value_html($contenu, $type){
    $ext = pathinfo($contenu, PATHINFO_EXTENSION);
    $icon_class=icone_doc($ext);

    switch ($type){
        case 'image':
            $code = "<img src='".donne_lien($contenu,$l_vignette=600,$h_vignette=600,false)."' data-original='$contenu' class='adapt'>";
            break;
        case 'file':
            $code = "<a href='".$contenu."' target='_blank'><i class='fa ".$icon_class."' aria-hidden='true'></i> ".cutname($contenu)."</a>";
            break;

        default:
            $code= $contenu;
    }
    return $code;

}


/*
structured_item($item,$definition=false)
reçoit :
$item est soit vide, soit une string qui est l'adresse d'un xml, soit un array avec des contenus
$definition est soit vide (le xml de définition par défaut est employé) soit l'adresse du xml de définition (dans custom/elements)

renvoie un array structuré correspondant à la définition du xml
vide si $item est vide
rempli avec les données de $item s'il a été défini

*/

function structured_item($item,$definition=false) {
    if(is_array($item)){
        $contenu=$item;
        $item=$item['url'];
    } else if($item==""){
        $contenu=array();
    } else {
        $contenu=read_xml($item,true);
    }

    //print_r($contenu);
    if(!$definition){
        $definition=$GLOBALS['definition_item'];
    }
    $structure=read_xml($definition);

    //print_r($structure);
    // ajouter le contenu dans la structure
    foreach($structure as $cle => $valeur){
        if(isset($contenu[$cle])){
            //if(!empty($contenu[$cle] && )){
            // echo "contenu de ".$cle." est ".$contenu[$cle]."\n";
            $structure[$cle]['value']=$contenu[$cle];
        } else {
            $structure[$cle]['value']="";
        }
        // supprimer cette clé du contenu
        // pour pouvoir dans un deuxième temps
        // ajouter les contenus éventuellement ajoutés librement 
        // sans référence dans la définition du xml
        unset($contenu[$cle]);
    }
    // ajouter les champs trouvé hors définition dans le contenu
    // par exemple <truc>contenu du truc</truc>
    foreach($contenu as $cle => $valeur){
        $structure[$cle]['@attributes']['type']='unknow';
        $structure[$cle]['@attributes']['titre']=$cle;
        if(is_array($contenu[$cle])){
            foreach($contenu[$cle] as $ar_item){
                $structure[$cle]['value'][]=$ar_item;
            }
        } else {
            $structure[$cle]['value']=$contenu[$cle];
        }
    }

    // ajouter l'url du contenu à toutes fins utiles
    $structure['url']['@attributes']['type']='hidden';
    $structure['url']['@attributes']['titre']='Url';
    $structure['url']['value']=$item;

    // ajouter l'url de description à toutes fins utiles
    $structure['definition']['@attributes']['type']='hidden';
    $structure['definition']['@attributes']['titre']='definition';
    $structure['definition']['value']=$definition;

    return $structure;
}

function remove_cache($file="collection.html"){
    $l=$GLOBALS['root'].$GLOBALS['dossier_cache'].$file;
    if(file_exists($l)){
        unlink($l);
    }
}

// - - - fonction de test et de traitements d'info image

function fichier_seul($file){
    $file = preg_replace('/.*\//i', '', $file);
    return $file;	
}

function stripAccents($string){
    $str = htmlentities($string, ENT_NOQUOTES, 'UTF-8');
    $str = preg_replace('#\&([A-za-])(?:acute|cedil|circ|grave|ring|tilde|uml)\;#', '\1', $str);
    $str = strtolower(str_replace(" ","_",$str));
    $str = str_replace(array("#","'",'"'),"",$str);
    return $str;
}

function _c($source,$valeur,$defaut=null,$titre=null){

    if(isset($source[$valeur]) && !empty($source[$valeur])){
        if(!is_array($source[$valeur])){
            if($titre){ $source[$valeur]= $titre.$source[$valeur]; }
            return $source[$valeur]; // htmlspecialchars($source[$valeur],ENT_QUOTES); 
        } else {
            // c'est un array
            // pour le moment ne rien envoyer
            return "";
        }
    } else {
        if($defaut){
            if($titre){ $defaut=$titre.$defaut; }
            return $defaut;
        } else {
            return "";   
        }
    }
}

function _esc($texte){
    return htmlspecialchars($texte,ENT_QUOTES);
}

// ne garde que les lettres d'une chaine de texte
function nettoie_lien($texte){
    $texte = preg_replace("#[^a-zA-Z]#", "", $texte);
    return $texte;
}

// donne lien : reçoit une adresse de fichier et une taille, verifie si une vignette a cette taille existe et produit une version de cette image le cas échaant renvoie cette adresse
function donne_lien($file,$l_vignette=600,$h_vignette=600,$crop=true){
    // creer le dossier pour les images petites
    fix_exists_dir($GLOBALS['root'].$GLOBALS['dossier_vignettes']);

    if(!is_file($GLOBALS['root'].$file)){ 
        $file="img-default/default.jpg"; 
    }
    $ext_image=array('jpg','png','gif');
    $ext=strtolower(substr(strrchr($file,"."),1));
    $add="_".$l_vignette."_".$h_vignette;
    $nom=fichier_seul($file);
    $local_name=$GLOBALS['dossier_vignettes'].$nom.$add.".".$ext;

    // - - - image : traitement des icones
    if(in_array($ext,$ext_image)){
        // charger l'image brute
        // vérifier que l'image existe
        // sinon la créer
        if (!file_exists($GLOBALS['root'].$local_name)) {
            if(image_resize($GLOBALS['root'].$file, $GLOBALS['root'].$local_name, $l_vignette, $h_vignette, $crop)){
                return $local_name."?".filectime($GLOBALS['root'].$local_name);
            } else {
                return $file."?".filectime($GLOBALS['root'].$file);
            }
        } else {
            return $local_name."?".filectime($GLOBALS['root'].$local_name);   
        }

    } else {
        return "img_sys/error.jpg";   
    }
    // - - - - fin traitement des images   

}

function image_resize($src, $dst, $width=500, $height=400, $crop=0){

    ini_set('memory_limit', '256M');
    if(!list($w, $h) = getimagesize($src)) {
        echo "image does not exists";
        return false;
    }

    $type = strtolower(substr(strrchr($src,"."),1));
    if($type == 'jpeg') $type = 'jpg';
    switch($type){
        case 'gif': $img = imagecreatefromgif($src); break;
        case 'jpg': $img = imagecreatefromjpeg($src); break;
        case 'png': $img = imagecreatefrompng($src); break;
        default : echo "image does not exists"; return false;
    }

    // resize
    if($crop){
        if($w < $width or $h < $height){ 
            return false;
        };

        $ratio = max($width/$w, $height/$h);
        $y= ($h - $height / $ratio) /2;
        $x = ($w - $width / $ratio) / 2;
        $h = $height / $ratio;
        $w = $width / $ratio;

    }
    else{
        if($w < $width and $h < $height) {
            return false;
        }

        $ratio = min($width/$w, $height/$h);
        $width = $w * $ratio;
        $height = $h * $ratio;
        $x = 0;
        $y = 0;
    }

    $new = imagecreatetruecolor($width, $height);

    // preserve transparency
    if($type == "gif" or $type == "png"){
        imagecolortransparent($new, imagecolorallocatealpha($new, 0, 0, 0, 127));
        imagealphablending($new, false);
        imagesavealpha($new, true);
    }
    imagecopyresampled($new, $img, 0, 0, $x, $y, $width, $height, $w, $h);
    switch($type){
        case 'gif': imagegif($new, $dst); break;
        case 'jpg': imagejpeg($new, $dst); break;
        case 'png': imagepng($new, $dst); break;
    }
    return true;
}

// - - - formulaires

function deployer_formulaire_item($it="",$action,$definition=false,$ecrire_form=true){
    // entete du formulaire

    $item = structured_item($it,$definition);
    //print_r($item);

    // supprimer de l'affichage du formulaire les champs demandés
    if(isset($action['supprimer_champs'])){
        // c'est un array
        foreach($action['supprimer_champs'] as $champ){
            unset($item[$champ]);
        }
    }

    $code="";
    if($action['titre']){
        $code .= "<header>\n<h2>".$action['titre']."</h2>\n</header>\n";
    }
    $code .= $action['addtop'];

    unset($item["@attributes"]);

    $code .= "<div class=\"form\">";
    if($ecrire_form){
        $code .="<form class=\"toplabel\" method=\"post\" enctype=\"multipart/form-data\">";
    }
    foreach($item as $nom => $champ){

        $code .= "<fieldset class='".$champ['@attributes']['type']." ".$nom."'>\n";
        $code .="<label for='".$nom."'>".$champ['@attributes']['titre']."</label>\n";

        // element multiple
        // attention, un element non référencé dans le xml de description
        // peut etre multiple. 
        // il faut pouvoir le détecter.
        if(isset($champ['@attributes']['multiple']) && !empty($champ['value']) || $champ['@attributes']['type'] == 'unknow'){

            if(!is_array($champ['value'])){
                // un seul élément disponible
                $code .= value_html_form($nom, $champ, false, $item["url"]["value"]); 
            } else {
                // element multiple (array)
                //print_r($champ['value']);

                foreach($champ['value'] as $num => $array_elem){
                    $tvalue=$champ['value'][$num];
                    $tchamp=$champ;
                    $tchamp['value']=$tvalue;
                    $code .= value_html_form($nom, $tchamp, true, $item["url"]["value"]);
                }
            }
        } else {
            // element simple (une seule valeur)
            if(is_array($champ['value'])){ 
                $champ['value']=implode("",$champ['value']); 
            } // evite un bug : les champ vides sont identifiés comme array
            $code .= value_html_form($nom, $champ, false, $item["url"]["value"]);
        }

        // ne montrer le formulaire que si 
        // le type est file
        // l'attribut multiple est présent
        // multiple n'est pas la mais il n'y a pas de doc affiché

        if(($champ['@attributes']['type']== 'file' || $champ['@attributes']['type']== 'image') && !isset($champ['@attributes']['multiple']) && empty($champ['value'])){
            $code .= "<p class='file-input-$nom'><input type='file' name='".$nom."[]' value=''></p>";
        } else if($champ['@attributes']['type']== 'file' || $champ['@attributes']['type']== 'image'){
            $code .= "<p class='file-input-$nom' style='display:none;'><input disabled='disabled' type='file' name='".$nom."[]' value=''></p>";
        }

        // bouton plus si on a affaire à un champ multiple 
        if(isset($champ['@attributes']['multiple'])){
            // bouton d'ajout
            $code .= "<div class='action-duplicate'><div class='bouton bouton-plus' data-duplicate='.file-input-$nom'>+</div></div>";
        }
        $code .= "</fieldset>\n";
    }

    $code .="<input type='hidden' name='".$action['traitement']."' value='oui'>";

    if($ecrire_form){
        $code .= "<input type=\"submit\" name=\"action\" value=\"".$action['submit']."\">";
        $code .= "</form>";
    }
    $code .= $action['addbottom'];
    return $code;
}


function value_html_form($titre, $champ, $multiple=false, $url_item=""){
    if(isset($champ['@attributes']['class'])) {
        $addclass=" ".$champ['@attributes']['class'];
    } else {
        $addclass="";
    }
    if($multiple){
        $code="<div class='file-item multiple'>";
    } else {
        $code="<div class='file-item unique'>";
    }

    if($multiple){ $add="[]"; } else { $add=""; }
    switch($champ['@attributes']['type']) {
        case 'image':
            
            if(!empty($champ['value'])){
                $code .= "<input type='hidden' name='".$titre.$add."' value='".$champ['value']."'>";
                $ext = pathinfo($champ['value'], PATHINFO_EXTENSION);
                switch ($ext){
                    case 'jpg':
                    case'gif':
                    case 'png':
                        $code .=  "<img src='".donne_lien($champ['value'],$l_vignette=600,$h_vignette=600,false)."' data-original='".$champ['value']."' class='adapt'>";
                        $code .=  "<div class='tools-image item-tools' data-item='".$url_item."'>";
                        $code .= "<a href='javascript:image_rotate(\"".$champ['value']."\",90,\"".$url_item."\");'><i class='fa fa-undo' class='icon-rotate'></i></a> <a href='javascript:image_rotate(\"".$champ['value']."\",-90,\"".$url_item."\");' class='icon-rotate'><i class='fa fa-repeat'></i></a>";
                        $code .="<label for='".$titre."|".$champ['value']."' class='icon-delete carefull' onClick='visible_check(this)'><i class='fa fa-times'></i></label><input type='checkbox' name='doc-delete[]' id='".$titre."|".$champ['value']."' value='".$titre."|".$champ['value']."'>";
                        $code .=  "</div>";
                        // <a href='javascript:image_delete(\"".$champ['value']."\",\"".$url_item."\");' class='icon-delete carefull'><i class='fa fa-times'></i></a>
                        break;
                }
            }
            break;
        case 'file':
            $code .= "<input type='hidden' name='".$titre.$add."' value='".$champ['value']."'>";
            // creer un hash pour placer dans le value le type et le nom
            // pour un meilleur process

            // en fait, détecter l'extension et placer le systeme d'image si on a affaire à un png, jpg, gif
            // ça permettra de simplifier le fonctionnement

            if(!empty($champ['value'])){
                $ext = pathinfo($champ['value'], PATHINFO_EXTENSION);
                $icon_class=icone_doc($ext);

                $code .= "<div class='form-doc-line'><i class='fa ".$icon_class."' aria-hidden='true'></i>
".cutname($champ['value'])."<label for='".$titre."|".$champ['value']."' class='icon-delete carefull' onClick='visible_check(this)'><i class='fa fa-times'></i></label><input type='checkbox' name='doc-delete[]' value='".$titre."|".$champ['value']."' id='".$titre."|".$champ['value']."'></div>";
                break;
            }

            break;
        case 'select':
            $options=explode("|",$champ['@attributes']['options']);
            $code .= "<select name='".$titre.$add."'>\n";
            foreach($options as $option){
                $code.= "<option value='".$option."'";
                if($option == $champ['value']){
                    $code .=" selected='selected'";
                }
                $code .=">".$option."</option>\n";
            }
            $code .= "</select>\n";
            break;
        case 'textarea':
            $code .= "<textarea class='form-textarea$addclass' name='".$titre.$add."'>".$champ['value']."</textarea>\n";
            break;
        default:
            $code .= "<input class='form-text$addclass' type='text' name='".$titre.$add."' value='".$champ['value']."'>\n";
            break;
    }

    // fin du champ
    $code.="</div>";

    return $code;
}

function icone_doc($ext){
    $exts=array(
        "fa-file-image-o" => array("jpg","png","eps","gif","tif","psd"),
        "fa-file-pdf-o" => array("pdf"),
        "fa-file-audio-o" => array("mp3","aif","wav"),
        "fa-file-video-o" => array("mp4","mkv","avi","m4v"),
        "fa-file-archive-o" => array("zip","rar")
    );
    $icon_class="fa-file-o";

    foreach($exts as $x => $v){
        if(in_array($ext,$v)){
            $icon_class=$x;
        }
    }
    return $icon_class;


}

function cutname($nom,$limit=35){
    $nom=basename($nom);

    if(strlen($nom) >= $limit){
        $nom=substr($nom,0, $limit-5)."...".substr($nom,-4);
    }
    return $nom;
}

function deployer_formulaire_selection($item=array(),$action){
    // entete du formulaire

    $item = structured_item($item,$GLOBALS['definition_selection']);
    unset($item["@attributes"]);

    $code = "<header>\n<h2>".$action['titre']."</h2>\n</header>\n";
    $code .= $action['addtop'];
    $code .= "<div class=\"form\">
        <form class=\"toplabel\" method=\"post\" enctype=\"multipart/form-data\">";

    // charger l'info s'il y a lieu
    if(!empty($item)){
        $code .= "<input type='hidden' name='url' value='".$item['url']['value']."'>\n";
    } 

    //print_r($item);

    foreach($item as $nom => $champ){

        $code .= "<fieldset class='".$champ['@attributes']['type']." ".$nom."'>\n";
        $code .="<label for='".$nom."'>".$champ['@attributes']['titre']."</label>\n";

        // element multiple
        // attention, un element non référencé dans le xml de description
        // peut etre multiple. 
        // il faut pouvoir le détecter.

        // cas très particulier : la liste d'item
        if($nom=='item'){
            // le code html de récepteur
            // la liste des items dedans avec le code de suppression
            $code .= "<div class=\"form-part open\" id=\"edit-items\">
            <header class=\"form-part-head\">
                <h3><a href=\"javascript:form_showhide('#edit-items');\"><i class=\"fa fa-chevron-right fa-fw fa-rotate-90\"></i> Items <span id=\"compteur\">(0)</span></h3></a>
            </header>
            <div class=\"form-part-content\" id=\"sortable\">";



            if(isset($item['item'])){
                $code .= "<script>";

                if(!is_array($champ['value'])){
                    $champ['value']=array($champ['value']);
                } 

                foreach($champ['value'] as $num => $item_url){
                    $code .= "manage_multi_selected_item('".$item_url."');";
                    //echo "$(\"#main-list li[data-url='".$item_url."']\").click();\n";
                }

                $code .= "</script>";
            }

            $code .= "</div>
        </div>";
        } else {
            if(isset($champ['@attributes']['multiple']) && !empty($champ['value']) || $champ['@attributes']['type'] == 'unknow'){

                if(!is_array($champ['value'])){
                    // un seul élément disponible
                    $code .= value_html_form($nom, $champ, false, $item["url"]["value"]); 
                } else {
                    // element multiple (array)
                    //print_r($champ['value']);

                    foreach($champ['value'] as $num => $array_elem){
                        $tvalue=$champ['value'][$num];
                        $tchamp=$champ;
                        $tchamp['value']=$tvalue;
                        $code .= value_html_form($nom, $tchamp, true, $item["url"]["value"]);
                    }
                }
            } else {
                // element simple (une seule valeur)
                if(is_array($champ['value'])){ 
                    $champ['value']=implode("",$champ['value']); 
                } // evite un bug : les champ vides sont identifiés comme array
                $code .= value_html_form($nom, $champ, false, $item["url"]["value"]);
            }

            // ne montrer le formulaire que si 
            // le type est file
            // l'attribut multiple est présent
            // multiple n'est pas la mais il n'y a pas de doc affiché

            if(($champ['@attributes']['type']== 'file' || $champ['@attributes']['type']== 'image') && !isset($champ['@attributes']['multiple']) && empty($champ['value'])){
                $code .= "<p class='file-input-$nom'><input type='file' name='".$nom."[]' value=''></p>";
            } else if($champ['@attributes']['type']== 'file' || $champ['@attributes']['type']== 'image'){
                $code .= "<p class='file-input-$nom' style='display:none;'><input disabled='disabled' type='file' name='".$nom."[]' value=''></p>";
            }

            // bouton plus si on a affaire à un champ multiple 
            if(isset($champ['@attributes']['multiple'])){
                // bouton d'ajout
                $code .= "<div class='action-duplicate'><div class='bouton bouton-plus' data-duplicate='.file-input-$nom'>+</div></div>";
            }
        }
        $code .= "</fieldset>\n";
    }



    //deployer_champs($item, $GLOBALS['root'].$GLOBALS['definition_selection']);
    $code .= $action['addbottom'];
    $code .= "            <p>
                <input type=\"submit\" name=\"".$action['traitement']."\" value=\"".$action['submit']."\">
            </p>
        </form>";

    return $code;
}

function deployer_champs($item=array(),$definition){
    $xml = simplexml_load_file($definition);
    foreach($xml->children() as $champ) {

        $titre = $champ->attributes()->titre;
        $type = $champ->attributes()->type;

        echo "<fieldset class='".$type."'>\n<label for='".$champ->getName()."'>".$titre."</label>\n";

        if($type=="text"){
            echo "<input class='form-text' type='text' name='".$champ->getName()."' value='"._c($item,$champ->getName())."'>\n";
        }
        if($type=="textarea"){
            echo "<textarea name='".$champ->getName()."'>"._c($item,$champ->getName())."</textarea>\n";
        }
        /*
        if($type=="select"){
            echo "<select name='".$champ->getName()."'>\n";
            $t=_c($item,$champ->getName());
            foreach($champ->children() as $option) {
                echo "<option name='".$option."' ";
                if($t==$option){
                    echo " selected='selected'";
                }
                echo ">".$option."</option>\n";
            }
            echo "</select>\n";
        }
        */
        if($type=="image"){
            if(_c($item,$champ->getName())){
                deployer_form_image($champ->getName(),_c($item,$champ->getName()),$item['url']);

            } else {
                echo "<input class='upload-input' multiple='' name='".$champ->getName()."' type='file'>";
            }
        }

        if($type=="item"){
            // le code html de récepteur
            // la liste des items dedans avec le code de suppression

            echo "<div class=\"form-part open\" id=\"edit-items\">
            <header class=\"form-part-head\">
                <h3><a href=\"javascript:form_showhide('#edit-items');\"><i class=\"fa fa-chevron-right fa-fw fa-rotate-90\"></i> Items <span id=\"compteur\">(0)</span></h3></a>
            </header>
            <div class=\"form-part-content\">";


            if(isset($item['item'])){
                echo "<script>";
                if(is_array($item['item'])){
                    foreach($item['item'] as $item_url){
                        echo "manage_multi_selected_item('".$item_url."');";
                        //echo "$(\"#main-list li[data-url='".$item_url."']\").click();\n";
                    }
                } else {
                    echo "manage_multi_selected_item('".$item_url."');";
                    //echo "$(\"#main-list li[data-url='".$item['item']."']\").click();\n";
                }
                echo "</script>";
            }



            echo "</div>
        </div>";


        }

        if($type=="file"){
            $allow = $champ->attributes()->allow;
            // recuperer tous les éléments du xml qui correspondent
            if(isset($item["file"])){
                if(!is_array($item["file"])){
                    $item["file"]=array($item["file"]);
                }
                deployer_files($item['file'],$item['url'],1);
            }
            // afficher le form d'ajout
            echo "<input type='file' class='upload-input' multiple='' name='file[]' accept='".$allow."' >";
            echo "fichier de type ".$allow;
        }



        if($type=="date_creation"){
            echo "<input class='form-text' type='text' name='".$champ->getName()."' value='"._c($item,$champ->getName(),date("Y/m/d H:i:s"))."'>\n";
        }

        if($type=="date"){
            echo "<input class='form-text' type='text' name='".$champ->getName()."' value='"._c($item,$champ->getName())."'>\n";
        }

        echo "</fieldset>\n";
    }

}

/*  - - - - - - traitement des uploads des docs */
function traiter_upload_doc($upload){
    $retour=-1;

    if(is_array($upload['tmp_name'])){
        // plusieurs fichiers
        $retour=array();

        foreach($upload['name'] as $num => $nom){
            if(!empty($upload['name'][$num])){
                $single=array('name'=> $upload['name'][$num],
                              'type'=> $upload['type'][$num],
                              'tmp_name'=> $upload['tmp_name'][$num],
                              'error'=> $upload['error'][$num],
                              'size'=> $upload['size'][$num]
                             );

                $retour[]=traiter_upload_doc_unique($single);
            }
        }


    } else {
        // un seul fichier
        if(!empty($upload['name'])){
            $retour=array();
            $retour[]=traiter_upload_doc_unique($upload);
        }
    }

    return $retour;
}

function traiter_upload_doc_unique($upload){
    fix_exists_dir($GLOBALS['root'].$GLOBALS['dossier_images']);
    $tempFile = $upload['tmp_name'];
    // Validate the file type
    $fileTypes = explode(",",$GLOBALS['docs_allowed']);// par ex ('pdf','zip', 'jpg', 'png', 'gif'); // File extensions
    $fileParts = pathinfo($upload['name']);

    if (in_array($fileParts['extension'],$fileTypes)) {
        $ext = pathinfo($upload['name'], PATHINFO_EXTENSION);  //figures out the extension 
        $nom_seul=stripAccents($fileParts['filename']);

        // ici tester le nom du fichier pour permettre les doublons
        if(file_exists($GLOBALS['root'].$GLOBALS['dossier_images'].$nom_seul.".".$ext)){
            $ad= hash('adler32', date("Y-m-d H:i:s"));
            $nom_seul=$nom_seul."_".$ad; // ce serait mieux entre le nom et l'extension
        }

        $retour=$GLOBALS['dossier_images'].$nom_seul.".".$ext;
        move_uploaded_file($tempFile, $GLOBALS['root'].$GLOBALS['dossier_images'].$nom_seul.".".$ext);

        return $retour;

    } else {
        return -1;
    }


}

function traiter_rotation_image($filename, $degrees){
    $new_file=$filename; // au même endroit
    $rotang = $degrees;

    $fileParts = pathinfo($filename);

    $versions=glob($GLOBALS['root'].$GLOBALS['dossier_vignettes'].$fileParts['basename']."*");
    foreach ($versions as $version){
        unlink($version); 
    }
    // virer les versions de cette images dans les vignettes !
    // sinon le travail sera invisible...

    list($width, $height, $type, $attr) = getimagesize($filename);
    $size = getimagesize($filename);


    switch($size['mime']){
        case 'image/jpeg':
            $source =imagecreatefromjpeg($filename);
            $bgColor=imageColorAllocateAlpha($source, 0, 0,0, 0);
            $rotation = imagerotate($source,$rotang,$bgColor);
            imagealphablending($rotation, false);
            imagesavealpha($rotation, true);
            imagecreate($width,$height);
            imagejpeg($rotation,$new_file);
            chmod($filename, 0777);
            break;
        case 'image/png':

            $source =imagecreatefrompng($filename);
            $bgColor=imageColorAllocateAlpha($source, 0, 0,0, 0);
            $rotation = imagerotate($source,$rotang,$bgColor);
            imagealphablending($rotation, false);
            imagesavealpha($rotation, true);
            imagecreate($width,$height);
            imagepng($rotation,$new_file);
            chmod($filename, 0777);
            break;
        case 'image/gif':

            $source =imagecreatefromgif($filename);
            $bgColor=imageColorAllocateAlpha($source, 0, 0,0, 0);
            $rotation = imagerotate($source,$rotang,$bgColor);
            imagealphablending($rotation, false);
            imagesavealpha($rotation, true);
            imagecreate($width,$height);
            imagegif($rotation,$new_file);
            chmod($filename, 0777);
            break;
        case 'image/vnd.wap.wbmp':
            $source =imagecreatefromwbmp($filename);
            $bgColor=imageColorAllocateAlpha($source, 0, 0,0, 0);
            $rotation = imagerotate($source,$rotang,$bgColor);
            imagealphablending($rotation, false);
            imagesavealpha($rotation, true);
            imagecreate($width,$height);
            imagewbmp($rotation,$new_file);
            chmod($filename, 0777);
            break;
    }

}

function deployer_files($files,$item_url,$admin=0){
    $infos=array();
    $ext_image=array('jpg','png','gif');
    $ext_video=array('avi','mp4','mkv','m4v');
    $ext_autre=array('zip','txt','rtf','pdf','doc','msi','rar','dmg','js');
    $ext_son=array('mp3','aac','ogg');

    foreach($files as $file){
        $ext=strtolower(substr(strrchr($file,"."),1));
        if(in_array($ext,$ext_image)){
            $infos['Images'][]=$file;
        }
        if(in_array($ext,$ext_son)){
            $infos['Sons'][]=$file;
        }
        if(in_array($ext,$ext_autre)){
            $infos['Download'][]=$file;
        }
        if(in_array($ext,$ext_video)){
            $infos['Vidéos'][]=$file;
        }
    }

    echo "<ul class='file-list'>";
    // afficher ces trucs
    if (array_key_exists('Images', $infos)) {
        foreach($infos['Images'] as $image){
            echo "<li><a href='".$image."' class='fancybox file-icone' rel='same'><img src='".donne_lien($image,$l_vignette=60,$h_vignette=60,true)."' alt='image'></a>";
            echo "<span>".fichier_seul($image)."</span>";
            if($admin!=0){
                echo "<a href='javascript:doc_delete(\"".$image."\",\"".$item_url."\");' class='file-delete'><i class='fa fa-times'></i></a>";
            }
            echo "<input type='hidden' name='file[]' value='".$image."'>";
            echo"</li>";
        }
    }

    // autres
    $liste_type=array('Sons','Vidéos','Download');

    foreach($liste_type as $type){
        if (array_key_exists($type, $infos)) {
            foreach($infos[$type] as $lien){
                echo "<li><a href='".$lien."' class='file-icone'>".$GLOBALS['icone'][$type]."</a>";
                echo "<span>".fichier_seul($lien)."</span>";

                if($admin!=0){
                    echo "<a href='javascript:doc_delete(\"".$lien."\",\"".$item_url."\");' class='file-delete'><i class='fa fa-times'></i></a>";
                }
                echo "<input type='hidden' name='file[]' value='".$lien."'>";

                echo "</li>";
            }

        }
    }
    echo "</ul>";

}

// - - - timer 

class loadTime {
    var $timestart;
    var $digits;

    public function __construct($digits = ""){
        $this->timestart    = explode (' ', microtime());
        $this->digits       = $digits;
    }

    public function finit(){
        $timefinish         = explode (' ', microtime());
        if($this->digits == ""){
            $runtime_float  = $timefinish[0] - $this->timestart[0];
        }else{
            $runtime_float  = round(($timefinish[0] - $this->timestart[0]), $this->digits);
        }
        $runtime = ($timefinish[1] - $this->timestart[1]) + $runtime_float;
        echo "Page exécutée en $runtime secondes\n";
    }
} 

?>