<?php
include("custom/config.php");
include($GLOBALS['root']."includes/inc-functions.php");
include_once($GLOBALS['root'].'includes/inc-headers-process.php');
include_once($GLOBALS['root'].'includes/inc-header.php');
?>
<header id="main-header" class="clearfix">
    <h1 class="colonne full nobottom"><a href="./"><?php echo $GLOBALS['titre']; ?></a></h1>

    <div id="main-nav" class="colonne full padlat clearfix">
        <nav class="breadcrumb colonne demi nopad">
            <?php include("menus/base-menu.php"); ?>
        </nav>

        <nav class="breadcrumb colonne demi nopad adminnav">
            <a href="index.php">Retour</a> / 
            <a class="ajax-load" href="index.php?action=logout" data-load="ajax/ajax-logout.php" data-class="standard" data-cas="logout">logout</a>
        </nav>
    </div>
    <div class="sep"></div>
    <script>
        init_admin_nav();
    </script>
</header>

<div id="liste" class="colonne deuxtiers clearfix">

    <section class="content-display" id="mosaic">
        <h2>Liste des fichiers disponibles "Upload"</h2>

        <table id="table">
            <thead>
                <tr>
                    <td>Nom</td>
                    <td>Taille</td>
                    <td>Extension</td>
                    <td>Traiter</td>
                </tr>
            </thead>
            <?php
            $liste= glob($GLOBALS['root']."upload/*", GLOB_BRACE);

            $accept_list=array("jpg","png","gif","jpeg");


            foreach($liste as $image){
                $infos=pathinfo($image);
                $taille=formatSizeUnits(filesize($image));

                if(in_array(strtolower($infos['extension']),$accept_list)){
                    $classe="ok";
                    $check=" checked='checked'";
                } else {
                    $classe="attention";
                    $check="";

                }

                echo "<tr class='$classe'><td>".$infos['basename']."</td><td>".$taille."</td><td>".$infos['extension']."</td><td><input name='images[]'class ='choose' data-url='$image' type='checkbox'$check></td></tr>";
            }

            ?>
        </table>
    </section>
</div>
<div class="colonne tiers">
    <?php
    $action=array(
        "titre"=>"Informations communes",
        "submit"=>"Ajouter les items",
        //"traitement"=>"import_images",
        "traitement"=>"ajouter_upload", // traitement individualisé, donc ajouter_item


        "addtop"=>"<div class='cadre-info'>Placez les images dans un dossier \"upload\" puis validez le formulaire.<br>Les informations entrées ci-dessous seront ajoutées à tous les documents</div>",
        "addbottom"=>"",

        // ne pas afficher les champs illustration, galerie et file
        "supprimer_champs"=> array("illustration","galerie","file")
    );

    echo deployer_formulaire_item("",$action);
    ?>
</div>

<script>

    $(document).ready(function(){
        // pour chaque image, envoyer le form
        $('.form form').on('submit', function(e) {
            var $this = $(this); // L'objet jQuery du formulaire
            $this.append("<input type='hidden' name='ajouter_upload' value='oui'>");
            e.preventDefault(); // J'empêche le comportement par défaut du navigateur, c-à-d de soumettre le formulaire

            var formData = new FormData($(this)[0]);
            var c=0;

            $(".choose:checked").each(function(){
                var ligne=$(this).parent().parent();
                var lim=$(this).attr("data-url");
                formData.append( 'illustration' , lim );
                formData.append( 'compteur' , c );
                c++;

                // alert("go for "+lim);
                //var formDataPlus=formData.append( 'name' , value );
                // Envoi de la requête HTTP en mode asynchrone
                $.ajax({
                    url: "ajax/ajax-forms.php", // Le nom du fichier indiqué dans le formulaire
                    type: "post", // La méthode indiquée dans le formulaire (get ou post)
                    data: formData, //$this.serialize(), // Je sérialise les données (j'envoie toutes les valeurs présentes dans le formulaire)
                    async: false,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(html) { // Je récupère la réponse du fichier PHP : l'adresse du fichier
                        //alert(html);
                        ligne.slideUp("fast",function(){ligne.remove();});
                        //item_vignette_ajouter(html);
                        //window.location.href = "index.php";
                        $(ligne).html("<tr><td>Okay</td></tr>");
                    }
                });
            });

            quicksearch.cache();
            //$("#bouton-fullwidth").click();
            //var data = new FormData( $('#form')[0] ).append( 'name' , value );


        });
    });
</script>
<?php
include_once($GLOBALS['root'].'includes/inc-footer.php');

function formatSizeUnits($bytes) {
    if ($bytes >= 1073741824){
        $bytes = number_format($bytes / 1073741824, 2) . ' GB';
    } elseif ($bytes >= 1048576) {
        $bytes = number_format($bytes / 1048576, 2) . ' MB';
    } elseif ($bytes >= 1024)  {
        $bytes = number_format($bytes / 1024, 2) . ' kB';
    }  elseif ($bytes > 1) {
        $bytes = $bytes . ' bytes';
    } elseif ($bytes == 1) {
        $bytes = $bytes . ' byte';
    } else {
        $bytes = '0 bytes';
    }

    return $bytes;
}
?>

